/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;

/**
 * Mapping details.
 */
@SuppressWarnings("unused")
public class Map implements IZITravelEntity {
    private static final long serialVersionUID = -7351143801283559754L;

    /**
     * Surface bounds for a MTGObject. E.g., bounds for a tour route. The maximum extent of the
     * rendered map area. Bounds must define an area covered by all zoom levels. The bounds are
     * represented as WGS:84 in the OpenLayers Bounds format - left, bottom, right, top.
     * Typical for museum, tour.
     * <p>E.g.., "36.0123075,122.0978486,36.0176986,122.0911837"</p>
     */
    public String bounds;

    /**
     * Route in KML format. This route is for display on map purposes only. Typical for tour.
     */
    public String route;

}