/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;
import travel.izi.sdk.model.enumeration.MediaType;

/**
 * The media file details.
 */
@SuppressWarnings("unused")
public class Media implements IZITravelEntity {
    private static final long serialVersionUID = -6203198710109285963L;

    /**
     * Universally Unique Identifier of media file.
     */
    public String uuid;

    /**
     * Type of media.
     */
    public MediaType type;

    /**
     * Defines in what order to show\play media. F.e., picture with order=1 is the first(default) image to display.
     */
    public int order;

    /**
     * Duration of media file in seconds. Typical for audio, video.
     */
    public int duration;

    /**
     * Direct URL to media when a parameter media_links set to true.
     */
    public String url;

    /**
     * Title of media. Typical for {@link MediaType#Map} and {@link MediaType#Story} images.
     */
    public String title;

    /**
     * ETag hash for checking if file changed ({@link MediaType#BrandCover} and {@link MediaType#City} has no hash).
     */
    public String hash;

    /**
     * Media size in bytes ({@link MediaType#BrandCover} and {@link MediaType#City} has no size).
     * In case of images with type {@link MediaType#Story}, the size of 800x600 image version is used.
     */
    public Long size;

}