/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import com.google.gson.annotations.SerializedName;
import travel.izi.sdk.model.IZITravelEntity;

import java.util.Date;
import java.util.List;

/**
 * Response object for endpoint {@link travel.izi.sdk.service.ReviewService#getReviews(String, String, Long, Long)}.
 */
@SuppressWarnings("unused")
public class ReviewsResponse implements IZITravelEntity {
    private static final long serialVersionUID = 1273056820276298311L;

    @SerializedName("metadata")
    public Estimation estimation;

    @SerializedName("data")
    public List<Review> reviews;

    public Paging paging;

    /**
     * The average of ratings/reviews. If the average is not calculated yet, the section will be returned
     * where 'ratingAverage','ratingsCount', 'reviewsCount' fields will be 0 and 'date' will be current time.
     */
    public static class Estimation implements IZITravelEntity {
        private static final long serialVersionUID = 1492733520461868503L;

        /**
         * UUID of the MtgObject (content).
         */
        public String uuid;

        /**
         * Average of all ratings [0..10] (across all languages), Museums ratings includes their Collections ratings.
         */
        public float ratingAverage;

        /**
         * Total number of ratings at average snapshot time (across all languages).
         */
        public int ratingsCount;

        /**
         * Total number of reviews at average snapshot time (across all languages).
         */
        public int reviewsCount;

        /**
         * UTC time when average was calculated. Format is according to ISO-8601 "YYYY-MM-DDThh:mm:ssZ".
         */
        public Date date;
    }

    /**
     * Pagination to navigate through results data using Unix timestamps.
     */
    public static class Paging implements IZITravelEntity {
        private static final long serialVersionUID = -2388468821027971899L;

        /**
         * The number of individual records that are returned in each page.
         */
        public int limit;

        /**
         * The number of returned records in section 'data'. Values: [0..limit].
         */
        public int returnedCount;

        /**
         * The total number of review records for the content at request time
         * (all languages or for certain language passed as parameter).
         */
        public int totalCount;

        /**
         * An endpoint request that will return the next page of data or null.
         */
        public String next;

        /**
         * An endpoint request that will return the previous page of data or null.
         */
        public String previous;
    }

}