/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;

/**
 * The sponsor.
 */
@SuppressWarnings("unused")
public class Sponsor implements IZITravelEntity {
    private static final long serialVersionUID = 2430807285208843276L;

    /**
     * UUID of sponsor object.
     */
    public String uuid;

    /**
     * Not localized name of sponsor.
     */
    public String name;

    /**
     * Web-site link.
     */
    public String website;

    /**
     * An array of images according to generic images format in izi.API.
     * The array keeps only one element with sponsor logo.
     */
    public Media[] images;

    /**
     * Order of the element in the sponsors list, started from 1.
     * Sponsors list shall be shown in ascending order.
     */
    public int order;

    /**
     * Hash reflects a specific version of the sponsor.
     */
    public String hash;

}