/*
 * Copyright (C) 2014 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.model.entity;

import travel.izi.sdk.model.IZITravelEntity;
import travel.izi.sdk.model.enumeration.TriggerZoneType;

/**
 * Place where media content must be played.
 */
@SuppressWarnings("unused")
public class TriggerZone implements IZITravelEntity {
    private static final long serialVersionUID = 3411312172689813215L;

    /**
     * Trigger zone type.
     */
    public TriggerZoneType type;

    /**
     * Comma separated list of polygon latitude, longitude, altitude.
     */
    public String polygonCorners;

    /**
     * Circle center latitude.
     */
    public double circleLatitude;

    /**
     * Circle center longitude.
     */
    public double circleLongitude;

    /**
     * Circle center altitude. This parameter has zero value for now
     * and reserved for future use and geocoding consistency.
     */
    public double circleAltitude;

    /**
     * Circle radius in meters.
     */
    public double circleRadius;

}