/*
 * Copyright (C) 2015 IZITEQ B.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package travel.izi.sdk.service;

import retrofit.http.GET;
import retrofit.http.Query;
import travel.izi.sdk.model.entity.FeaturedObject;

import java.util.List;

/**
 * Endpoints for Featured Content.
 */
@SuppressWarnings("unused")
public interface FeaturedService {

    /**
     * Provides current featured content for izi.TRAVEL Applications (mobile clients):
     * promoted or most popular published tours and museums.
     * <p>
     * The end-point returns only published content in order defined by a featured content publisher
     * (position field reflects the ordering as well). The maximum number of returned objects is 10.
     * <p>
     * If there is no set defined for the first language or there is no published content for the language,
     * the end-point will try to return featured content set for next language, and so forth.
     * If there are no featured content for the set of passed languages, the end-point will try
     * to return set for `en` language.
     * </p>
     *
     * @param languages Array of preferable content languages.
     * @return Featured content or throw HTTP error 404 if no appropriate featured content are published.
     */
    @GET("/featured/mobile")
    List<FeaturedObject> getFeaturedContent(
            @Query("languages") String[] languages
    );

}