/*
 * Decompiled with CFR 0.152.
 */
package travel.liteapi.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import travel.liteapi.client.ApiCallback;
import travel.liteapi.client.ApiClient;
import travel.liteapi.client.ApiException;
import travel.liteapi.client.ApiResponse;
import travel.liteapi.client.Configuration;
import travel.liteapi.client.Pair;
import travel.liteapi.client.model.RatesBookPostRequest;
import travel.liteapi.client.model.RatesBookPostRequestGuestInfo;
import travel.liteapi.client.model.RatesBookPostRequestPayment;

public class BookApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BookApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call bookCall(String prebookId, String guestFirstName, String guestLastName, String guestEmail, String paymentMethod, String holderName, String card_number, String exp_month, String exp_year, Integer cvc, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RatesBookPostRequestGuestInfo guestInfo = new RatesBookPostRequestGuestInfo();
        guestInfo.setGuestFirstName(guestFirstName);
        guestInfo.setGuestLastName(guestLastName);
        guestInfo.setGuestEmail(guestEmail);
        RatesBookPostRequestPayment payment = new RatesBookPostRequestPayment();
        payment.setHolderName(guestFirstName);
        if ("CREDIT_CARD".equals(paymentMethod)) {
            payment.setMethod(RatesBookPostRequestPayment.MethodEnum.CREDIT_CARD);
            payment.setNumber(card_number);
            payment.setExpireDate(exp_month + "/" + exp_year);
            payment.setCvc(cvc.toString());
        } else if ("STRIPE_TOKEN".equals(paymentMethod)) {
            payment.setMethod(RatesBookPostRequestPayment.MethodEnum.STRIPE_TOKEN);
            payment.setToken(token);
        }
        RatesBookPostRequest localVarPostBody = new RatesBookPostRequest();
        localVarPostBody.setPrebookId(prebookId);
        localVarPostBody.setGuestInfo(guestInfo);
        localVarPostBody.setPayment(payment);
        String localVarPath = "/rates/book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call bookValidateBeforeCall(String prebookId, String guestFirstName, String guestLastName, String guestEmail, String paymentMethod, String holderName, String card_number, String exp_month, String exp_year, Integer cvc, String token, ApiCallback _callback) throws ApiException {
        return this.bookCall(prebookId, guestFirstName, guestLastName, guestEmail, paymentMethod, holderName, card_number, exp_month, exp_year, cvc, token, _callback);
    }

    public Object book(String prebookId, String guestFirstName, String guestLastName, String guestEmail, String paymentMethod, String holderName, String card_number, String exp_month, String exp_year, Integer cvc, String token) {
        try {
            ApiResponse<Object> localVarResp = this.bookWithHttpInfo(prebookId, guestFirstName, guestLastName, guestEmail, paymentMethod, holderName, card_number, exp_month, exp_year, cvc, token);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#book");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> bookWithHttpInfo(String prebookId, String guestFirstName, String guestLastName, String guestEmail, String paymentMethod, String holderName, String card_number, String exp_month, String exp_year, Integer cvc, String token) throws ApiException {
        Call localVarCall = this.bookValidateBeforeCall(prebookId, guestFirstName, guestLastName, guestEmail, paymentMethod, holderName, card_number, exp_month, exp_year, cvc, token, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call bookAsync(String prebookId, String guestFirstName, String guestLastName, String guestEmail, String paymentMethod, String holderName, String card_number, String exp_month, String exp_year, Integer cvc, String token, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.bookValidateBeforeCall(prebookId, guestFirstName, guestLastName, guestEmail, paymentMethod, holderName, card_number, exp_month, exp_year, cvc, token, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call preBookCall(String rateId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("rateId", rateId);
        HashMap<String, String> localVarPostBody = body;
        String localVarPath = "/rates/prebook";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call preBookValidateBeforeCall(String rateId, ApiCallback _callback) throws ApiException {
        return this.preBookCall(rateId, _callback);
    }

    public Object preBook(String rateId) {
        try {
            ApiResponse<Object> localVarResp = this.preBookWithHttpInfo(rateId);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#preBook");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> preBookWithHttpInfo(String rateId) throws ApiException {
        Call localVarCall = this.preBookValidateBeforeCall(rateId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call ratesPrebookPostAsync(String rateId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.preBookValidateBeforeCall(rateId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

