/*
 * Decompiled with CFR 0.152.
 */
package travel.liteapi.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import okhttp3.Call;
import travel.liteapi.client.ApiCallback;
import travel.liteapi.client.ApiClient;
import travel.liteapi.client.ApiException;
import travel.liteapi.client.ApiResponse;
import travel.liteapi.client.Configuration;
import travel.liteapi.client.Pair;

public class SearchApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getMinimumRatesCall(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/hotels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (hotelIds != null && hotelIds.length > 0) {
            String strHotelIds = String.join((CharSequence)",", hotelIds);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("hotelIds", strHotelIds));
        }
        if (checkin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checkin", checkin));
        }
        if (checkout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checkout", checkout));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (guestNationality != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("guestNationality", guestNationality));
        }
        if (adults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("adults", adults));
        }
        if (children != null) {
            String strChildren = Arrays.toString((Object[])children).replaceAll("\\[|\\]", "");
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("children", strChildren));
        }
        if (guestId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("guestId", guestId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMinimumRatesValidateBeforeCall(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId, ApiCallback _callback) throws ApiException {
        if (hotelIds == null) {
            throw new ApiException("Missing the required parameter 'hotelIds' when calling hotelsGet(Async)");
        }
        if (checkin == null) {
            throw new ApiException("Missing the required parameter 'checkin' when calling hotelsGet(Async)");
        }
        if (checkout == null) {
            throw new ApiException("Missing the required parameter 'checkout' when calling hotelsGet(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling hotelsGet(Async)");
        }
        if (guestNationality == null) {
            throw new ApiException("Missing the required parameter 'guestNationality' when calling hotelsGet(Async)");
        }
        if (adults == null) {
            throw new ApiException("Missing the required parameter 'adults' when calling hotelsGet(Async)");
        }
        return this.getMinimumRatesCall(hotelIds, checkin, checkout, currency, guestNationality, adults, children, guestId, _callback);
    }

    public Object getMinimumRates(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId) {
        try {
            ApiResponse<Object> localVarResp = this.getMinimumRatesWithHttpInfo(hotelIds, checkin, checkout, currency, guestNationality, adults, children, guestId);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getMinimumRates");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getMinimumRatesWithHttpInfo(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId) throws ApiException {
        Call localVarCall = this.getMinimumRatesValidateBeforeCall(hotelIds, checkin, checkout, currency, guestNationality, adults, children, guestId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMinimumRatesAsync(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getMinimumRatesValidateBeforeCall(hotelIds, checkin, checkout, currency, guestNationality, adults, children, guestId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFullRatesCall(String[] hotelIds, String checkin, String checkout, String guestNationality, String currency, Integer adults, Integer[] children, String guestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/hotels/rates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (hotelIds != null && hotelIds.length > 0) {
            String strHotelIds = String.join((CharSequence)",", hotelIds);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("hotelIds", strHotelIds));
        }
        if (checkin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checkin", checkin));
        }
        if (checkout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("checkout", checkout));
        }
        if (guestNationality != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("guestNationality", guestNationality));
        }
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (adults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("adults", adults));
        }
        if (children != null && children.length > 0) {
            String strChildren = Arrays.toString((Object[])children).replaceAll("\\[|\\]", "");
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("children", strChildren));
        }
        if (guestId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("guestId", guestId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFullRatesValidateBeforeCall(String[] hotelIds, String checkin, String checkout, String guestNationality, String currency, Integer adults, Integer[] children, String guestId, ApiCallback _callback) throws ApiException {
        if (hotelIds == null) {
            throw new ApiException("Missing the required parameter 'hotelIds' when calling hotelsRatesGet(Async)");
        }
        if (checkin == null) {
            throw new ApiException("Missing the required parameter 'checkin' when calling hotelsRatesGet(Async)");
        }
        if (checkout == null) {
            throw new ApiException("Missing the required parameter 'checkout' when calling hotelsRatesGet(Async)");
        }
        if (guestNationality == null) {
            throw new ApiException("Missing the required parameter 'guestNationality' when calling hotelsRatesGet(Async)");
        }
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling hotelsRatesGet(Async)");
        }
        if (adults == null) {
            throw new ApiException("Missing the required parameter 'adults' when calling hotelsRatesGet(Async)");
        }
        return this.getFullRatesCall(hotelIds, checkin, checkout, guestNationality, currency, adults, children, guestId, _callback);
    }

    public Object getFullRatest(String[] hotelIds, String checkin, String checkout, String currency, String guestNationality, Integer adults, Integer[] children, String guestId) {
        try {
            ApiResponse<Object> localVarResp = this.getFullRatesWithHttpInfo(hotelIds, checkin, checkout, guestNationality, currency, adults, children, guestId);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getFullRatest");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getFullRatesWithHttpInfo(String[] hotelIds, String checkin, String checkout, String guestNationality, String currency, Integer adults, Integer[] children, String guestId) throws ApiException {
        Call localVarCall = this.getFullRatesValidateBeforeCall(hotelIds, checkin, checkout, guestNationality, currency, adults, children, guestId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFullRatesAsync(String[] hotelIds, String checkin, String checkout, String guestNationality, String currency, Integer adults, Integer[] children, String guestId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getFullRatesValidateBeforeCall(hotelIds, checkin, checkout, guestNationality, currency, adults, children, guestId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

