/*
 * Decompiled with CFR 0.152.
 */
package travel.liteapi.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import travel.liteapi.client.ApiCallback;
import travel.liteapi.client.ApiClient;
import travel.liteapi.client.ApiException;
import travel.liteapi.client.ApiResponse;
import travel.liteapi.client.Configuration;
import travel.liteapi.client.Pair;

public class StaticDataApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StaticDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StaticDataApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getCitiesCall(String countryCode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/cities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (countryCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("countryCode", countryCode));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCitiesValidateBeforeCall(String countryCode, ApiCallback _callback) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling dataCitiesGet(Async)");
        }
        return this.getCitiesCall(countryCode, _callback);
    }

    public Object getCitiesByCountryCode(String countryCode) {
        try {
            ApiResponse<Object> localVarResp = this.getCitiesWithHttpInfo(countryCode);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getCitiesByCountryCode");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getCitiesWithHttpInfo(String countryCode) throws ApiException {
        Call localVarCall = this.getCitiesValidateBeforeCall(countryCode, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCitiesAsync(String countryCode, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getCitiesValidateBeforeCall(countryCode, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCountriesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/countries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCountriesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCountriesCall(_callback);
    }

    public Object getCountries() {
        try {
            ApiResponse<Object> localVarResp = this.getCountriesWithHttpInfo();
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getCountries");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getCountriesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCountriesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCountriesAsync(ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getCountriesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrenciesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getCurrenciesCall(_callback);
    }

    public Object getCurrencies() {
        try {
            ApiResponse<Object> localVarResp = this.getCurrenciesWithHttpInfo();
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getCurrencies");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrenciesAsync(ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHotelDetailsCall(String hotelId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/hotel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (hotelId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("hotelId", hotelId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHotelValidateBeforeCall(String hotelId, ApiCallback _callback) throws ApiException {
        if (hotelId == null) {
            throw new ApiException("Missing the required parameter 'hotelId' when calling dataHotelGet(Async)");
        }
        return this.getHotelDetailsCall(hotelId, _callback);
    }

    public Object getHotelDetails(String hotelId) {
        try {
            ApiResponse<Object> localVarResp = this.getHotelWithHttpInfo(hotelId);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getHotelDetails");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getHotelWithHttpInfo(String hotelId) throws ApiException {
        Call localVarCall = this.getHotelValidateBeforeCall(hotelId, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHotelAsync(String hotelId, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getHotelValidateBeforeCall(hotelId, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHotelsCall(String countryCode, String cityName, Integer offset, Integer limit, String longitude, String latitude, Integer distance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/hotels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (countryCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("countryCode", countryCode));
        }
        if (cityName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cityName", cityName));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (longitude != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("longitude", longitude));
        }
        if (latitude != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("latitude", latitude));
        }
        if (distance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("distance", distance));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHotelsValidateBeforeCall(String countryCode, String cityName, Integer offset, Integer limit, String longitude, String latitude, Integer distance, ApiCallback _callback) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling dataHotelsGet(Async)");
        }
        if (cityName == null) {
            throw new ApiException("Missing the required parameter 'cityName' when calling dataHotelsGet(Async)");
        }
        return this.getHotelsCall(countryCode, cityName, offset, limit, longitude, latitude, distance, _callback);
    }

    public Object getHotels(String countryCode, String cityName, Integer offset, Integer limit, String longitude, String latitude, Integer distance) {
        try {
            ApiResponse<Object> localVarResp = this.getHotelsWithHttpInfo(countryCode, cityName, offset, limit, longitude, latitude, distance);
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getHotels");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getHotelsWithHttpInfo(String countryCode, String cityName, Integer offset, Integer limit, String longitude, String latitude, Integer distance) throws ApiException {
        Call localVarCall = this.getHotelsValidateBeforeCall(countryCode, cityName, offset, limit, longitude, latitude, distance, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHotelsAsync(String countryCode, String cityName, Integer offset, Integer limit, String longitude, String latitude, Integer distance, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getHotelsValidateBeforeCall(countryCode, cityName, offset, limit, longitude, latitude, distance, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIataCodesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/data/iataCodes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"apikeyAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIataCodesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getIataCodesCall(_callback);
    }

    public Object getIataCodes() {
        try {
            ApiResponse<Object> localVarResp = this.getIataCodesWithHttpInfo();
            return localVarResp.getData();
        }
        catch (ApiException e) {
            System.err.println("Exception when calling StaticDataApi#getIataCodes");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
            return e.getResponseBody();
        }
    }

    public ApiResponse<Object> getIataCodesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getIataCodesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIataCodesAsync(ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getIataCodesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

