package travel.wink.sdk.affiliate.browse.api;

import travel.wink.sdk.affiliate.browse.invoker.ApiClient;

import travel.wink.sdk.affiliate.browse.model.DynamicSellerListViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.browse.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpdateCuratedList400Response;
import travel.wink.sdk.affiliate.browse.model.UpsertDynamicSellerListAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:20:14.805203539+07:00[Asia/Bangkok]")
public class SavedSearchApi {
    private ApiClient apiClient;

    public SavedSearchApi() {
        this(new ApiClient());
    }

    @Autowired
    public SavedSearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Saved Search
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create search owned by this owner identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSavedSearchRequestCreation(String companyIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertDynamicSellerListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertDynamicSellerListAffiliate' is set
        if (upsertDynamicSellerListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicSellerListAffiliate' when calling createSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/dynamic-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Saved Search
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create search owned by this owner identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DynamicSellerListViewAffiliate> createSavedSearch(String companyIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return createSavedSearchRequestCreation(companyIdentifier, upsertDynamicSellerListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Saved Search
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create search owned by this owner identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DynamicSellerListViewAffiliate>> createSavedSearchWithHttpInfo(String companyIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return createSavedSearchRequestCreation(companyIdentifier, upsertDynamicSellerListAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Saved Search
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create search owned by this owner identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSavedSearchWithResponseSpec(String companyIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        return createSavedSearchRequestCreation(companyIdentifier, upsertDynamicSellerListAffiliate, winkVersion);
    }
    /**
     * Remove Saved Search
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSavedSearchRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/dynamic-list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Saved Search
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSavedSearch(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSavedSearchRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Saved Search
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSavedSearchWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSavedSearchRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Saved Search
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSavedSearchWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeSavedSearchRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept);
    }
    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSavedSearchesRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSavedSearches", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/dynamic-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DynamicSellerListViewAffiliate> showSavedSearches(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;DynamicSellerListViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<DynamicSellerListViewAffiliate>>> showSavedSearchesWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return showSavedSearchesRequestCreation(companyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Saved Searches
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier List searches owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSavedSearchesWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showSavedSearchesRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * Update Saved Search
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSavedSearchRequestCreation(String companyIdentifier, String listIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertDynamicSellerListAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertDynamicSellerListAffiliate' is set
        if (upsertDynamicSellerListAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicSellerListAffiliate' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/dynamic-list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Saved Search
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DynamicSellerListViewAffiliate> updateSavedSearch(String companyIdentifier, String listIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return updateSavedSearchRequestCreation(companyIdentifier, listIdentifier, upsertDynamicSellerListAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Saved Search
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;DynamicSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DynamicSellerListViewAffiliate>> updateSavedSearchWithHttpInfo(String companyIdentifier, String listIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicSellerListViewAffiliate>() {};
        return updateSavedSearchRequestCreation(companyIdentifier, listIdentifier, upsertDynamicSellerListAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Saved Search
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update search owned by this owner identifier.
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicSellerListAffiliate The upsertDynamicSellerListAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSavedSearchWithResponseSpec(String companyIdentifier, String listIdentifier, UpsertDynamicSellerListAffiliate upsertDynamicSellerListAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSavedSearchRequestCreation(companyIdentifier, listIdentifier, upsertDynamicSellerListAffiliate, winkVersion);
    }
}
