package travel.wink.sdk.affiliate.browse.api;

import travel.wink.sdk.affiliate.browse.invoker.ApiClient;

import travel.wink.sdk.affiliate.browse.model.AddStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.AddStaticSellerListSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CopyMoveStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticSellerListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticSellerListAndAddSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.browse.model.SortStaticSellerListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListItemViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListWrapperAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpdateCuratedList400Response;
import travel.wink.sdk.affiliate.browse.model.UpsertStaticSellerListRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-11-04T20:26:20.498352432+07:00[Asia/Bangkok]")
public class CuratedListApi {
    private ApiClient apiClient;

    public CuratedListApi() {
        this(new ApiClient());
    }

    @Autowired
    public CuratedListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add Inventory to List
     * Add some travel blocking to your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = addStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticSellerListItemRequestAffiliate' is set
        if (addStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel blocking to your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> addInventoryToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel blocking to your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel blocking to your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListItemRequestAffiliate The addStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return addInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion);
    }
    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListSupplierRequestAffiliate The addStaticSellerListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addSupplierToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = addStaticSellerListSupplierRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticSellerListSupplierRequestAffiliate' is set
        if (addStaticSellerListSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListSupplierRequestAffiliate' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/item/supplier", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListSupplierRequestAffiliate The addStaticSellerListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> addSupplierToCuratedList(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListSupplierRequestAffiliate The addStaticSellerListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addSupplierToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Add blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param addStaticSellerListSupplierRequestAffiliate The addStaticSellerListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addSupplierToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return addSupplierToCuratedListRequestCreation(companyIdentifier, listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion);
    }
    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec copyInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' is set
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> copyInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> copyInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Copy blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec copyInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return copyInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }
    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createStaticSellerListAndAddItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' is set
        if (createStaticSellerListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapperAffiliate> createCuratedList(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddItemRequestAffiliate The createStaticSellerListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCuratedListWithResponseSpec(String companyIdentifier, CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createCuratedListRequestCreation(companyIdentifier, createStaticSellerListAndAddItemRequestAffiliate, winkVersion);
    }
    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddSupplierRequestAffiliate The createStaticSellerListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedSupplierListRequestCreation(String companyIdentifier, CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createStaticSellerListAndAddSupplierRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCuratedSupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createStaticSellerListAndAddSupplierRequestAffiliate' is set
        if (createStaticSellerListAndAddSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddSupplierRequestAffiliate' when calling createCuratedSupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/supplier", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddSupplierRequestAffiliate The createStaticSellerListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapperAffiliate> createCuratedSupplierList(String companyIdentifier, CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedSupplierListRequestCreation(companyIdentifier, createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddSupplierRequestAffiliate The createStaticSellerListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedSupplierListWithHttpInfo(String companyIdentifier, CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return createCuratedSupplierListRequestCreation(companyIdentifier, createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Create curated list owned by this owner identifier.
     * @param createStaticSellerListAndAddSupplierRequestAffiliate The createStaticSellerListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCuratedSupplierListWithResponseSpec(String companyIdentifier, CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createCuratedSupplierListRequestCreation(companyIdentifier, createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion);
    }
    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Move blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec moveInventoryToCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticSellerListItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' is set
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Move blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> moveInventoryToCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Move blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> moveInventoryToCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Move blocking to curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticSellerListItemRequestAffiliate The copyMoveStaticSellerListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec moveInventoryToCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return moveInventoryToCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }
    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticSellerListViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListViewAffiliate> removeCuratedList(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;StaticSellerListViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListViewAffiliate>> removeCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>() {};
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeCuratedListRequestCreation(companyIdentifier, listIdentifier, winkVersion, accept);
    }
    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove blocking from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeInventoryFromCuratedListRequestCreation(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove blocking from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticSellerListItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListItemViewAffiliate> removeInventoryFromCuratedList(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove blocking from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> removeInventoryFromCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Remove blocking from curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeInventoryFromCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeInventoryFromCuratedListRequestCreation(companyIdentifier, listIdentifier, itemIdentifier, winkVersion, accept);
    }
    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCuratedListsRequestCreation(String companyIdentifier, Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCuratedLists", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "withItems", withItems));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticSellerListWrapperAffiliate> showCuratedLists(String companyIdentifier, Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;StaticSellerListWrapperAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<StaticSellerListWrapperAffiliate>>> showCuratedListsWithHttpInfo(String companyIdentifier, Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Show curated lists owned by this owner identifier.
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCuratedListsWithResponseSpec(String companyIdentifier, Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        return showCuratedListsRequestCreation(companyIdentifier, withItems, winkVersion, accept);
    }
    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec sortCuratedListItemsRequestCreation(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sortStaticSellerListItemsRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sortStaticSellerListItemsRequestAffiliate' is set
        if (sortStaticSellerListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticSellerListItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticSellerListItemViewAffiliate> sortCuratedListItems(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;StaticSellerListItemViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<StaticSellerListItemViewAffiliate>>> sortCuratedListItemsWithHttpInfo(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>() {};
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Sort curated list items owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param sortStaticSellerListItemsRequestAffiliate The sortStaticSellerListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec sortCuratedListItemsWithResponseSpec(String companyIdentifier, String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return sortCuratedListItemsRequestCreation(companyIdentifier, listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion);
    }
    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param upsertStaticSellerListRequestAffiliate The upsertStaticSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCuratedListRequestCreation(String companyIdentifier, String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertStaticSellerListRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertStaticSellerListRequestAffiliate' is set
        if (upsertStaticSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertStaticSellerListRequestAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/affiliate/{companyIdentifier}/static-list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param upsertStaticSellerListRequestAffiliate The upsertStaticSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticSellerListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticSellerListWrapperAffiliate> updateCuratedList(String companyIdentifier, String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param upsertStaticSellerListRequestAffiliate The upsertStaticSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticSellerListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> updateCuratedListWithHttpInfo(String companyIdentifier, String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Update curated list owned by this owner identifier.
     * @param listIdentifier List identifier.
     * @param upsertStaticSellerListRequestAffiliate The upsertStaticSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCuratedListWithResponseSpec(String companyIdentifier, String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCuratedListRequestCreation(companyIdentifier, listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion);
    }
}
