/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel blocking on the Wink platform. The API gives you all the tools you need to ready your properties and blocking for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel blocking and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel blocking and get that same blocking out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel blocking and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating blocking by region, locale and property flags.  - [Inventory](/blocking): All APIs related to retrieve known travel blocking as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel blocking.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and blocking calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and blocking to sell.  - [Inventory](/affiliate/blocking): The Inventory API exposes endpoints for affiliates to manage the blocking they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel blocking and need taxonomies of standard and non-standard codes for blocking types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel blocking. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and blocking to sell. This API lets you:  1. Browse: Find blocking and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.7.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.browse.model.LocalizedDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Promotions that go together to make up this ancillary.
 */
@JsonPropertyOrder({
  RateModifierAffiliate.JSON_PROPERTY_IDENTIFIER,
  RateModifierAffiliate.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RateModifierAffiliate.JSON_PROPERTY_NAME,
  RateModifierAffiliate.JSON_PROPERTY_TYPE,
  RateModifierAffiliate.JSON_PROPERTY_MODIFIER,
  RateModifierAffiliate.JSON_PROPERTY_ENABLED,
  RateModifierAffiliate.JSON_PROPERTY_PRICING_TYPE,
  RateModifierAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  RateModifierAffiliate.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  RateModifierAffiliate.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  RateModifierAffiliate.JSON_PROPERTY_BLACKOUT_DATES
})
@JsonTypeName("RateModifier_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-11-04T20:26:20.498352432+07:00[Asia/Bangkok]")
public class RateModifierAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM("PREMIUM"),
    
    DISCOUNT("DISCOUNT");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  private Object modifier;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    STAY("PER_STAY"),
    
    DAY("PER_DAY"),
    
    NIGHT("PER_NIGHT"),
    
    USE("PER_USE"),
    
    HOUR("PER_HOUR"),
    
    PERSON("PER_PERSON"),
    
    PERSON_PER_NIGHT("PER_PERSON_PER_NIGHT"),
    
    PERSON_PER_HOUR("PER_PERSON_PER_HOUR"),
    
    ADULT("PER_ADULT"),
    
    ADULT_PER_NIGHT("PER_ADULT_PER_NIGHT"),
    
    ADULT_PER_HOUR("PER_ADULT_PER_HOUR"),
    
    CHILD("PER_CHILD"),
    
    CHILD_PER_NIGHT("PER_CHILD_PER_NIGHT"),
    
    CHILD_PER_HOUR("PER_CHILD_PER_HOUR");

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<LocalizedDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  private List<Object> cityRateQualifiers;

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  private List<Object> continentRateQualifiers;

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  private List<Object> countryRateQualifiers;

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  private List<Object> promotionRateQualifiers;

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  private List<Object> ipRangeRateQualifiers;

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  private Object roomRangeRateQualifier;

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  private Object prepayRateQualifier;

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  private Object refundableRateQualifier;

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  private List<Object> timezoneRateQualifiers;

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  private Object lastMinuteRateQualifier;

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  private Object lengthOfStayRateQualifier;

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  private Object advanceBookingRateQualifier;

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  private List<Object> stayDateRateQualifiers;

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  private List<Object> sellDateRateQualifiers;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  private Object availableDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  private Object arrivalDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  private Object departureDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  private Object requiredDaysOfWeekRateQualifier;

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  private List<String> masterRateIdentifiers;

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  private List<String> addOnIdentifiers;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  private List<String> ratePlanIdentifiers;

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  private List<Object> blackoutDates;

  public RateModifierAffiliate() {
  }

  public RateModifierAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RateModifierAffiliate hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RateModifierAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of promotion.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RateModifierAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public RateModifierAffiliate modifier(Object modifier) {
    
    this.modifier = modifier;
    return this;
  }

   /**
   * Get modifier
   * @return modifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Object getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(Object modifier) {
    this.modifier = modifier;
  }


  public RateModifierAffiliate enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this promotion is enabled or not.
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public RateModifierAffiliate pricingType(PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

   /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }


  public RateModifierAffiliate descriptions(List<LocalizedDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RateModifierAffiliate addDescriptionsItem(LocalizedDescriptionAffiliate descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<LocalizedDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<LocalizedDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public RateModifierAffiliate cityRateQualifiers(List<Object> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addCityRateQualifiersItem(Object cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)
   * @return cityRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(List<Object> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }


  public RateModifierAffiliate continentRateQualifiers(List<Object> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addContinentRateQualifiersItem(Object continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)
   * @return continentRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(List<Object> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }


  public RateModifierAffiliate countryRateQualifiers(List<Object> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addCountryRateQualifiersItem(Object countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)
   * @return countryRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(List<Object> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }


  public RateModifierAffiliate promotionRateQualifiers(List<Object> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addPromotionRateQualifiersItem(Object promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(List<Object> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }


  public RateModifierAffiliate ipRangeRateQualifiers(List<Object> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addIpRangeRateQualifiersItem(Object ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(List<Object> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }


  public RateModifierAffiliate roomRangeRateQualifier(Object roomRangeRateQualifier) {
    
    this.roomRangeRateQualifier = roomRangeRateQualifier;
    return this;
  }

   /**
   * Restrict promotion by restricting to how many rooms the user wants.
   * @return roomRangeRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getRoomRangeRateQualifier() {
    return roomRangeRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomRangeRateQualifier(Object roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }


  public RateModifierAffiliate prepayRateQualifier(Object prepayRateQualifier) {
    
    this.prepayRateQualifier = prepayRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to either prepaid / non-prepaid rates.
   * @return prepayRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getPrepayRateQualifier() {
    return prepayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrepayRateQualifier(Object prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }


  public RateModifierAffiliate refundableRateQualifier(Object refundableRateQualifier) {
    
    this.refundableRateQualifier = refundableRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to either refundable / non-refundable rates.
   * @return refundableRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getRefundableRateQualifier() {
    return refundableRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableRateQualifier(Object refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }


  public RateModifierAffiliate timezoneRateQualifiers(List<Object> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addTimezoneRateQualifiersItem(Object timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)
   * @return timezoneRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(List<Object> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }


  public RateModifierAffiliate lastMinuteRateQualifier(Object lastMinuteRateQualifier) {
    
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to users who want to book a room close to the date.
   * @return lastMinuteRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getLastMinuteRateQualifier() {
    return lastMinuteRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastMinuteRateQualifier(Object lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }


  public RateModifierAffiliate lengthOfStayRateQualifier(Object lengthOfStayRateQualifier) {
    
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to users who want to stay a certain number of days.
   * @return lengthOfStayRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getLengthOfStayRateQualifier() {
    return lengthOfStayRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLengthOfStayRateQualifier(Object lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }


  public RateModifierAffiliate advanceBookingRateQualifier(Object advanceBookingRateQualifier) {
    
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to users who want to book in advance.
   * @return advanceBookingRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAdvanceBookingRateQualifier() {
    return advanceBookingRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceBookingRateQualifier(Object advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }


  public RateModifierAffiliate stayDateRateQualifiers(List<Object> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addStayDateRateQualifiersItem(Object stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(List<Object> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }


  public RateModifierAffiliate sellDateRateQualifiers(List<Object> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public RateModifierAffiliate addSellDateRateQualifiersItem(Object sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

   /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(List<Object> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }


  public RateModifierAffiliate availableDaysOfWeekRateQualifier(Object availableDaysOfWeekRateQualifier) {
    
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to specific days of the week the promotion is available.
   * @return availableDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAvailableDaysOfWeekRateQualifier() {
    return availableDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeekRateQualifier(Object availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }


  public RateModifierAffiliate arrivalDaysOfWeekRateQualifier(Object arrivalDaysOfWeekRateQualifier) {
    
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to specific days of the week the guest is arriving.
   * @return arrivalDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getArrivalDaysOfWeekRateQualifier() {
    return arrivalDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeekRateQualifier(Object arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }


  public RateModifierAffiliate departureDaysOfWeekRateQualifier(Object departureDaysOfWeekRateQualifier) {
    
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to specific days of the week the guest is departing.
   * @return departureDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getDepartureDaysOfWeekRateQualifier() {
    return departureDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeekRateQualifier(Object departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }


  public RateModifierAffiliate requiredDaysOfWeekRateQualifier(Object requiredDaysOfWeekRateQualifier) {
    
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
    return this;
  }

   /**
   * Restrict promotion to specific days of the week the guest has to stay.
   * @return requiredDaysOfWeekRateQualifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getRequiredDaysOfWeekRateQualifier() {
    return requiredDaysOfWeekRateQualifier;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeekRateQualifier(Object requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }


  public RateModifierAffiliate masterRateIdentifiers(List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public RateModifierAffiliate addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }


  public RateModifierAffiliate addOnIdentifiers(List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public RateModifierAffiliate addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }


  public RateModifierAffiliate ratePlanIdentifiers(List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public RateModifierAffiliate addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

   /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }


  public RateModifierAffiliate blackoutDates(List<Object> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public RateModifierAffiliate addBlackoutDatesItem(Object blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

   /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(List<Object> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RateModifierAffiliate rateModifierAffiliate = (RateModifierAffiliate) o;
    return Objects.equals(this.identifier, rateModifierAffiliate.identifier) &&
        Objects.equals(this.hotelIdentifier, rateModifierAffiliate.hotelIdentifier) &&
        Objects.equals(this.name, rateModifierAffiliate.name) &&
        Objects.equals(this.type, rateModifierAffiliate.type) &&
        Objects.equals(this.modifier, rateModifierAffiliate.modifier) &&
        Objects.equals(this.enabled, rateModifierAffiliate.enabled) &&
        Objects.equals(this.pricingType, rateModifierAffiliate.pricingType) &&
        Objects.equals(this.descriptions, rateModifierAffiliate.descriptions) &&
        Objects.equals(this.cityRateQualifiers, rateModifierAffiliate.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, rateModifierAffiliate.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, rateModifierAffiliate.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, rateModifierAffiliate.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, rateModifierAffiliate.ipRangeRateQualifiers) &&
        Objects.equals(this.roomRangeRateQualifier, rateModifierAffiliate.roomRangeRateQualifier) &&
        Objects.equals(this.prepayRateQualifier, rateModifierAffiliate.prepayRateQualifier) &&
        Objects.equals(this.refundableRateQualifier, rateModifierAffiliate.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, rateModifierAffiliate.timezoneRateQualifiers) &&
        Objects.equals(this.lastMinuteRateQualifier, rateModifierAffiliate.lastMinuteRateQualifier) &&
        Objects.equals(this.lengthOfStayRateQualifier, rateModifierAffiliate.lengthOfStayRateQualifier) &&
        Objects.equals(this.advanceBookingRateQualifier, rateModifierAffiliate.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, rateModifierAffiliate.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, rateModifierAffiliate.sellDateRateQualifiers) &&
        Objects.equals(this.availableDaysOfWeekRateQualifier, rateModifierAffiliate.availableDaysOfWeekRateQualifier) &&
        Objects.equals(this.arrivalDaysOfWeekRateQualifier, rateModifierAffiliate.arrivalDaysOfWeekRateQualifier) &&
        Objects.equals(this.departureDaysOfWeekRateQualifier, rateModifierAffiliate.departureDaysOfWeekRateQualifier) &&
        Objects.equals(this.requiredDaysOfWeekRateQualifier, rateModifierAffiliate.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, rateModifierAffiliate.masterRateIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, rateModifierAffiliate.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, rateModifierAffiliate.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, rateModifierAffiliate.blackoutDates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, roomRangeRateQualifier, prepayRateQualifier, refundableRateQualifier, timezoneRateQualifiers, lastMinuteRateQualifier, lengthOfStayRateQualifier, advanceBookingRateQualifier, stayDateRateQualifiers, sellDateRateQualifiers, availableDaysOfWeekRateQualifier, arrivalDaysOfWeekRateQualifier, departureDaysOfWeekRateQualifier, requiredDaysOfWeekRateQualifier, masterRateIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RateModifierAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

