/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and inventory to sell. This API lets you:  1. Browse: Find inventory and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.12.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.affiliate.browse.model.AddressAffiliate;
import travel.wink.sdk.affiliate.browse.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.browse.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.browse.model.HotelOnMapAffiliate;
import travel.wink.sdk.affiliate.browse.model.SalesChannelAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Channel inventory
 */
@JsonPropertyOrder({
  InventoryAffiliate.JSON_PROPERTY_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_SALES_CHANNEL,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_TYPE,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_NAME,
  InventoryAffiliate.JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH,
  InventoryAffiliate.JSON_PROPERTY_ENABLED,
  InventoryAffiliate.JSON_PROPERTY_IMAGE_IDENTIFIER,
  InventoryAffiliate.JSON_PROPERTY_PRICE_POINT,
  InventoryAffiliate.JSON_PROPERTY_LOCATION,
  InventoryAffiliate.JSON_PROPERTY_ADDRESS,
  InventoryAffiliate.JSON_PROPERTY_QUANTITY,
  InventoryAffiliate.JSON_PROPERTY_COMMISSIONABLE,
  InventoryAffiliate.JSON_PROPERTY_BOOKABLE,
  InventoryAffiliate.JSON_PROPERTY_LOWEST_PRICE,
  InventoryAffiliate.JSON_PROPERTY_LOWEST_DISPLAY_PRICE,
  InventoryAffiliate.JSON_PROPERTY_HOTEL
})
@JsonTypeName("Inventory_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-26T12:28:12.346320019+07:00[Asia/Bangkok]")
public class InventoryAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SALES_CHANNEL = "salesChannel";
  private SalesChannelAffiliate salesChannel;

  /**
   * Inventory type
   */
  public enum InventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_INVENTORY_IDENTIFIER = "inventoryIdentifier";
  private UUID inventoryIdentifier;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public static final String JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH = "inventoryNameInEnglish";
  private String inventoryNameInEnglish;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAffiliate address;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Integer quantity = 0;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = false;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_LOWEST_PRICE = "lowestPrice";
  private CustomMonetaryAmount lowestPrice;

  public static final String JSON_PROPERTY_LOWEST_DISPLAY_PRICE = "lowestDisplayPrice";
  private CustomMonetaryAmount lowestDisplayPrice;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapAffiliate hotel;

  public InventoryAffiliate() {
  }

  public InventoryAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Inventory identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public InventoryAffiliate salesChannel(SalesChannelAffiliate salesChannel) {
    
    this.salesChannel = salesChannel;
    return this;
  }

   /**
   * Get salesChannel
   * @return salesChannel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SalesChannelAffiliate getSalesChannel() {
    return salesChannel;
  }


  @JsonProperty(JSON_PROPERTY_SALES_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSalesChannel(SalesChannelAffiliate salesChannel) {
    this.salesChannel = salesChannel;
  }


  public InventoryAffiliate inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * Inventory type
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public InventoryAffiliate inventoryIdentifier(UUID inventoryIdentifier) {
    
    this.inventoryIdentifier = inventoryIdentifier;
    return this;
  }

   /**
   * Inventory type identifier
   * @return inventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getInventoryIdentifier() {
    return inventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryIdentifier(UUID inventoryIdentifier) {
    this.inventoryIdentifier = inventoryIdentifier;
  }


  public InventoryAffiliate inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Name of blocking as hotel is seeing it
   * @return inventoryName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  public InventoryAffiliate inventoryNameInEnglish(String inventoryNameInEnglish) {
    
    this.inventoryNameInEnglish = inventoryNameInEnglish;
    return this;
  }

   /**
   * Name of blocking as traveler is seeing it
   * @return inventoryNameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getInventoryNameInEnglish() {
    return inventoryNameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryNameInEnglish(String inventoryNameInEnglish) {
    this.inventoryNameInEnglish = inventoryNameInEnglish;
  }


  public InventoryAffiliate enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Whether this blocking is enabled or not
   * @return enabled
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public InventoryAffiliate imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Main image of blocking
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public InventoryAffiliate pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public InventoryAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }


  public InventoryAffiliate address(AddressAffiliate address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressAffiliate getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressAffiliate address) {
    this.address = address;
  }


  public InventoryAffiliate quantity(Integer quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * quantity
   * @return quantity
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }


  public InventoryAffiliate commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this is commissionable or not
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public InventoryAffiliate bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Whether blocking can be booked
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public InventoryAffiliate lowestPrice(CustomMonetaryAmount lowestPrice) {
    
    this.lowestPrice = lowestPrice;
    return this;
  }

   /**
   * Get lowestPrice
   * @return lowestPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLowestPrice() {
    return lowestPrice;
  }


  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowestPrice(CustomMonetaryAmount lowestPrice) {
    this.lowestPrice = lowestPrice;
  }


  public InventoryAffiliate lowestDisplayPrice(CustomMonetaryAmount lowestDisplayPrice) {
    
    this.lowestDisplayPrice = lowestDisplayPrice;
    return this;
  }

   /**
   * Get lowestDisplayPrice
   * @return lowestDisplayPrice
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOWEST_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getLowestDisplayPrice() {
    return lowestDisplayPrice;
  }


  @JsonProperty(JSON_PROPERTY_LOWEST_DISPLAY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowestDisplayPrice(CustomMonetaryAmount lowestDisplayPrice) {
    this.lowestDisplayPrice = lowestDisplayPrice;
  }


  public InventoryAffiliate hotel(HotelOnMapAffiliate hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapAffiliate getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapAffiliate hotel) {
    this.hotel = hotel;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryAffiliate inventoryAffiliate = (InventoryAffiliate) o;
    return Objects.equals(this.identifier, inventoryAffiliate.identifier) &&
        Objects.equals(this.salesChannel, inventoryAffiliate.salesChannel) &&
        Objects.equals(this.inventoryType, inventoryAffiliate.inventoryType) &&
        Objects.equals(this.inventoryIdentifier, inventoryAffiliate.inventoryIdentifier) &&
        Objects.equals(this.inventoryName, inventoryAffiliate.inventoryName) &&
        Objects.equals(this.inventoryNameInEnglish, inventoryAffiliate.inventoryNameInEnglish) &&
        Objects.equals(this.enabled, inventoryAffiliate.enabled) &&
        Objects.equals(this.imageIdentifier, inventoryAffiliate.imageIdentifier) &&
        Objects.equals(this.pricePoint, inventoryAffiliate.pricePoint) &&
        Objects.equals(this.location, inventoryAffiliate.location) &&
        Objects.equals(this.address, inventoryAffiliate.address) &&
        Objects.equals(this.quantity, inventoryAffiliate.quantity) &&
        Objects.equals(this.commissionable, inventoryAffiliate.commissionable) &&
        Objects.equals(this.bookable, inventoryAffiliate.bookable) &&
        Objects.equals(this.lowestPrice, inventoryAffiliate.lowestPrice) &&
        Objects.equals(this.lowestDisplayPrice, inventoryAffiliate.lowestDisplayPrice) &&
        Objects.equals(this.hotel, inventoryAffiliate.hotel);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, salesChannel, inventoryType, inventoryIdentifier, inventoryName, inventoryNameInEnglish, enabled, imageIdentifier, pricePoint, location, address, quantity, commissionable, bookable, lowestPrice, lowestDisplayPrice, hotel);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    salesChannel: ").append(toIndentedString(salesChannel)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    inventoryIdentifier: ").append(toIndentedString(inventoryIdentifier)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    inventoryNameInEnglish: ").append(toIndentedString(inventoryNameInEnglish)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    lowestPrice: ").append(toIndentedString(lowestPrice)).append("\n");
    sb.append("    lowestDisplayPrice: ").append(toIndentedString(lowestDisplayPrice)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

