/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.browse.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.browse.invoker.ApiClient;
import travel.wink.sdk.affiliate.browse.model.CountryAffiliate;
import travel.wink.sdk.affiliate.browse.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.browse.model.InventorySupplierAffiliate;
import travel.wink.sdk.affiliate.browse.model.InventoryViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventorySupplierAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventoryViewAffiliate;

public class BrowseApi {
    private ApiClient apiClient;

    public BrowseApi() {
        this(new ApiClient());
    }

    @Autowired
    public BrowseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCitiesForInventoryRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameAffiliate> showCitiesForInventory(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventoryWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventoryWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCitiesForInventory_0RequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameAffiliate> showCitiesForInventory_0(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventory_0RequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventory_0WithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventory_0RequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventory_0WithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCitiesForInventory_0RequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCountriesForInventoryRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryAffiliate> showCountriesForInventory(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventoryWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventoryWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCountriesForInventorySupplierRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryAffiliate> showCountriesForInventorySupplier(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventorySupplierWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventorySupplierWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryRequestCreation(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventory(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryWithHttpInfo(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryWithResponseSpec(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryByIdRequestCreation(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAffiliate> showDynamicSellerInventoryById(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryByIdWithResponseSpec(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryById_0RequestCreation(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById_0", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventoryById_0(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryById_0WithHttpInfo(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryById_0WithResponseSpec(String dynamicListIdentifier, Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventorySupplierRequestCreation(String supplierIdentifier, String salesChannelIdentifier, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/{supplierIdentifier}/sales-channel/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventorySupplierAffiliate> showInventorySupplier(String supplierIdentifier, String salesChannelIdentifier, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventorySupplierAffiliate>> showInventorySupplierWithHttpInfo(String supplierIdentifier, String salesChannelIdentifier, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventorySupplierWithResponseSpec(String supplierIdentifier, String salesChannelIdentifier, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showLatestInventoryRequestCreation(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryViewAffiliate> showLatestInventory(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryViewAffiliate>>> showLatestInventoryWithHttpInfo(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventoryWithResponseSpec(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showLatestInventorySupplierListRequestCreation(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventorySupplierAffiliate> showLatestInventorySupplierList(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventorySupplierAffiliate>>> showLatestInventorySupplierListWithHttpInfo(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventorySupplierListWithResponseSpec(Integer page, Integer size, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryRequestCreation(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAffiliate> showSuppliersForDynamicSellerInventory(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showSuppliersForDynamicSellerInventoryWithHttpInfo(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryWithResponseSpec(DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }
}

