/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.browse.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.browse.invoker.ApiClient;
import travel.wink.sdk.affiliate.browse.model.AddStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.AddStaticSellerListSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CopyMoveStaticSellerListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticSellerListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticSellerListAndAddSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.SortStaticSellerListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListItemViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListViewAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticSellerListWrapperAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpsertStaticSellerListRequestAffiliate;

public class CuratedListApi {
    private ApiClient apiClient;

    public CuratedListApi() {
        this(new ApiClient());
    }

    @Autowired
    public CuratedListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addInventoryToCuratedListRequestCreation(String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        AddStaticSellerListItemRequestAffiliate postBody = addStaticSellerListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> addInventoryToCuratedList(String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addInventoryToCuratedListWithHttpInfo(String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addInventoryToCuratedListWithResponseSpec(String listIdentifier, AddStaticSellerListItemRequestAffiliate addStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec addSupplierToCuratedListRequestCreation(String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        AddStaticSellerListSupplierRequestAffiliate postBody = addStaticSellerListSupplierRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticSellerListSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticSellerListSupplierRequestAffiliate' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> addSupplierToCuratedList(String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> addSupplierToCuratedListWithHttpInfo(String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addSupplierToCuratedListWithResponseSpec(String listIdentifier, AddStaticSellerListSupplierRequestAffiliate addStaticSellerListSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticSellerListSupplierRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec copyInventoryToCuratedListRequestCreation(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequestAffiliate postBody = copyMoveStaticSellerListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> copyInventoryToCuratedList(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> copyInventoryToCuratedListWithHttpInfo(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec copyInventoryToCuratedListWithResponseSpec(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createCuratedListRequestCreation(CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateStaticSellerListAndAddItemRequestAffiliate postBody = createStaticSellerListAndAddItemRequestAffiliate;
        if (createStaticSellerListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapperAffiliate> createCuratedList(CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.createCuratedListRequestCreation(createStaticSellerListAndAddItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedListWithHttpInfo(CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.createCuratedListRequestCreation(createStaticSellerListAndAddItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCuratedListWithResponseSpec(CreateStaticSellerListAndAddItemRequestAffiliate createStaticSellerListAndAddItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCuratedListRequestCreation(createStaticSellerListAndAddItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createCuratedSupplierListRequestCreation(CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateStaticSellerListAndAddSupplierRequestAffiliate postBody = createStaticSellerListAndAddSupplierRequestAffiliate;
        if (createStaticSellerListAndAddSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListAndAddSupplierRequestAffiliate' when calling createCuratedSupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapperAffiliate> createCuratedSupplierList(CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.createCuratedSupplierListRequestCreation(createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> createCuratedSupplierListWithHttpInfo(CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.createCuratedSupplierListRequestCreation(createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCuratedSupplierListWithResponseSpec(CreateStaticSellerListAndAddSupplierRequestAffiliate createStaticSellerListAndAddSupplierRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCuratedSupplierListRequestCreation(createStaticSellerListAndAddSupplierRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec moveInventoryToCuratedListRequestCreation(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CopyMoveStaticSellerListItemRequestAffiliate postBody = copyMoveStaticSellerListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticSellerListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticSellerListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> moveInventoryToCuratedList(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> moveInventoryToCuratedListWithHttpInfo(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec moveInventoryToCuratedListWithResponseSpec(String listIdentifier, String itemIdentifier, CopyMoveStaticSellerListItemRequestAffiliate copyMoveStaticSellerListItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticSellerListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCuratedListRequestCreation(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListViewAffiliate> removeCuratedList(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>(this){};
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListViewAffiliate>> removeCuratedListWithHttpInfo(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListViewAffiliate>(this){};
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCuratedListWithResponseSpec(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeInventoryFromCuratedListRequestCreation(String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListItemViewAffiliate> removeInventoryFromCuratedList(String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListItemViewAffiliate>> removeInventoryFromCuratedListWithHttpInfo(String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeInventoryFromCuratedListWithResponseSpec(String listIdentifier, String itemIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCuratedListsRequestCreation(Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "withItems", withItems));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticSellerListWrapperAffiliate> showCuratedLists(Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListWrapperAffiliate>>> showCuratedListsWithHttpInfo(Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCuratedListsWithResponseSpec(Boolean withItems, String winkVersion, String accept) throws WebClientResponseException {
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept);
    }

    private WebClient.ResponseSpec sortCuratedListItemsRequestCreation(String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        SortStaticSellerListItemsRequestAffiliate postBody = sortStaticSellerListItemsRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sortStaticSellerListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticSellerListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticSellerListItemViewAffiliate> sortCuratedListItems(String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticSellerListItemViewAffiliate>>> sortCuratedListItemsWithHttpInfo(String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListItemViewAffiliate>(this){};
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec sortCuratedListItemsWithResponseSpec(String listIdentifier, SortStaticSellerListItemsRequestAffiliate sortStaticSellerListItemsRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticSellerListItemsRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCuratedListRequestCreation(String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertStaticSellerListRequestAffiliate postBody = upsertStaticSellerListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertStaticSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertStaticSellerListRequestAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticSellerListWrapperAffiliate> updateCuratedList(String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticSellerListWrapperAffiliate>> updateCuratedListWithHttpInfo(String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticSellerListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticSellerListWrapperAffiliate>(this){};
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCuratedListWithResponseSpec(String listIdentifier, UpsertStaticSellerListRequestAffiliate upsertStaticSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticSellerListRequestAffiliate, winkVersion);
    }
}

