/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and inventory to sell. This API lets you:  1. Browse: Find inventory and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.16.4
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.affiliate.browse.model.GeoJsonPointAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Contains the caller&#39;s search criteria.
 */
@JsonPropertyOrder({
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_NAME,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_PROPERTY_NAME,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_LOCATION_CATEGORIES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SEGMENT_CATEGORIES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_HOTEL_CATEGORIES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_ARCHITECTURAL_STYLES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_INVENTORY_NAME,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_CONTINENTS,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_COUNTRIES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_CITIES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SHOW_ECO_FRIENDLY,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SHOW_PET_FRIENDLY,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SHOW_CHILD_FRIENDLY,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SHOW_POPULAR,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_SHOW_DIRECT_ONLY,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_LIFESTYLES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_HOTEL_STARS,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_AGGREGATE_REVIEW_RATING,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_NEAR_POINT,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_RADIUS_IN_METERS,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_INVENTORY_TYPES,
  UpsertDynamicSellerListRequestAffiliate.JSON_PROPERTY_PRIMARY_ORDER_BY
})
@JsonTypeName("UpsertDynamicSellerListRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T14:56:39.718058800+07:00[Asia/Bangkok]")
public class UpsertDynamicSellerListRequestAffiliate {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROPERTY_NAME = "propertyName";
  private String propertyName;

  public static final String JSON_PROPERTY_LOCATION_CATEGORIES = "locationCategories";
  private List<String> locationCategories;

  public static final String JSON_PROPERTY_SEGMENT_CATEGORIES = "segmentCategories";
  private List<String> segmentCategories;

  public static final String JSON_PROPERTY_HOTEL_CATEGORIES = "hotelCategories";
  private List<String> hotelCategories;

  public static final String JSON_PROPERTY_ARCHITECTURAL_STYLES = "architecturalStyles";
  private List<String> architecturalStyles;

  public static final String JSON_PROPERTY_INVENTORY_NAME = "inventoryName";
  private String inventoryName;

  public static final String JSON_PROPERTY_CONTINENTS = "continents";
  private List<String> continents;

  public static final String JSON_PROPERTY_COUNTRIES = "countries";
  private List<String> countries;

  public static final String JSON_PROPERTY_CITIES = "cities";
  private List<String> cities;

  public static final String JSON_PROPERTY_SHOW_ECO_FRIENDLY = "showEcoFriendly";
  private Boolean showEcoFriendly = false;

  public static final String JSON_PROPERTY_SHOW_PET_FRIENDLY = "showPetFriendly";
  private Boolean showPetFriendly = false;

  public static final String JSON_PROPERTY_SHOW_CHILD_FRIENDLY = "showChildFriendly";
  private Boolean showChildFriendly = false;

  public static final String JSON_PROPERTY_SHOW_POPULAR = "showPopular";
  private Boolean showPopular = false;

  public static final String JSON_PROPERTY_SHOW_DIRECT_ONLY = "showDirectOnly";
  private Boolean showDirectOnly = false;

  /**
   * Gets or Sets lifestyles
   */
  public enum LifestylesEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestylesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestylesEnum fromValue(String value) {
      for (LifestylesEnum b : LifestylesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLES = "lifestyles";
  private List<LifestylesEnum> lifestyles;

  public static final String JSON_PROPERTY_HOTEL_STARS = "hotelStars";
  private Integer hotelStars;

  public static final String JSON_PROPERTY_AGGREGATE_REVIEW_RATING = "aggregateReviewRating";
  private Integer aggregateReviewRating;

  public static final String JSON_PROPERTY_NEAR_POINT = "nearPoint";
  private GeoJsonPointAffiliate nearPoint;

  public static final String JSON_PROPERTY_RADIUS_IN_METERS = "radiusInMeters";
  private Long radiusInMeters;

  /**
   * Gets or Sets inventoryTypes
   */
  public enum InventoryTypesEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    InventoryTypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypesEnum fromValue(String value) {
      for (InventoryTypesEnum b : InventoryTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPES = "inventoryTypes";
  private List<InventoryTypesEnum> inventoryTypes;

  public static final String JSON_PROPERTY_PRIMARY_ORDER_BY = "primaryOrderBy";
  private String primaryOrderBy;

  public UpsertDynamicSellerListRequestAffiliate() {
  }

  public UpsertDynamicSellerListRequestAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of dynamic list for when user want to persist it
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertDynamicSellerListRequestAffiliate propertyName(String propertyName) {
    
    this.propertyName = propertyName;
    return this;
  }

   /**
   * Regex expression filter matching on property name.
   * @return propertyName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPropertyName() {
    return propertyName;
  }


  @JsonProperty(JSON_PROPERTY_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPropertyName(String propertyName) {
    this.propertyName = propertyName;
  }


  public UpsertDynamicSellerListRequestAffiliate locationCategories(List<String> locationCategories) {
    
    this.locationCategories = locationCategories;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addLocationCategoriesItem(String locationCategoriesItem) {
    if (this.locationCategories == null) {
      this.locationCategories = new ArrayList<>();
    }
    this.locationCategories.add(locationCategoriesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;LOC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return locationCategories
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLocationCategories() {
    return locationCategories;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocationCategories(List<String> locationCategories) {
    this.locationCategories = locationCategories;
  }


  public UpsertDynamicSellerListRequestAffiliate segmentCategories(List<String> segmentCategories) {
    
    this.segmentCategories = segmentCategories;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addSegmentCategoriesItem(String segmentCategoriesItem) {
    if (this.segmentCategories == null) {
      this.segmentCategories = new ArrayList<>();
    }
    this.segmentCategories.add(segmentCategoriesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEG&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return segmentCategories
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSegmentCategories() {
    return segmentCategories;
  }


  @JsonProperty(JSON_PROPERTY_SEGMENT_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSegmentCategories(List<String> segmentCategories) {
    this.segmentCategories = segmentCategories;
  }


  public UpsertDynamicSellerListRequestAffiliate hotelCategories(List<String> hotelCategories) {
    
    this.hotelCategories = hotelCategories;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addHotelCategoriesItem(String hotelCategoriesItem) {
    if (this.hotelCategories == null) {
      this.hotelCategories = new ArrayList<>();
    }
    this.hotelCategories.add(hotelCategoriesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PCT&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return hotelCategories
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getHotelCategories() {
    return hotelCategories;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelCategories(List<String> hotelCategories) {
    this.hotelCategories = hotelCategories;
  }


  public UpsertDynamicSellerListRequestAffiliate architecturalStyles(List<String> architecturalStyles) {
    
    this.architecturalStyles = architecturalStyles;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addArchitecturalStylesItem(String architecturalStylesItem) {
    if (this.architecturalStyles == null) {
      this.architecturalStyles = new ArrayList<>();
    }
    this.architecturalStyles.add(architecturalStylesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;ARC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return architecturalStyles
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getArchitecturalStyles() {
    return architecturalStyles;
  }


  @JsonProperty(JSON_PROPERTY_ARCHITECTURAL_STYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArchitecturalStyles(List<String> architecturalStyles) {
    this.architecturalStyles = architecturalStyles;
  }


  public UpsertDynamicSellerListRequestAffiliate inventoryName(String inventoryName) {
    
    this.inventoryName = inventoryName;
    return this;
  }

   /**
   * Regex expression filter matching on blocking name
   * @return inventoryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInventoryName() {
    return inventoryName;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryName(String inventoryName) {
    this.inventoryName = inventoryName;
  }


  public UpsertDynamicSellerListRequestAffiliate continents(List<String> continents) {
    
    this.continents = continents;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addContinentsItem(String continentsItem) {
    if (this.continents == null) {
      this.continents = new ArrayList<>();
    }
    this.continents.add(continentsItem);
    return this;
  }

   /**
   * Continent filter
   * @return continents
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getContinents() {
    return continents;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinents(List<String> continents) {
    this.continents = continents;
  }


  public UpsertDynamicSellerListRequestAffiliate countries(List<String> countries) {
    
    this.countries = countries;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addCountriesItem(String countriesItem) {
    if (this.countries == null) {
      this.countries = new ArrayList<>();
    }
    this.countries.add(countriesItem);
    return this;
  }

   /**
   * Country filter
   * @return countries
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCountries() {
    return countries;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountries(List<String> countries) {
    this.countries = countries;
  }


  public UpsertDynamicSellerListRequestAffiliate cities(List<String> cities) {
    
    this.cities = cities;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addCitiesItem(String citiesItem) {
    if (this.cities == null) {
      this.cities = new ArrayList<>();
    }
    this.cities.add(citiesItem);
    return this;
  }

   /**
   * City filter
   * @return cities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCities() {
    return cities;
  }


  @JsonProperty(JSON_PROPERTY_CITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCities(List<String> cities) {
    this.cities = cities;
  }


  public UpsertDynamicSellerListRequestAffiliate showEcoFriendly(Boolean showEcoFriendly) {
    
    this.showEcoFriendly = showEcoFriendly;
    return this;
  }

   /**
   * Filter on eco-friendly hotels
   * @return showEcoFriendly
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ECO_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowEcoFriendly() {
    return showEcoFriendly;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ECO_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowEcoFriendly(Boolean showEcoFriendly) {
    this.showEcoFriendly = showEcoFriendly;
  }


  public UpsertDynamicSellerListRequestAffiliate showPetFriendly(Boolean showPetFriendly) {
    
    this.showPetFriendly = showPetFriendly;
    return this;
  }

   /**
   * Filter on pet-friendly hotels
   * @return showPetFriendly
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_PET_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPetFriendly() {
    return showPetFriendly;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PET_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPetFriendly(Boolean showPetFriendly) {
    this.showPetFriendly = showPetFriendly;
  }


  public UpsertDynamicSellerListRequestAffiliate showChildFriendly(Boolean showChildFriendly) {
    
    this.showChildFriendly = showChildFriendly;
    return this;
  }

   /**
   * Filter on child-friendly hotels
   * @return showChildFriendly
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_CHILD_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowChildFriendly() {
    return showChildFriendly;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_CHILD_FRIENDLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowChildFriendly(Boolean showChildFriendly) {
    this.showChildFriendly = showChildFriendly;
  }


  public UpsertDynamicSellerListRequestAffiliate showPopular(Boolean showPopular) {
    
    this.showPopular = showPopular;
    return this;
  }

   /**
   * Filter on hotel that has had a certain amount of bookings
   * @return showPopular
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_POPULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPopular() {
    return showPopular;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_POPULAR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPopular(Boolean showPopular) {
    this.showPopular = showPopular;
  }


  public UpsertDynamicSellerListRequestAffiliate showDirectOnly(Boolean showDirectOnly) {
    
    this.showDirectOnly = showDirectOnly;
    return this;
  }

   /**
   * Filter on direct blocking
   * @return showDirectOnly
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_DIRECT_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowDirectOnly() {
    return showDirectOnly;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_DIRECT_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowDirectOnly(Boolean showDirectOnly) {
    this.showDirectOnly = showDirectOnly;
  }


  public UpsertDynamicSellerListRequestAffiliate lifestyles(List<LifestylesEnum> lifestyles) {
    
    this.lifestyles = lifestyles;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addLifestylesItem(LifestylesEnum lifestylesItem) {
    if (this.lifestyles == null) {
      this.lifestyles = new ArrayList<>();
    }
    this.lifestyles.add(lifestylesItem);
    return this;
  }

   /**
   * Filter on lifestyles
   * @return lifestyles
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LifestylesEnum> getLifestyles() {
    return lifestyles;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyles(List<LifestylesEnum> lifestyles) {
    this.lifestyles = lifestyles;
  }


  public UpsertDynamicSellerListRequestAffiliate hotelStars(Integer hotelStars) {
    
    this.hotelStars = hotelStars;
    return this;
  }

   /**
   * Filter on number of stars the hotel has.
   * @return hotelStars
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOTEL_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHotelStars() {
    return hotelStars;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_STARS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelStars(Integer hotelStars) {
    this.hotelStars = hotelStars;
  }


  public UpsertDynamicSellerListRequestAffiliate aggregateReviewRating(Integer aggregateReviewRating) {
    
    this.aggregateReviewRating = aggregateReviewRating;
    return this;
  }

   /**
   * Filter on aggregate review score the hotel has
   * @return aggregateReviewRating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAggregateReviewRating() {
    return aggregateReviewRating;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_REVIEW_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateReviewRating(Integer aggregateReviewRating) {
    this.aggregateReviewRating = aggregateReviewRating;
  }


  public UpsertDynamicSellerListRequestAffiliate nearPoint(GeoJsonPointAffiliate nearPoint) {
    
    this.nearPoint = nearPoint;
    return this;
  }

   /**
   * Get nearPoint
   * @return nearPoint
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NEAR_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoJsonPointAffiliate getNearPoint() {
    return nearPoint;
  }


  @JsonProperty(JSON_PROPERTY_NEAR_POINT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNearPoint(GeoJsonPointAffiliate nearPoint) {
    this.nearPoint = nearPoint;
  }


  public UpsertDynamicSellerListRequestAffiliate radiusInMeters(Long radiusInMeters) {
    
    this.radiusInMeters = radiusInMeters;
    return this;
  }

   /**
   * Use this in conjunction with &#x60;nearPoint&#x60;. Control the distance from point we are searching for.
   * @return radiusInMeters
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRadiusInMeters() {
    return radiusInMeters;
  }


  @JsonProperty(JSON_PROPERTY_RADIUS_IN_METERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRadiusInMeters(Long radiusInMeters) {
    this.radiusInMeters = radiusInMeters;
  }


  public UpsertDynamicSellerListRequestAffiliate inventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
    
    this.inventoryTypes = inventoryTypes;
    return this;
  }

  public UpsertDynamicSellerListRequestAffiliate addInventoryTypesItem(InventoryTypesEnum inventoryTypesItem) {
    if (this.inventoryTypes == null) {
      this.inventoryTypes = new ArrayList<>();
    }
    this.inventoryTypes.add(inventoryTypesItem);
    return this;
  }

   /**
   * Filter on blocking types
   * @return inventoryTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<InventoryTypesEnum> getInventoryTypes() {
    return inventoryTypes;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryTypes(List<InventoryTypesEnum> inventoryTypes) {
    this.inventoryTypes = inventoryTypes;
  }


  public UpsertDynamicSellerListRequestAffiliate primaryOrderBy(String primaryOrderBy) {
    
    this.primaryOrderBy = primaryOrderBy;
    return this;
  }

   /**
   * Control how you want the search results sorted. Options are:  - 1: Inventory name - 2: Price: High to low - 3: Price: Low to high - 4: Commission: High to low - 5: Commission: Low to high - 6: Discount: High to low - 7: Discount: Low to high 
   * @return primaryOrderBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRIMARY_ORDER_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPrimaryOrderBy() {
    return primaryOrderBy;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY_ORDER_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimaryOrderBy(String primaryOrderBy) {
    this.primaryOrderBy = primaryOrderBy;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertDynamicSellerListRequestAffiliate upsertDynamicSellerListRequestAffiliate = (UpsertDynamicSellerListRequestAffiliate) o;
    return Objects.equals(this.name, upsertDynamicSellerListRequestAffiliate.name) &&
        Objects.equals(this.propertyName, upsertDynamicSellerListRequestAffiliate.propertyName) &&
        Objects.equals(this.locationCategories, upsertDynamicSellerListRequestAffiliate.locationCategories) &&
        Objects.equals(this.segmentCategories, upsertDynamicSellerListRequestAffiliate.segmentCategories) &&
        Objects.equals(this.hotelCategories, upsertDynamicSellerListRequestAffiliate.hotelCategories) &&
        Objects.equals(this.architecturalStyles, upsertDynamicSellerListRequestAffiliate.architecturalStyles) &&
        Objects.equals(this.inventoryName, upsertDynamicSellerListRequestAffiliate.inventoryName) &&
        Objects.equals(this.continents, upsertDynamicSellerListRequestAffiliate.continents) &&
        Objects.equals(this.countries, upsertDynamicSellerListRequestAffiliate.countries) &&
        Objects.equals(this.cities, upsertDynamicSellerListRequestAffiliate.cities) &&
        Objects.equals(this.showEcoFriendly, upsertDynamicSellerListRequestAffiliate.showEcoFriendly) &&
        Objects.equals(this.showPetFriendly, upsertDynamicSellerListRequestAffiliate.showPetFriendly) &&
        Objects.equals(this.showChildFriendly, upsertDynamicSellerListRequestAffiliate.showChildFriendly) &&
        Objects.equals(this.showPopular, upsertDynamicSellerListRequestAffiliate.showPopular) &&
        Objects.equals(this.showDirectOnly, upsertDynamicSellerListRequestAffiliate.showDirectOnly) &&
        Objects.equals(this.lifestyles, upsertDynamicSellerListRequestAffiliate.lifestyles) &&
        Objects.equals(this.hotelStars, upsertDynamicSellerListRequestAffiliate.hotelStars) &&
        Objects.equals(this.aggregateReviewRating, upsertDynamicSellerListRequestAffiliate.aggregateReviewRating) &&
        Objects.equals(this.nearPoint, upsertDynamicSellerListRequestAffiliate.nearPoint) &&
        Objects.equals(this.radiusInMeters, upsertDynamicSellerListRequestAffiliate.radiusInMeters) &&
        Objects.equals(this.inventoryTypes, upsertDynamicSellerListRequestAffiliate.inventoryTypes) &&
        Objects.equals(this.primaryOrderBy, upsertDynamicSellerListRequestAffiliate.primaryOrderBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, propertyName, locationCategories, segmentCategories, hotelCategories, architecturalStyles, inventoryName, continents, countries, cities, showEcoFriendly, showPetFriendly, showChildFriendly, showPopular, showDirectOnly, lifestyles, hotelStars, aggregateReviewRating, nearPoint, radiusInMeters, inventoryTypes, primaryOrderBy);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertDynamicSellerListRequestAffiliate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    propertyName: ").append(toIndentedString(propertyName)).append("\n");
    sb.append("    locationCategories: ").append(toIndentedString(locationCategories)).append("\n");
    sb.append("    segmentCategories: ").append(toIndentedString(segmentCategories)).append("\n");
    sb.append("    hotelCategories: ").append(toIndentedString(hotelCategories)).append("\n");
    sb.append("    architecturalStyles: ").append(toIndentedString(architecturalStyles)).append("\n");
    sb.append("    inventoryName: ").append(toIndentedString(inventoryName)).append("\n");
    sb.append("    continents: ").append(toIndentedString(continents)).append("\n");
    sb.append("    countries: ").append(toIndentedString(countries)).append("\n");
    sb.append("    cities: ").append(toIndentedString(cities)).append("\n");
    sb.append("    showEcoFriendly: ").append(toIndentedString(showEcoFriendly)).append("\n");
    sb.append("    showPetFriendly: ").append(toIndentedString(showPetFriendly)).append("\n");
    sb.append("    showChildFriendly: ").append(toIndentedString(showChildFriendly)).append("\n");
    sb.append("    showPopular: ").append(toIndentedString(showPopular)).append("\n");
    sb.append("    showDirectOnly: ").append(toIndentedString(showDirectOnly)).append("\n");
    sb.append("    lifestyles: ").append(toIndentedString(lifestyles)).append("\n");
    sb.append("    hotelStars: ").append(toIndentedString(hotelStars)).append("\n");
    sb.append("    aggregateReviewRating: ").append(toIndentedString(aggregateReviewRating)).append("\n");
    sb.append("    nearPoint: ").append(toIndentedString(nearPoint)).append("\n");
    sb.append("    radiusInMeters: ").append(toIndentedString(radiusInMeters)).append("\n");
    sb.append("    inventoryTypes: ").append(toIndentedString(inventoryTypes)).append("\n");
    sb.append("    primaryOrderBy: ").append(toIndentedString(primaryOrderBy)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

