package travel.wink.sdk.affiliate.browse.api;

import travel.wink.sdk.affiliate.browse.invoker.ApiClient;

import travel.wink.sdk.affiliate.browse.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.browse.model.InventoryAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.InventorySupplierAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventoryAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventorySupplierAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpdateCuratedList400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class BrowseApi {
    private ApiClient apiClient;

    public BrowseApi() {
        this(new ApiClient());
    }

    @Autowired
    public BrowseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Show Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCitiesForInventoryRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showCitiesForInventory(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCitiesForInventoryRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCitiesForInventoryWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCitiesForInventoryRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Supplier Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCitiesForInventoryWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCitiesForInventoryRequestCreation(winkVersion, accept);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCitiesForInventory1RequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/city/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showCitiesForInventory1(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCitiesForInventory1RequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCitiesForInventory1WithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCitiesForInventory1RequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Cities
     * Retrieve list of cities affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCitiesForInventory1WithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCitiesForInventory1RequestCreation(winkVersion, accept);
    }

    /**
     * Show Inventory Continents
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContinentsForInventoryRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/continent/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Continents
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showContinentsForInventory(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showContinentsForInventoryRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Continents
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showContinentsForInventoryWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showContinentsForInventoryRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Continents
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContinentsForInventoryWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showContinentsForInventoryRequestCreation(winkVersion, accept);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showContinentsForInventorySupplierRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/continent/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showContinentsForInventorySupplier(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showContinentsForInventorySupplierRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showContinentsForInventorySupplierWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showContinentsForInventorySupplierRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showContinentsForInventorySupplierWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showContinentsForInventorySupplierRequestCreation(winkVersion, accept);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesForInventoryRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showCountriesForInventory(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCountriesForInventoryRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCountriesForInventoryWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCountriesForInventoryRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesForInventoryWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCountriesForInventoryRequestCreation(winkVersion, accept);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCountriesForInventorySupplierRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/country/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;KeyValuePairAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<KeyValuePairAffiliate> showCountriesForInventorySupplier(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCountriesForInventorySupplierRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;KeyValuePairAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCountriesForInventorySupplierWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>() {};
        return showCountriesForInventorySupplierRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Supplier Countries
     * Retrieve list of countries affiliate has access to.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCountriesForInventorySupplierWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCountriesForInventorySupplierRequestCreation(winkVersion, accept);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryRequestCreation(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = dynamicSellerListRequestAffiliate;
        // verify the required parameter 'dynamicSellerListRequestAffiliate' is set
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventoryAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventoryAggregateLightweightAffiliate> showDynamicSellerInventory(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventoryAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventoryAggregateLightweightAffiliate>> showDynamicSellerInventoryWithHttpInfo(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Inventory Search
     * Retrieves a paginated result set of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryWithResponseSpec(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }

    /**
     * Supplier Search by Saved Search
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageInventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryByIdRequestCreation(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'dynamicListIdentifier' is set
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Supplier Search by Saved Search
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageInventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventorySupplierAggregateLightweightAffiliate> showDynamicSellerInventoryById(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Supplier Search by Saved Search
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageInventorySupplierAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventorySupplierAggregateLightweightAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Supplier Search by Saved Search
     * Retrieves a paginated result set based on the given list identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory supplier on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryByIdWithResponseSpec(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    /**
     * Inventory Search by Saved Search
     * Retrieves a paginated result set based on the given saved search ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Limit the size of results.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageInventoryAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showDynamicSellerInventoryById_0RequestCreation(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'dynamicListIdentifier' is set
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById_0", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Inventory Search by Saved Search
     * Retrieves a paginated result set based on the given saved search ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Limit the size of results.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return PageInventoryAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventoryAggregateLightweightAffiliate> showDynamicSellerInventoryById_0(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Inventory Search by Saved Search
     * Retrieves a paginated result set based on the given saved search ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Limit the size of results.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;PageInventoryAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventoryAggregateLightweightAffiliate>> showDynamicSellerInventoryById_0WithHttpInfo(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>() {};
        return showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Inventory Search by Saved Search
     * Retrieves a paginated result set based on the given saved search ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicListIdentifier Browse inventory on behalf of this dynamic list identifier.
     * @param page Skip to page.
     * @param size Limit the size of results.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showDynamicSellerInventoryById_0WithResponseSpec(@jakarta.annotation.Nonnull String dynamicListIdentifier, @jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    /**
     * Show Supplier
     * Retrieves supplier details based on existing sales channel ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return InventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventorySupplierRequestCreation(@jakarta.annotation.Nonnull String supplierIdentifier, @jakarta.annotation.Nonnull String salesChannelIdentifier, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'supplierIdentifier' is set
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'salesChannelIdentifier' is set
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("supplierIdentifier", supplierIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/{supplierIdentifier}/sales-channel/{salesChannelIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Supplier
     * Retrieves supplier details based on existing sales channel ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return InventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventorySupplierAggregateLightweightAffiliate> showInventorySupplier(@jakarta.annotation.Nonnull String supplierIdentifier, @jakarta.annotation.Nonnull String salesChannelIdentifier, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Supplier
     * Retrieves supplier details based on existing sales channel ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;InventorySupplierAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventorySupplierAggregateLightweightAffiliate>> showInventorySupplierWithHttpInfo(@jakarta.annotation.Nonnull String supplierIdentifier, @jakarta.annotation.Nonnull String salesChannelIdentifier, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Supplier
     * Retrieves supplier details based on existing sales channel ID.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param supplierIdentifier Browse inventory supplier on behalf of this supplier identifier.
     * @param salesChannelIdentifier Browse inventory supplier on behalf of this sales channel identifier.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showInventorySupplierWithResponseSpec(@jakarta.annotation.Nonnull String supplierIdentifier, @jakarta.annotation.Nonnull String salesChannelIdentifier, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;InventoryAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLatestInventoryRequestCreation(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/inventory/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;InventoryAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventoryAggregateLightweightAffiliate> showLatestInventory(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>() {};
        return showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;InventoryAggregateLightweightAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<InventoryAggregateLightweightAffiliate>>> showLatestInventoryWithHttpInfo(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>() {};
        return showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Latest Inventory
     * Retrieves a list of latest available inventory.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLatestInventoryWithResponseSpec(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    /**
     * Latest Suppliers
     * Retrieves a list of latest available inventorysuppliers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;InventorySupplierAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showLatestInventorySupplierListRequestCreation(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Latest Suppliers
     * Retrieves a list of latest available inventorysuppliers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;InventorySupplierAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<InventorySupplierAggregateLightweightAffiliate> showLatestInventorySupplierList(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Latest Suppliers
     * Retrieves a list of latest available inventorysuppliers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;InventorySupplierAggregateLightweightAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<InventorySupplierAggregateLightweightAffiliate>>> showLatestInventorySupplierListWithHttpInfo(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>() {};
        return showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Latest Suppliers
     * Retrieves a list of latest available inventorysuppliers.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param page Skip to page.
     * @param size Skip to page.
     * @param displayCurrency Indicate which currency to display prices in.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showLatestInventorySupplierListWithResponseSpec(@jakarta.annotation.Nullable Integer page, @jakarta.annotation.Nullable Integer size, @jakarta.annotation.Nullable String displayCurrency, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    /**
     * Supplier Search
     * Retrieves a paginated result set of suppliers of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSuppliersForDynamicSellerInventoryRequestCreation(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = dynamicSellerListRequestAffiliate;
        // verify the required parameter 'dynamicSellerListRequestAffiliate' is set
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return apiClient.invokeAPI("/api/browse/supplier/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Supplier Search
     * Retrieves a paginated result set of suppliers of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return PageInventorySupplierAggregateLightweightAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<PageInventorySupplierAggregateLightweightAffiliate> showSuppliersForDynamicSellerInventory(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Supplier Search
     * Retrieves a paginated result set of suppliers of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;PageInventorySupplierAggregateLightweightAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<PageInventorySupplierAggregateLightweightAffiliate>> showSuppliersForDynamicSellerInventoryWithHttpInfo(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>() {};
        return showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Supplier Search
     * Retrieves a paginated result set of suppliers of inventorybased on the search criteria of the caller.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param dynamicSellerListRequestAffiliate The dynamicSellerListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSuppliersForDynamicSellerInventoryWithResponseSpec(@jakarta.annotation.Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }
}
