package travel.wink.sdk.affiliate.browse.api;

import travel.wink.sdk.affiliate.browse.invoker.ApiClient;

import travel.wink.sdk.affiliate.browse.model.AddStaticListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.AddStaticListSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CopyMoveStaticListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticListAndAddSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.browse.model.SortStaticListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListItemAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListWrapperAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpdateCuratedList400Response;
import travel.wink.sdk.affiliate.browse.model.UpsertStaticListRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class CuratedListApi {
    private ApiClient apiClient;

    public CuratedListApi() {
        this(new ApiClient());
    }

    @Autowired
    public CuratedListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Add Inventory to List
     * Add some travel inventoryto your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListItemRequestAffiliate The addStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addInventoryToCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = addStaticListItemRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticListItemRequestAffiliate' is set
        if (addStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel inventoryto your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListItemRequestAffiliate The addStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListItemAffiliate> addInventoryToCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel inventoryto your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListItemRequestAffiliate The addStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListItemAffiliate>> addInventoryToCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Inventory to List
     * Add some travel inventoryto your existing curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListItemRequestAffiliate The addStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addInventoryToCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListSupplierRequestAffiliate The addStaticListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addSupplierToCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = addStaticListSupplierRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'addStaticListSupplierRequestAffiliate' is set
        if (addStaticListSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticListSupplierRequestAffiliate' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/supplier", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListSupplierRequestAffiliate The addStaticListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListItemAffiliate> addSupplierToCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListSupplierRequestAffiliate The addStaticListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListItemAffiliate>> addSupplierToCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Add Supplier to List
     * Adds a new list item for a supplier showing the best priced room..
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param addStaticListSupplierRequestAffiliate The addStaticListSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addSupplierToCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec copyInventoryToCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticListItemRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticListItemRequestAffiliate' is set
        if (copyMoveStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListItemAffiliate> copyInventoryToCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListItemAffiliate>> copyInventoryToCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Copy Item to List
     * Copy an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec copyInventoryToCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddItemRequestAffiliate The createStaticListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedListRequestCreation(@jakarta.annotation.Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = createStaticListAndAddItemRequestAffiliate;
        // verify the required parameter 'createStaticListAndAddItemRequestAffiliate' is set
        if (createStaticListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddItemRequestAffiliate The createStaticListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListWrapperAffiliate> createCuratedList(@jakarta.annotation.Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddItemRequestAffiliate The createStaticListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListWrapperAffiliate>> createCuratedListWithHttpInfo(@jakarta.annotation.Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddItemRequestAffiliate The createStaticListAndAddItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCuratedListWithResponseSpec(@jakarta.annotation.Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddSupplierRequestAffiliate The createStaticListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCuratedSupplierListRequestCreation(@jakarta.annotation.Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = createStaticListAndAddSupplierRequestAffiliate;
        // verify the required parameter 'createStaticListAndAddSupplierRequestAffiliate' is set
        if (createStaticListAndAddSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticListAndAddSupplierRequestAffiliate' when calling createCuratedSupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/supplier", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddSupplierRequestAffiliate The createStaticListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListWrapperAffiliate> createCuratedSupplierList(@jakarta.annotation.Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddSupplierRequestAffiliate The createStaticListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListWrapperAffiliate>> createCuratedSupplierListWithHttpInfo(@jakarta.annotation.Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Curated List
     * Create a new curated list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param createStaticListAndAddSupplierRequestAffiliate The createStaticListAndAddSupplierRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCuratedSupplierListWithResponseSpec(@jakarta.annotation.Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec moveInventoryToCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = copyMoveStaticListItemRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'copyMoveStaticListItemRequestAffiliate' is set
        if (copyMoveStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListItemAffiliate> moveInventoryToCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListItemAffiliate>> moveInventoryToCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Move List Item
     * Move an existing list item from one list to another.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param copyMoveStaticListItemRequestAffiliate The copyMoveStaticListItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec moveInventoryToCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListAffiliate> removeCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>() {};
        return removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;StaticListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListAffiliate>> removeCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>() {};
        return removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Curated List
     * Remove curated list by list identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeCuratedListRequestCreation(listIdentifier, winkVersion, accept);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeInventoryFromCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'itemIdentifier' is set
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return StaticListItemAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListItemAffiliate> removeInventoryFromCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListItemAffiliate>> removeInventoryFromCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete List Item
     * Delete a list item from a curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param itemIdentifier Item identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeInventoryFromCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull String itemIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;StaticListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCuratedListsRequestCreation(@jakarta.annotation.Nullable Boolean withItems, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "withItems", withItems));
        

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;StaticListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticListWrapperAffiliate> showCuratedLists(@jakarta.annotation.Nullable Boolean withItems, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(withItems, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;StaticListWrapperAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<StaticListWrapperAffiliate>>> showCuratedListsWithHttpInfo(@jakarta.annotation.Nullable Boolean withItems, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return showCuratedListsRequestCreation(withItems, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Curated Lists
     * Retrieve lists optionally with content.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param withItems Indicate whether to include all the list items in the result
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCuratedListsWithResponseSpec(@jakarta.annotation.Nullable Boolean withItems, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showCuratedListsRequestCreation(withItems, winkVersion, accept);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param sortStaticListItemsRequestAffiliate The sortStaticListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec sortCuratedListItemsRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = sortStaticListItemsRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sortStaticListItemsRequestAffiliate' is set
        if (sortStaticListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param sortStaticListItemsRequestAffiliate The sortStaticListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;StaticListItemAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StaticListItemAffiliate> sortCuratedListItems(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param sortStaticListItemsRequestAffiliate The sortStaticListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;StaticListItemAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<StaticListItemAffiliate>>> sortCuratedListItemsWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>() {};
        return sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Re-Order List Items
     * Re-order list items with an existing list
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param sortStaticListItemsRequestAffiliate The sortStaticListItemsRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec sortCuratedListItemsWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param upsertStaticListRequestAffiliate The upsertStaticListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCuratedListRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertStaticListRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertStaticListRequestAffiliate' is set
        if (upsertStaticListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertStaticListRequestAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param upsertStaticListRequestAffiliate The upsertStaticListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return StaticListWrapperAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<StaticListWrapperAffiliate> updateCuratedList(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param upsertStaticListRequestAffiliate The upsertStaticListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;StaticListWrapperAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<StaticListWrapperAffiliate>> updateCuratedListWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>() {};
        return updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Curated List
     * Update curated list by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier List identifier.
     * @param upsertStaticListRequestAffiliate The upsertStaticListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCuratedListWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion);
    }
}
