package travel.wink.sdk.affiliate.browse.api;

import travel.wink.sdk.affiliate.browse.invoker.ApiClient;

import travel.wink.sdk.affiliate.browse.model.DynamicListAffiliate;
import travel.wink.sdk.affiliate.browse.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.browse.model.UpdateCuratedList400Response;
import travel.wink.sdk.affiliate.browse.model.UpsertDynamicListRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Arrays;
import java.util.stream.Collectors;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class DynamicListApi {
    private ApiClient apiClient;

    public DynamicListApi() {
        this(new ApiClient());
    }

    @Autowired
    public DynamicListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    
    /**
     * Create Dynamic List
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSavedSearchRequestCreation(@jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertDynamicListRequestAffiliate;
        // verify the required parameter 'upsertDynamicListRequestAffiliate' is set
        if (upsertDynamicListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicListRequestAffiliate' when calling createSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return apiClient.invokeAPI("/api/dynamic-list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Dynamic List
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DynamicListAffiliate> createSavedSearch(@jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Dynamic List
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;DynamicListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DynamicListAffiliate>> createSavedSearchWithHttpInfo(@jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Dynamic List
     * Create a new dynamic saved search.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSavedSearchWithResponseSpec(@jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion);
    }

    /**
     * Remove Dynamic List
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSavedSearchRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return apiClient.invokeAPI("/api/dynamic-list/{listIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Dynamic List
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DynamicListAffiliate> removeSavedSearch(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Dynamic List
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;DynamicListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DynamicListAffiliate>> removeSavedSearchWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Remove Dynamic List
     * Remove saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSavedSearchWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept);
    }

    /**
     * Show Dynamic Lists
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;DynamicListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSavedSearchesRequestCreation(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return apiClient.invokeAPI("/api/dynamic-list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Dynamic Lists
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;DynamicListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DynamicListAffiliate> showSavedSearches(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return showSavedSearchesRequestCreation(winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Dynamic Lists
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;DynamicListAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<DynamicListAffiliate>>> showSavedSearchesWithHttpInfo(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return showSavedSearchesRequestCreation(winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Dynamic Lists
     * Retrieve all saved searches for owner
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSavedSearchesWithResponseSpec(@jakarta.annotation.Nullable String winkVersion, @jakarta.annotation.Nullable String accept) throws WebClientResponseException {
        return showSavedSearchesRequestCreation(winkVersion, accept);
    }

    /**
     * Update Dynamic List
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSavedSearchRequestCreation(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        Object postBody = upsertDynamicListRequestAffiliate;
        // verify the required parameter 'listIdentifier' is set
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertDynamicListRequestAffiliate' is set
        if (upsertDynamicListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicListRequestAffiliate' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("listIdentifier", listIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();


        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return apiClient.invokeAPI("/api/dynamic-list/{listIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Dynamic List
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return DynamicListAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DynamicListAffiliate> updateSavedSearch(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Dynamic List
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;DynamicListAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DynamicListAffiliate>> updateSavedSearchWithHttpInfo(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>() {};
        return updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Dynamic List
     * Update a existing saved search record by its unique identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param listIdentifier Saved search identifier.
     * @param upsertDynamicListRequestAffiliate The upsertDynamicListRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSavedSearchWithResponseSpec(@jakarta.annotation.Nonnull String listIdentifier, @jakarta.annotation.Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @jakarta.annotation.Nullable String winkVersion) throws WebClientResponseException {
        return updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion);
    }
}
