/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and inventory to sell. This API lets you:  1. Browse: Find inventory and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Address information
 */
@JsonPropertyOrder({
  SimpleAddressAffiliate.JSON_PROPERTY_ADDRESS1,
  SimpleAddressAffiliate.JSON_PROPERTY_ADDRESS2,
  SimpleAddressAffiliate.JSON_PROPERTY_STATE,
  SimpleAddressAffiliate.JSON_PROPERTY_POSTAL_CODE,
  SimpleAddressAffiliate.JSON_PROPERTY_COUNTY,
  SimpleAddressAffiliate.JSON_PROPERTY_CITY,
  SimpleAddressAffiliate.JSON_PROPERTY_COUNTRY_CODE,
  SimpleAddressAffiliate.JSON_PROPERTY_COUNTRY,
  SimpleAddressAffiliate.JSON_PROPERTY_FULL_ADDRESS
})
@JsonTypeName("SimpleAddress_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class SimpleAddressAffiliate {
  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  @jakarta.annotation.Nonnull
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  @jakarta.annotation.Nullable
  private String address2;

  public static final String JSON_PROPERTY_STATE = "state";
  @jakarta.annotation.Nullable
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  @jakarta.annotation.Nonnull
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTY = "county";
  @jakarta.annotation.Nullable
  private String county;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nonnull
  private String city;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  @jakarta.annotation.Nonnull
  private String countryCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nullable
  private String country;

  public static final String JSON_PROPERTY_FULL_ADDRESS = "fullAddress";
  @jakarta.annotation.Nullable
  private String fullAddress;

  public SimpleAddressAffiliate() {
  }
  /**
   * Constructor with only readonly parameters
   */
  @JsonCreator
  public SimpleAddressAffiliate(
    @JsonProperty(JSON_PROPERTY_COUNTRY) String country, 
    @JsonProperty(JSON_PROPERTY_FULL_ADDRESS) String fullAddress
  ) {
    this();
    this.country = country;
    this.fullAddress = fullAddress;
  }

  public SimpleAddressAffiliate address1(@jakarta.annotation.Nonnull String address1) {
    
    this.address1 = address1;
    return this;
  }

  /**
   * Address line 1
   * @return address1
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress1(@jakarta.annotation.Nonnull String address1) {
    this.address1 = address1;
  }

  public SimpleAddressAffiliate address2(@jakarta.annotation.Nullable String address2) {
    
    this.address2 = address2;
    return this;
  }

  /**
   * Address line 2
   * @return address2
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(@jakarta.annotation.Nullable String address2) {
    this.address2 = address2;
  }

  public SimpleAddressAffiliate state(@jakarta.annotation.Nullable String state) {
    
    this.state = state;
    return this;
  }

  /**
   * State
   * @return state
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@jakarta.annotation.Nullable String state) {
    this.state = state;
  }

  public SimpleAddressAffiliate postalCode(@jakarta.annotation.Nonnull String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Postal / zip code
   * @return postalCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPostalCode(@jakarta.annotation.Nonnull String postalCode) {
    this.postalCode = postalCode;
  }

  public SimpleAddressAffiliate county(@jakarta.annotation.Nullable String county) {
    
    this.county = county;
    return this;
  }

  /**
   * County
   * @return county
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCounty() {
    return county;
  }


  @JsonProperty(JSON_PROPERTY_COUNTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCounty(@jakarta.annotation.Nullable String county) {
    this.county = county;
  }

  public SimpleAddressAffiliate city(@jakarta.annotation.Nonnull String city) {
    
    this.city = city;
    return this;
  }

  /**
   * City name
   * @return city
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCity(@jakarta.annotation.Nonnull String city) {
    this.city = city;
  }

  public SimpleAddressAffiliate countryCode(@jakarta.annotation.Nonnull String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Country
   * @return countryCode
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountryCode(@jakarta.annotation.Nonnull String countryCode) {
    this.countryCode = countryCode;
  }

  /**
   * Country
   * @return country
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }



  /**
   * Address 1, Address 2, City, State, Postal / Zip code, Country
   * @return fullAddress
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullAddress() {
    return fullAddress;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimpleAddressAffiliate simpleAddressAffiliate = (SimpleAddressAffiliate) o;
    return Objects.equals(this.address1, simpleAddressAffiliate.address1) &&
        Objects.equals(this.address2, simpleAddressAffiliate.address2) &&
        Objects.equals(this.state, simpleAddressAffiliate.state) &&
        Objects.equals(this.postalCode, simpleAddressAffiliate.postalCode) &&
        Objects.equals(this.county, simpleAddressAffiliate.county) &&
        Objects.equals(this.city, simpleAddressAffiliate.city) &&
        Objects.equals(this.countryCode, simpleAddressAffiliate.countryCode) &&
        Objects.equals(this.country, simpleAddressAffiliate.country) &&
        Objects.equals(this.fullAddress, simpleAddressAffiliate.fullAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(address1, address2, state, postalCode, county, city, countryCode, country, fullAddress);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimpleAddressAffiliate {\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    county: ").append(toIndentedString(county)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    fullAddress: ").append(toIndentedString(fullAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

