/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and inventory to sell. This API lets you:  1. Browse: Find inventory and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import travel.wink.sdk.affiliate.browse.model.LocalizedDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SpecialRateBundleLightweightAffiliate
 */
@JsonPropertyOrder({
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_IDENTIFIER,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_HOTEL_IDENTIFIER,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_NAME,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_ENABLED,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_ITEMS,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_MODIFIER_OVERRIDE,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_TYPE,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_PRICING_TYPE,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_IS_VALID,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_DESCRIPTION,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER,
  SpecialRateBundleLightweightAffiliate.JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER
})
@JsonTypeName("SpecialRateBundleLightweight_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class SpecialRateBundleLightweightAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  @jakarta.annotation.Nonnull
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  @jakarta.annotation.Nonnull
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_ITEMS = "items";
  @jakarta.annotation.Nonnull
  private List<Object> items = new ArrayList<>();

  public static final String JSON_PROPERTY_MODIFIER_OVERRIDE = "modifierOverride";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> modifierOverride = JsonNullable.<Object>of(null);

  /**
   * Required if manual override modifier is not null
   */
  public enum TypeEnum {
    PREMIUM(String.valueOf("PREMIUM")),
    
    DISCOUNT(String.valueOf("DISCOUNT"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nullable
  private TypeEnum type;

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   */
  public enum PricingTypeEnum {
    PER_STAY(String.valueOf("PER_STAY")),
    
    PER_DAY(String.valueOf("PER_DAY")),
    
    PER_NIGHT(String.valueOf("PER_NIGHT")),
    
    PER_USE(String.valueOf("PER_USE")),
    
    PER_HOUR(String.valueOf("PER_HOUR")),
    
    PER_PERSON(String.valueOf("PER_PERSON")),
    
    PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
    
    PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
    
    PER_ADULT(String.valueOf("PER_ADULT")),
    
    PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
    
    PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
    
    PER_CHILD(String.valueOf("PER_CHILD")),
    
    PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
    
    PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  @jakarta.annotation.Nullable
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_IS_VALID = "isValid";
  @jakarta.annotation.Nullable
  private Boolean isValid;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private List<@Valid LocalizedDescriptionAffiliate> description = new ArrayList<>();

  public static final String JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER = "hasFixedDiscountModifier";
  @jakarta.annotation.Nullable
  private Boolean hasFixedDiscountModifier;

  public static final String JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER = "hasPercentDiscountModifier";
  @jakarta.annotation.Nullable
  private Boolean hasPercentDiscountModifier;

  public SpecialRateBundleLightweightAffiliate() {
  }

  public SpecialRateBundleLightweightAffiliate identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique record identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public SpecialRateBundleLightweightAffiliate hotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

  /**
   * Hotel identifier.
   * @return hotelIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }

  public SpecialRateBundleLightweightAffiliate name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Internal name of promotion ancillary.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public SpecialRateBundleLightweightAffiliate enabled(@jakarta.annotation.Nonnull Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether this promotion ancillary is enabled or not.
   * @return enabled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(@jakarta.annotation.Nonnull Boolean enabled) {
    this.enabled = enabled;
  }

  public SpecialRateBundleLightweightAffiliate items(@jakarta.annotation.Nonnull List<Object> items) {
    
    this.items = items;
    return this;
  }

  public SpecialRateBundleLightweightAffiliate addItemsItem(Object itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Object> getItems() {
    return items;
  }


  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItems(@jakarta.annotation.Nonnull List<Object> items) {
    this.items = items;
  }

  public SpecialRateBundleLightweightAffiliate modifierOverride(@jakarta.annotation.Nullable Object modifierOverride) {
    this.modifierOverride = JsonNullable.<Object>of(modifierOverride);
    
    return this;
  }

  /**
   * Get modifierOverride
   * @return modifierOverride
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getModifierOverride() {
        return modifierOverride.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getModifierOverride_JsonNullable() {
    return modifierOverride;
  }
  
  @JsonProperty(JSON_PROPERTY_MODIFIER_OVERRIDE)
  public void setModifierOverride_JsonNullable(JsonNullable<Object> modifierOverride) {
    this.modifierOverride = modifierOverride;
  }

  public void setModifierOverride(@jakarta.annotation.Nullable Object modifierOverride) {
    this.modifierOverride = JsonNullable.<Object>of(modifierOverride);
  }

  public SpecialRateBundleLightweightAffiliate type(@jakarta.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Required if manual override modifier is not null
   * @return type
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@jakarta.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public SpecialRateBundleLightweightAffiliate pricingType(@jakarta.annotation.Nullable PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

  /**
   * Determines whether this discount should be applied per night, per stay or per person - per night; Required if amount override is not null
   * @return pricingType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPricingType(@jakarta.annotation.Nullable PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }

  public SpecialRateBundleLightweightAffiliate isValid(@jakarta.annotation.Nullable Boolean isValid) {
    
    this.isValid = isValid;
    return this;
  }

  /**
   * Get isValid
   * @return isValid
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsValid() {
    return isValid;
  }


  @JsonProperty(JSON_PROPERTY_IS_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsValid(@jakarta.annotation.Nullable Boolean isValid) {
    this.isValid = isValid;
  }

  public SpecialRateBundleLightweightAffiliate description(@jakarta.annotation.Nullable List<@Valid LocalizedDescriptionAffiliate> description) {
    
    this.description = description;
    return this;
  }

  public SpecialRateBundleLightweightAffiliate addDescriptionItem(LocalizedDescriptionAffiliate descriptionItem) {
    if (this.description == null) {
      this.description = new ArrayList<>();
    }
    this.description.add(descriptionItem);
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid LocalizedDescriptionAffiliate> getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable List<@Valid LocalizedDescriptionAffiliate> description) {
    this.description = description;
  }

  public SpecialRateBundleLightweightAffiliate hasFixedDiscountModifier(@jakarta.annotation.Nullable Boolean hasFixedDiscountModifier) {
    
    this.hasFixedDiscountModifier = hasFixedDiscountModifier;
    return this;
  }

  /**
   * Get hasFixedDiscountModifier
   * @return hasFixedDiscountModifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFixedDiscountModifier() {
    return hasFixedDiscountModifier;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FIXED_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFixedDiscountModifier(@jakarta.annotation.Nullable Boolean hasFixedDiscountModifier) {
    this.hasFixedDiscountModifier = hasFixedDiscountModifier;
  }

  public SpecialRateBundleLightweightAffiliate hasPercentDiscountModifier(@jakarta.annotation.Nullable Boolean hasPercentDiscountModifier) {
    
    this.hasPercentDiscountModifier = hasPercentDiscountModifier;
    return this;
  }

  /**
   * Get hasPercentDiscountModifier
   * @return hasPercentDiscountModifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPercentDiscountModifier() {
    return hasPercentDiscountModifier;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PERCENT_DISCOUNT_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPercentDiscountModifier(@jakarta.annotation.Nullable Boolean hasPercentDiscountModifier) {
    this.hasPercentDiscountModifier = hasPercentDiscountModifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpecialRateBundleLightweightAffiliate specialRateBundleLightweightAffiliate = (SpecialRateBundleLightweightAffiliate) o;
    return Objects.equals(this.identifier, specialRateBundleLightweightAffiliate.identifier) &&
        Objects.equals(this.hotelIdentifier, specialRateBundleLightweightAffiliate.hotelIdentifier) &&
        Objects.equals(this.name, specialRateBundleLightweightAffiliate.name) &&
        Objects.equals(this.enabled, specialRateBundleLightweightAffiliate.enabled) &&
        Objects.equals(this.items, specialRateBundleLightweightAffiliate.items) &&
        equalsNullable(this.modifierOverride, specialRateBundleLightweightAffiliate.modifierOverride) &&
        Objects.equals(this.type, specialRateBundleLightweightAffiliate.type) &&
        Objects.equals(this.pricingType, specialRateBundleLightweightAffiliate.pricingType) &&
        Objects.equals(this.isValid, specialRateBundleLightweightAffiliate.isValid) &&
        Objects.equals(this.description, specialRateBundleLightweightAffiliate.description) &&
        Objects.equals(this.hasFixedDiscountModifier, specialRateBundleLightweightAffiliate.hasFixedDiscountModifier) &&
        Objects.equals(this.hasPercentDiscountModifier, specialRateBundleLightweightAffiliate.hasPercentDiscountModifier);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, enabled, items, hashCodeNullable(modifierOverride), type, pricingType, isValid, description, hasFixedDiscountModifier, hasPercentDiscountModifier);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpecialRateBundleLightweightAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    modifierOverride: ").append(toIndentedString(modifierOverride)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    isValid: ").append(toIndentedString(isValid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    hasFixedDiscountModifier: ").append(toIndentedString(hasFixedDiscountModifier)).append("\n");
    sb.append("    hasPercentDiscountModifier: ").append(toIndentedString(hasPercentDiscountModifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

