/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Browse API The Browse API exposes endpoints to find suppliers and inventory to sell. This API lets you:  1. Browse: Find inventory and suppliers. 2. Saved Search: Manage saved searches 3. Curated List: Manage curated lists  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.browse.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import travel.wink.sdk.affiliate.browse.model.LocalizedDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SpecialRateLightweightAffiliate
 */
@JsonPropertyOrder({
  SpecialRateLightweightAffiliate.JSON_PROPERTY_IDENTIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_HOTEL_IDENTIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_NAME,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_TYPE,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_MODIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_ENABLED,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_PRICING_TYPE,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_CITY_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_PREPAY_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_MASTER_RATE_IDENTIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_ADD_ON_IDENTIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_RATE_PLAN_IDENTIFIERS,
  SpecialRateLightweightAffiliate.JSON_PROPERTY_BLACKOUT_DATES
})
@JsonTypeName("SpecialRateLightweight_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:15:43.926055890+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class SpecialRateLightweightAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  @jakarta.annotation.Nonnull
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   */
  public enum TypeEnum {
    PREMIUM(String.valueOf("PREMIUM")),
    
    DISCOUNT(String.valueOf("DISCOUNT"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_MODIFIER = "modifier";
  @jakarta.annotation.Nullable
  private Object modifier = null;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  @jakarta.annotation.Nonnull
  private Boolean enabled = true;

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   */
  public enum PricingTypeEnum {
    PER_STAY(String.valueOf("PER_STAY")),
    
    PER_DAY(String.valueOf("PER_DAY")),
    
    PER_NIGHT(String.valueOf("PER_NIGHT")),
    
    PER_USE(String.valueOf("PER_USE")),
    
    PER_HOUR(String.valueOf("PER_HOUR")),
    
    PER_PERSON(String.valueOf("PER_PERSON")),
    
    PER_PERSON_PER_NIGHT(String.valueOf("PER_PERSON_PER_NIGHT")),
    
    PER_PERSON_PER_HOUR(String.valueOf("PER_PERSON_PER_HOUR")),
    
    PER_ADULT(String.valueOf("PER_ADULT")),
    
    PER_ADULT_PER_NIGHT(String.valueOf("PER_ADULT_PER_NIGHT")),
    
    PER_ADULT_PER_HOUR(String.valueOf("PER_ADULT_PER_HOUR")),
    
    PER_CHILD(String.valueOf("PER_CHILD")),
    
    PER_CHILD_PER_NIGHT(String.valueOf("PER_CHILD_PER_NIGHT")),
    
    PER_CHILD_PER_HOUR(String.valueOf("PER_CHILD_PER_HOUR"));

    private String value;

    PricingTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricingTypeEnum fromValue(String value) {
      for (PricingTypeEnum b : PricingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICING_TYPE = "pricingType";
  @jakarta.annotation.Nonnull
  private PricingTypeEnum pricingType;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  @jakarta.annotation.Nonnull
  private List<@Valid LocalizedDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_CITY_RATE_QUALIFIERS = "cityRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> cityRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS = "continentRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> continentRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS = "countryRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> countryRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS = "promotionRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> promotionRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS = "ipRangeRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> ipRangeRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER = "roomRangeRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> roomRangeRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_PREPAY_RATE_QUALIFIER = "prepayRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> prepayRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER = "refundableRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> refundableRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS = "timezoneRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> timezoneRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER = "lastMinuteRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> lastMinuteRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER = "lengthOfStayRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> lengthOfStayRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER = "advanceBookingRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> advanceBookingRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS = "stayDateRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> stayDateRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS = "sellDateRateQualifiers";
  @jakarta.annotation.Nullable
  private List<Object> sellDateRateQualifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER = "availableDaysOfWeekRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> availableDaysOfWeekRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER = "arrivalDaysOfWeekRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> arrivalDaysOfWeekRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER = "departureDaysOfWeekRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> departureDaysOfWeekRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER = "requiredDaysOfWeekRateQualifier";
  @jakarta.annotation.Nullable
  private JsonNullable<Object> requiredDaysOfWeekRateQualifier = JsonNullable.<Object>of(null);

  public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIERS = "masterRateIdentifiers";
  @jakarta.annotation.Nullable
  private List<String> masterRateIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ADD_ON_IDENTIFIERS = "addOnIdentifiers";
  @jakarta.annotation.Nullable
  private List<String> addOnIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIERS = "ratePlanIdentifiers";
  @jakarta.annotation.Nullable
  private List<String> ratePlanIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_BLACKOUT_DATES = "blackoutDates";
  @jakarta.annotation.Nullable
  private List<Object> blackoutDates = new ArrayList<>();

  public SpecialRateLightweightAffiliate() {
  }

  public SpecialRateLightweightAffiliate identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique record identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public SpecialRateLightweightAffiliate hotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

  /**
   * Hotel identifier.
   * @return hotelIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }

  public SpecialRateLightweightAffiliate name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Internal name of promotion.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public SpecialRateLightweightAffiliate type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Set whether you want the price to go up or down when the rules of this promotion have been satisfied.
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public SpecialRateLightweightAffiliate modifier(@jakarta.annotation.Nullable Object modifier) {
    
    this.modifier = modifier;
    return this;
  }

  /**
   * Get modifier
   * @return modifier
   */
  @jakarta.annotation.Nullable
  @NotNull

  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Object getModifier() {
    return modifier;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifier(@jakarta.annotation.Nullable Object modifier) {
    this.modifier = modifier;
  }

  public SpecialRateLightweightAffiliate enabled(@jakarta.annotation.Nonnull Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

  /**
   * Whether this promotion is enabled or not.
   * @return enabled
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEnabled(@jakarta.annotation.Nonnull Boolean enabled) {
    this.enabled = enabled;
  }

  public SpecialRateLightweightAffiliate pricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    
    this.pricingType = pricingType;
    return this;
  }

  /**
   * This determines whether this discount should be applied per night, per stay or per person - per night
   * @return pricingType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricingTypeEnum getPricingType() {
    return pricingType;
  }


  @JsonProperty(JSON_PROPERTY_PRICING_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricingType(@jakarta.annotation.Nonnull PricingTypeEnum pricingType) {
    this.pricingType = pricingType;
  }

  public SpecialRateLightweightAffiliate descriptions(@jakarta.annotation.Nonnull List<@Valid LocalizedDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SpecialRateLightweightAffiliate addDescriptionsItem(LocalizedDescriptionAffiliate descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

  /**
   * Localized descriptions describing promotion. At least one English entry is required.
   * @return descriptions
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid LocalizedDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(@jakarta.annotation.Nonnull List<@Valid LocalizedDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }

  public SpecialRateLightweightAffiliate cityRateQualifiers(@jakarta.annotation.Nullable List<Object> cityRateQualifiers) {
    
    this.cityRateQualifiers = cityRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addCityRateQualifiersItem(Object cityRateQualifiersItem) {
    if (this.cityRateQualifiers == null) {
      this.cityRateQualifiers = new ArrayList<>();
    }
    this.cityRateQualifiers.add(cityRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific cities. See [Geo-IP city geoname data](#operation/searchForCity)
   * @return cityRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCityRateQualifiers() {
    return cityRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CITY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityRateQualifiers(@jakarta.annotation.Nullable List<Object> cityRateQualifiers) {
    this.cityRateQualifiers = cityRateQualifiers;
  }

  public SpecialRateLightweightAffiliate continentRateQualifiers(@jakarta.annotation.Nullable List<Object> continentRateQualifiers) {
    
    this.continentRateQualifiers = continentRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addContinentRateQualifiersItem(Object continentRateQualifiersItem) {
    if (this.continentRateQualifiers == null) {
      this.continentRateQualifiers = new ArrayList<>();
    }
    this.continentRateQualifiers.add(continentRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific continents. See [Geo-IP continent geoname data](#operation/showContinents)
   * @return continentRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getContinentRateQualifiers() {
    return continentRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentRateQualifiers(@jakarta.annotation.Nullable List<Object> continentRateQualifiers) {
    this.continentRateQualifiers = continentRateQualifiers;
  }

  public SpecialRateLightweightAffiliate countryRateQualifiers(@jakarta.annotation.Nullable List<Object> countryRateQualifiers) {
    
    this.countryRateQualifiers = countryRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addCountryRateQualifiersItem(Object countryRateQualifiersItem) {
    if (this.countryRateQualifiers == null) {
      this.countryRateQualifiers = new ArrayList<>();
    }
    this.countryRateQualifiers.add(countryRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific countries. See [Geo-IP country geoname data](#operation/showCountries)
   * @return countryRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getCountryRateQualifiers() {
    return countryRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryRateQualifiers(@jakarta.annotation.Nullable List<Object> countryRateQualifiers) {
    this.countryRateQualifiers = countryRateQualifiers;
  }

  public SpecialRateLightweightAffiliate promotionRateQualifiers(@jakarta.annotation.Nullable List<Object> promotionRateQualifiers) {
    
    this.promotionRateQualifiers = promotionRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addPromotionRateQualifiersItem(Object promotionRateQualifiersItem) {
    if (this.promotionRateQualifiers == null) {
      this.promotionRateQualifiers = new ArrayList<>();
    }
    this.promotionRateQualifiers.add(promotionRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion by requiring users to enter a promo code.
   * @return promotionRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPromotionRateQualifiers() {
    return promotionRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTION_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionRateQualifiers(@jakarta.annotation.Nullable List<Object> promotionRateQualifiers) {
    this.promotionRateQualifiers = promotionRateQualifiers;
  }

  public SpecialRateLightweightAffiliate ipRangeRateQualifiers(@jakarta.annotation.Nullable List<Object> ipRangeRateQualifiers) {
    
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addIpRangeRateQualifiersItem(Object ipRangeRateQualifiersItem) {
    if (this.ipRangeRateQualifiers == null) {
      this.ipRangeRateQualifiers = new ArrayList<>();
    }
    this.ipRangeRateQualifiers.add(ipRangeRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific IP ranges.
   * @return ipRangeRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getIpRangeRateQualifiers() {
    return ipRangeRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_IP_RANGE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpRangeRateQualifiers(@jakarta.annotation.Nullable List<Object> ipRangeRateQualifiers) {
    this.ipRangeRateQualifiers = ipRangeRateQualifiers;
  }

  public SpecialRateLightweightAffiliate roomRangeRateQualifier(@jakarta.annotation.Nullable Object roomRangeRateQualifier) {
    this.roomRangeRateQualifier = JsonNullable.<Object>of(roomRangeRateQualifier);
    
    return this;
  }

  /**
   * Get roomRangeRateQualifier
   * @return roomRangeRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getRoomRangeRateQualifier() {
        return roomRangeRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getRoomRangeRateQualifier_JsonNullable() {
    return roomRangeRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_ROOM_RANGE_RATE_QUALIFIER)
  public void setRoomRangeRateQualifier_JsonNullable(JsonNullable<Object> roomRangeRateQualifier) {
    this.roomRangeRateQualifier = roomRangeRateQualifier;
  }

  public void setRoomRangeRateQualifier(@jakarta.annotation.Nullable Object roomRangeRateQualifier) {
    this.roomRangeRateQualifier = JsonNullable.<Object>of(roomRangeRateQualifier);
  }

  public SpecialRateLightweightAffiliate prepayRateQualifier(@jakarta.annotation.Nullable Object prepayRateQualifier) {
    this.prepayRateQualifier = JsonNullable.<Object>of(prepayRateQualifier);
    
    return this;
  }

  /**
   * Get prepayRateQualifier
   * @return prepayRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getPrepayRateQualifier() {
        return prepayRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getPrepayRateQualifier_JsonNullable() {
    return prepayRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_PREPAY_RATE_QUALIFIER)
  public void setPrepayRateQualifier_JsonNullable(JsonNullable<Object> prepayRateQualifier) {
    this.prepayRateQualifier = prepayRateQualifier;
  }

  public void setPrepayRateQualifier(@jakarta.annotation.Nullable Object prepayRateQualifier) {
    this.prepayRateQualifier = JsonNullable.<Object>of(prepayRateQualifier);
  }

  public SpecialRateLightweightAffiliate refundableRateQualifier(@jakarta.annotation.Nullable Object refundableRateQualifier) {
    this.refundableRateQualifier = JsonNullable.<Object>of(refundableRateQualifier);
    
    return this;
  }

  /**
   * Get refundableRateQualifier
   * @return refundableRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getRefundableRateQualifier() {
        return refundableRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getRefundableRateQualifier_JsonNullable() {
    return refundableRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_REFUNDABLE_RATE_QUALIFIER)
  public void setRefundableRateQualifier_JsonNullable(JsonNullable<Object> refundableRateQualifier) {
    this.refundableRateQualifier = refundableRateQualifier;
  }

  public void setRefundableRateQualifier(@jakarta.annotation.Nullable Object refundableRateQualifier) {
    this.refundableRateQualifier = JsonNullable.<Object>of(refundableRateQualifier);
  }

  public SpecialRateLightweightAffiliate timezoneRateQualifiers(@jakarta.annotation.Nullable List<Object> timezoneRateQualifiers) {
    
    this.timezoneRateQualifiers = timezoneRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addTimezoneRateQualifiersItem(Object timezoneRateQualifiersItem) {
    if (this.timezoneRateQualifiers == null) {
      this.timezoneRateQualifiers = new ArrayList<>();
    }
    this.timezoneRateQualifiers.add(timezoneRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific time zones. See [Geo-IP timezone geoname data](#operation/showTimezones)
   * @return timezoneRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getTimezoneRateQualifiers() {
    return timezoneRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezoneRateQualifiers(@jakarta.annotation.Nullable List<Object> timezoneRateQualifiers) {
    this.timezoneRateQualifiers = timezoneRateQualifiers;
  }

  public SpecialRateLightweightAffiliate lastMinuteRateQualifier(@jakarta.annotation.Nullable Object lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = JsonNullable.<Object>of(lastMinuteRateQualifier);
    
    return this;
  }

  /**
   * Get lastMinuteRateQualifier
   * @return lastMinuteRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getLastMinuteRateQualifier() {
        return lastMinuteRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getLastMinuteRateQualifier_JsonNullable() {
    return lastMinuteRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_LAST_MINUTE_RATE_QUALIFIER)
  public void setLastMinuteRateQualifier_JsonNullable(JsonNullable<Object> lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = lastMinuteRateQualifier;
  }

  public void setLastMinuteRateQualifier(@jakarta.annotation.Nullable Object lastMinuteRateQualifier) {
    this.lastMinuteRateQualifier = JsonNullable.<Object>of(lastMinuteRateQualifier);
  }

  public SpecialRateLightweightAffiliate lengthOfStayRateQualifier(@jakarta.annotation.Nullable Object lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = JsonNullable.<Object>of(lengthOfStayRateQualifier);
    
    return this;
  }

  /**
   * Get lengthOfStayRateQualifier
   * @return lengthOfStayRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getLengthOfStayRateQualifier() {
        return lengthOfStayRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getLengthOfStayRateQualifier_JsonNullable() {
    return lengthOfStayRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_LENGTH_OF_STAY_RATE_QUALIFIER)
  public void setLengthOfStayRateQualifier_JsonNullable(JsonNullable<Object> lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = lengthOfStayRateQualifier;
  }

  public void setLengthOfStayRateQualifier(@jakarta.annotation.Nullable Object lengthOfStayRateQualifier) {
    this.lengthOfStayRateQualifier = JsonNullable.<Object>of(lengthOfStayRateQualifier);
  }

  public SpecialRateLightweightAffiliate advanceBookingRateQualifier(@jakarta.annotation.Nullable Object advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = JsonNullable.<Object>of(advanceBookingRateQualifier);
    
    return this;
  }

  /**
   * Get advanceBookingRateQualifier
   * @return advanceBookingRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getAdvanceBookingRateQualifier() {
        return advanceBookingRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getAdvanceBookingRateQualifier_JsonNullable() {
    return advanceBookingRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_ADVANCE_BOOKING_RATE_QUALIFIER)
  public void setAdvanceBookingRateQualifier_JsonNullable(JsonNullable<Object> advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = advanceBookingRateQualifier;
  }

  public void setAdvanceBookingRateQualifier(@jakarta.annotation.Nullable Object advanceBookingRateQualifier) {
    this.advanceBookingRateQualifier = JsonNullable.<Object>of(advanceBookingRateQualifier);
  }

  public SpecialRateLightweightAffiliate stayDateRateQualifiers(@jakarta.annotation.Nullable List<Object> stayDateRateQualifiers) {
    
    this.stayDateRateQualifiers = stayDateRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addStayDateRateQualifiersItem(Object stayDateRateQualifiersItem) {
    if (this.stayDateRateQualifiers == null) {
      this.stayDateRateQualifiers = new ArrayList<>();
    }
    this.stayDateRateQualifiers.add(stayDateRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific stay dates the user wants to arrive.
   * @return stayDateRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getStayDateRateQualifiers() {
    return stayDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_STAY_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayDateRateQualifiers(@jakarta.annotation.Nullable List<Object> stayDateRateQualifiers) {
    this.stayDateRateQualifiers = stayDateRateQualifiers;
  }

  public SpecialRateLightweightAffiliate sellDateRateQualifiers(@jakarta.annotation.Nullable List<Object> sellDateRateQualifiers) {
    
    this.sellDateRateQualifiers = sellDateRateQualifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addSellDateRateQualifiersItem(Object sellDateRateQualifiersItem) {
    if (this.sellDateRateQualifiers == null) {
      this.sellDateRateQualifiers = new ArrayList<>();
    }
    this.sellDateRateQualifiers.add(sellDateRateQualifiersItem);
    return this;
  }

  /**
   * Restrict promotion to specific dates the booking is made.
   * @return sellDateRateQualifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getSellDateRateQualifiers() {
    return sellDateRateQualifiers;
  }


  @JsonProperty(JSON_PROPERTY_SELL_DATE_RATE_QUALIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellDateRateQualifiers(@jakarta.annotation.Nullable List<Object> sellDateRateQualifiers) {
    this.sellDateRateQualifiers = sellDateRateQualifiers;
  }

  public SpecialRateLightweightAffiliate availableDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = JsonNullable.<Object>of(availableDaysOfWeekRateQualifier);
    
    return this;
  }

  /**
   * Get availableDaysOfWeekRateQualifier
   * @return availableDaysOfWeekRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getAvailableDaysOfWeekRateQualifier() {
        return availableDaysOfWeekRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getAvailableDaysOfWeekRateQualifier_JsonNullable() {
    return availableDaysOfWeekRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK_RATE_QUALIFIER)
  public void setAvailableDaysOfWeekRateQualifier_JsonNullable(JsonNullable<Object> availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = availableDaysOfWeekRateQualifier;
  }

  public void setAvailableDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object availableDaysOfWeekRateQualifier) {
    this.availableDaysOfWeekRateQualifier = JsonNullable.<Object>of(availableDaysOfWeekRateQualifier);
  }

  public SpecialRateLightweightAffiliate arrivalDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = JsonNullable.<Object>of(arrivalDaysOfWeekRateQualifier);
    
    return this;
  }

  /**
   * Get arrivalDaysOfWeekRateQualifier
   * @return arrivalDaysOfWeekRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getArrivalDaysOfWeekRateQualifier() {
        return arrivalDaysOfWeekRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getArrivalDaysOfWeekRateQualifier_JsonNullable() {
    return arrivalDaysOfWeekRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK_RATE_QUALIFIER)
  public void setArrivalDaysOfWeekRateQualifier_JsonNullable(JsonNullable<Object> arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = arrivalDaysOfWeekRateQualifier;
  }

  public void setArrivalDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object arrivalDaysOfWeekRateQualifier) {
    this.arrivalDaysOfWeekRateQualifier = JsonNullable.<Object>of(arrivalDaysOfWeekRateQualifier);
  }

  public SpecialRateLightweightAffiliate departureDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = JsonNullable.<Object>of(departureDaysOfWeekRateQualifier);
    
    return this;
  }

  /**
   * Get departureDaysOfWeekRateQualifier
   * @return departureDaysOfWeekRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getDepartureDaysOfWeekRateQualifier() {
        return departureDaysOfWeekRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getDepartureDaysOfWeekRateQualifier_JsonNullable() {
    return departureDaysOfWeekRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK_RATE_QUALIFIER)
  public void setDepartureDaysOfWeekRateQualifier_JsonNullable(JsonNullable<Object> departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = departureDaysOfWeekRateQualifier;
  }

  public void setDepartureDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object departureDaysOfWeekRateQualifier) {
    this.departureDaysOfWeekRateQualifier = JsonNullable.<Object>of(departureDaysOfWeekRateQualifier);
  }

  public SpecialRateLightweightAffiliate requiredDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = JsonNullable.<Object>of(requiredDaysOfWeekRateQualifier);
    
    return this;
  }

  /**
   * Get requiredDaysOfWeekRateQualifier
   * @return requiredDaysOfWeekRateQualifier
   */
  @jakarta.annotation.Nullable

  @JsonIgnore

  public Object getRequiredDaysOfWeekRateQualifier() {
        return requiredDaysOfWeekRateQualifier.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<Object> getRequiredDaysOfWeekRateQualifier_JsonNullable() {
    return requiredDaysOfWeekRateQualifier;
  }
  
  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK_RATE_QUALIFIER)
  public void setRequiredDaysOfWeekRateQualifier_JsonNullable(JsonNullable<Object> requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = requiredDaysOfWeekRateQualifier;
  }

  public void setRequiredDaysOfWeekRateQualifier(@jakarta.annotation.Nullable Object requiredDaysOfWeekRateQualifier) {
    this.requiredDaysOfWeekRateQualifier = JsonNullable.<Object>of(requiredDaysOfWeekRateQualifier);
  }

  public SpecialRateLightweightAffiliate masterRateIdentifiers(@jakarta.annotation.Nullable List<String> masterRateIdentifiers) {
    
    this.masterRateIdentifiers = masterRateIdentifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addMasterRateIdentifiersItem(String masterRateIdentifiersItem) {
    if (this.masterRateIdentifiers == null) {
      this.masterRateIdentifiers = new ArrayList<>();
    }
    this.masterRateIdentifiers.add(masterRateIdentifiersItem);
    return this;
  }

  /**
   * Restrict on specific master rates.
   * @return masterRateIdentifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMasterRateIdentifiers() {
    return masterRateIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MASTER_RATE_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMasterRateIdentifiers(@jakarta.annotation.Nullable List<String> masterRateIdentifiers) {
    this.masterRateIdentifiers = masterRateIdentifiers;
  }

  public SpecialRateLightweightAffiliate addOnIdentifiers(@jakarta.annotation.Nullable List<String> addOnIdentifiers) {
    
    this.addOnIdentifiers = addOnIdentifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addAddOnIdentifiersItem(String addOnIdentifiersItem) {
    if (this.addOnIdentifiers == null) {
      this.addOnIdentifiers = new ArrayList<>();
    }
    this.addOnIdentifiers.add(addOnIdentifiersItem);
    return this;
  }

  /**
   * Restrict on specific add-ons.
   * @return addOnIdentifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAddOnIdentifiers() {
    return addOnIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnIdentifiers(@jakarta.annotation.Nullable List<String> addOnIdentifiers) {
    this.addOnIdentifiers = addOnIdentifiers;
  }

  public SpecialRateLightweightAffiliate ratePlanIdentifiers(@jakarta.annotation.Nullable List<String> ratePlanIdentifiers) {
    
    this.ratePlanIdentifiers = ratePlanIdentifiers;
    return this;
  }

  public SpecialRateLightweightAffiliate addRatePlanIdentifiersItem(String ratePlanIdentifiersItem) {
    if (this.ratePlanIdentifiers == null) {
      this.ratePlanIdentifiers = new ArrayList<>();
    }
    this.ratePlanIdentifiers.add(ratePlanIdentifiersItem);
    return this;
  }

  /**
   * Restrict on specific rate plans.
   * @return ratePlanIdentifiers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRatePlanIdentifiers() {
    return ratePlanIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifiers(@jakarta.annotation.Nullable List<String> ratePlanIdentifiers) {
    this.ratePlanIdentifiers = ratePlanIdentifiers;
  }

  public SpecialRateLightweightAffiliate blackoutDates(@jakarta.annotation.Nullable List<Object> blackoutDates) {
    
    this.blackoutDates = blackoutDates;
    return this;
  }

  public SpecialRateLightweightAffiliate addBlackoutDatesItem(Object blackoutDatesItem) {
    if (this.blackoutDates == null) {
      this.blackoutDates = new ArrayList<>();
    }
    this.blackoutDates.add(blackoutDatesItem);
    return this;
  }

  /**
   * Exclude this promotion from specific date ranges.
   * @return blackoutDates
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getBlackoutDates() {
    return blackoutDates;
  }


  @JsonProperty(JSON_PROPERTY_BLACKOUT_DATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBlackoutDates(@jakarta.annotation.Nullable List<Object> blackoutDates) {
    this.blackoutDates = blackoutDates;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpecialRateLightweightAffiliate specialRateLightweightAffiliate = (SpecialRateLightweightAffiliate) o;
    return Objects.equals(this.identifier, specialRateLightweightAffiliate.identifier) &&
        Objects.equals(this.hotelIdentifier, specialRateLightweightAffiliate.hotelIdentifier) &&
        Objects.equals(this.name, specialRateLightweightAffiliate.name) &&
        Objects.equals(this.type, specialRateLightweightAffiliate.type) &&
        Objects.equals(this.modifier, specialRateLightweightAffiliate.modifier) &&
        Objects.equals(this.enabled, specialRateLightweightAffiliate.enabled) &&
        Objects.equals(this.pricingType, specialRateLightweightAffiliate.pricingType) &&
        Objects.equals(this.descriptions, specialRateLightweightAffiliate.descriptions) &&
        Objects.equals(this.cityRateQualifiers, specialRateLightweightAffiliate.cityRateQualifiers) &&
        Objects.equals(this.continentRateQualifiers, specialRateLightweightAffiliate.continentRateQualifiers) &&
        Objects.equals(this.countryRateQualifiers, specialRateLightweightAffiliate.countryRateQualifiers) &&
        Objects.equals(this.promotionRateQualifiers, specialRateLightweightAffiliate.promotionRateQualifiers) &&
        Objects.equals(this.ipRangeRateQualifiers, specialRateLightweightAffiliate.ipRangeRateQualifiers) &&
        equalsNullable(this.roomRangeRateQualifier, specialRateLightweightAffiliate.roomRangeRateQualifier) &&
        equalsNullable(this.prepayRateQualifier, specialRateLightweightAffiliate.prepayRateQualifier) &&
        equalsNullable(this.refundableRateQualifier, specialRateLightweightAffiliate.refundableRateQualifier) &&
        Objects.equals(this.timezoneRateQualifiers, specialRateLightweightAffiliate.timezoneRateQualifiers) &&
        equalsNullable(this.lastMinuteRateQualifier, specialRateLightweightAffiliate.lastMinuteRateQualifier) &&
        equalsNullable(this.lengthOfStayRateQualifier, specialRateLightweightAffiliate.lengthOfStayRateQualifier) &&
        equalsNullable(this.advanceBookingRateQualifier, specialRateLightweightAffiliate.advanceBookingRateQualifier) &&
        Objects.equals(this.stayDateRateQualifiers, specialRateLightweightAffiliate.stayDateRateQualifiers) &&
        Objects.equals(this.sellDateRateQualifiers, specialRateLightweightAffiliate.sellDateRateQualifiers) &&
        equalsNullable(this.availableDaysOfWeekRateQualifier, specialRateLightweightAffiliate.availableDaysOfWeekRateQualifier) &&
        equalsNullable(this.arrivalDaysOfWeekRateQualifier, specialRateLightweightAffiliate.arrivalDaysOfWeekRateQualifier) &&
        equalsNullable(this.departureDaysOfWeekRateQualifier, specialRateLightweightAffiliate.departureDaysOfWeekRateQualifier) &&
        equalsNullable(this.requiredDaysOfWeekRateQualifier, specialRateLightweightAffiliate.requiredDaysOfWeekRateQualifier) &&
        Objects.equals(this.masterRateIdentifiers, specialRateLightweightAffiliate.masterRateIdentifiers) &&
        Objects.equals(this.addOnIdentifiers, specialRateLightweightAffiliate.addOnIdentifiers) &&
        Objects.equals(this.ratePlanIdentifiers, specialRateLightweightAffiliate.ratePlanIdentifiers) &&
        Objects.equals(this.blackoutDates, specialRateLightweightAffiliate.blackoutDates);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, type, modifier, enabled, pricingType, descriptions, cityRateQualifiers, continentRateQualifiers, countryRateQualifiers, promotionRateQualifiers, ipRangeRateQualifiers, hashCodeNullable(roomRangeRateQualifier), hashCodeNullable(prepayRateQualifier), hashCodeNullable(refundableRateQualifier), timezoneRateQualifiers, hashCodeNullable(lastMinuteRateQualifier), hashCodeNullable(lengthOfStayRateQualifier), hashCodeNullable(advanceBookingRateQualifier), stayDateRateQualifiers, sellDateRateQualifiers, hashCodeNullable(availableDaysOfWeekRateQualifier), hashCodeNullable(arrivalDaysOfWeekRateQualifier), hashCodeNullable(departureDaysOfWeekRateQualifier), hashCodeNullable(requiredDaysOfWeekRateQualifier), masterRateIdentifiers, addOnIdentifiers, ratePlanIdentifiers, blackoutDates);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpecialRateLightweightAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    modifier: ").append(toIndentedString(modifier)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    pricingType: ").append(toIndentedString(pricingType)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    cityRateQualifiers: ").append(toIndentedString(cityRateQualifiers)).append("\n");
    sb.append("    continentRateQualifiers: ").append(toIndentedString(continentRateQualifiers)).append("\n");
    sb.append("    countryRateQualifiers: ").append(toIndentedString(countryRateQualifiers)).append("\n");
    sb.append("    promotionRateQualifiers: ").append(toIndentedString(promotionRateQualifiers)).append("\n");
    sb.append("    ipRangeRateQualifiers: ").append(toIndentedString(ipRangeRateQualifiers)).append("\n");
    sb.append("    roomRangeRateQualifier: ").append(toIndentedString(roomRangeRateQualifier)).append("\n");
    sb.append("    prepayRateQualifier: ").append(toIndentedString(prepayRateQualifier)).append("\n");
    sb.append("    refundableRateQualifier: ").append(toIndentedString(refundableRateQualifier)).append("\n");
    sb.append("    timezoneRateQualifiers: ").append(toIndentedString(timezoneRateQualifiers)).append("\n");
    sb.append("    lastMinuteRateQualifier: ").append(toIndentedString(lastMinuteRateQualifier)).append("\n");
    sb.append("    lengthOfStayRateQualifier: ").append(toIndentedString(lengthOfStayRateQualifier)).append("\n");
    sb.append("    advanceBookingRateQualifier: ").append(toIndentedString(advanceBookingRateQualifier)).append("\n");
    sb.append("    stayDateRateQualifiers: ").append(toIndentedString(stayDateRateQualifiers)).append("\n");
    sb.append("    sellDateRateQualifiers: ").append(toIndentedString(sellDateRateQualifiers)).append("\n");
    sb.append("    availableDaysOfWeekRateQualifier: ").append(toIndentedString(availableDaysOfWeekRateQualifier)).append("\n");
    sb.append("    arrivalDaysOfWeekRateQualifier: ").append(toIndentedString(arrivalDaysOfWeekRateQualifier)).append("\n");
    sb.append("    departureDaysOfWeekRateQualifier: ").append(toIndentedString(departureDaysOfWeekRateQualifier)).append("\n");
    sb.append("    requiredDaysOfWeekRateQualifier: ").append(toIndentedString(requiredDaysOfWeekRateQualifier)).append("\n");
    sb.append("    masterRateIdentifiers: ").append(toIndentedString(masterRateIdentifiers)).append("\n");
    sb.append("    addOnIdentifiers: ").append(toIndentedString(addOnIdentifiers)).append("\n");
    sb.append("    ratePlanIdentifiers: ").append(toIndentedString(ratePlanIdentifiers)).append("\n");
    sb.append("    blackoutDates: ").append(toIndentedString(blackoutDates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

