/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.browse.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.browse.invoker.ApiClient;
import travel.wink.sdk.affiliate.browse.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.InventoryAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.InventorySupplierAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventoryAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.browse.model.PageInventorySupplierAggregateLightweightAffiliate;

public class BrowseApi {
    private ApiClient apiClient;

    public BrowseApi() {
        this(new ApiClient());
    }

    @Autowired
    public BrowseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCitiesForInventoryRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showCitiesForInventory(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCitiesForInventoryWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventoryWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCitiesForInventoryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCitiesForInventory1RequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showCitiesForInventory1(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCitiesForInventory1RequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCitiesForInventory1WithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCitiesForInventory1RequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventory1WithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCitiesForInventory1RequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showContinentsForInventoryRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/continent/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showContinentsForInventory(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showContinentsForInventoryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showContinentsForInventoryWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showContinentsForInventoryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContinentsForInventoryWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showContinentsForInventoryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showContinentsForInventorySupplierRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/continent/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showContinentsForInventorySupplier(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showContinentsForInventorySupplierRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showContinentsForInventorySupplierWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showContinentsForInventorySupplierRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showContinentsForInventorySupplierWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showContinentsForInventorySupplierRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCountriesForInventoryRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showCountriesForInventory(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCountriesForInventoryWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventoryWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCountriesForInventoryRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showCountriesForInventorySupplierRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showCountriesForInventorySupplier(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showCountriesForInventorySupplierWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventorySupplierWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCountriesForInventorySupplierRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryRequestCreation(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryAggregateLightweightAffiliate> showDynamicSellerInventory(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryAggregateLightweightAffiliate>> showDynamicSellerInventoryWithHttpInfo(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryWithResponseSpec(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryByIdRequestCreation(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAggregateLightweightAffiliate> showDynamicSellerInventoryById(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAggregateLightweightAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryByIdWithResponseSpec(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showDynamicSellerInventoryByIdRequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryById_0RequestCreation(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById_0", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryAggregateLightweightAffiliate> showDynamicSellerInventoryById_0(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryAggregateLightweightAffiliate>> showDynamicSellerInventoryById_0WithHttpInfo(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryAggregateLightweightAffiliate>(this){};
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryById_0WithResponseSpec(@Nonnull String dynamicListIdentifier, @Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showDynamicSellerInventoryById_0RequestCreation(dynamicListIdentifier, page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventorySupplierRequestCreation(@Nonnull String supplierIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/{supplierIdentifier}/sales-channel/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventorySupplierAggregateLightweightAffiliate> showInventorySupplier(@Nonnull String supplierIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventorySupplierAggregateLightweightAffiliate>> showInventorySupplierWithHttpInfo(@Nonnull String supplierIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventorySupplierWithResponseSpec(@Nonnull String supplierIdentifier, @Nonnull String salesChannelIdentifier, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventorySupplierRequestCreation(supplierIdentifier, salesChannelIdentifier, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showLatestInventoryRequestCreation(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryAggregateLightweightAffiliate> showLatestInventory(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryAggregateLightweightAffiliate>>> showLatestInventoryWithHttpInfo(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryAggregateLightweightAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventoryWithResponseSpec(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showLatestInventoryRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showLatestInventorySupplierListRequestCreation(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventorySupplierAggregateLightweightAffiliate> showLatestInventorySupplierList(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventorySupplierAggregateLightweightAffiliate>>> showLatestInventorySupplierListWithHttpInfo(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventorySupplierListWithResponseSpec(@Nullable Integer page, @Nullable Integer size, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showLatestInventorySupplierListRequestCreation(page, size, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryRequestCreation(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/browse/supplier/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAggregateLightweightAffiliate> showSuppliersForDynamicSellerInventory(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAggregateLightweightAffiliate>> showSuppliersForDynamicSellerInventoryWithHttpInfo(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAggregateLightweightAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryWithResponseSpec(@Nonnull DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(dynamicSellerListRequestAffiliate, winkVersion);
    }
}

