/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.browse.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.browse.invoker.ApiClient;
import travel.wink.sdk.affiliate.browse.model.AddStaticListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.AddStaticListSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CopyMoveStaticListItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticListAndAddItemRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.CreateStaticListAndAddSupplierRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.SortStaticListItemsRequestAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListItemAffiliate;
import travel.wink.sdk.affiliate.browse.model.StaticListWrapperAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpsertStaticListRequestAffiliate;

public class CuratedListApi {
    private ApiClient apiClient;

    public CuratedListApi() {
        this(new ApiClient());
    }

    @Autowired
    public CuratedListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addInventoryToCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        AddStaticListItemRequestAffiliate postBody = addStaticListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticListItemRequestAffiliate' when calling addInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListItemAffiliate> addInventoryToCuratedList(@Nonnull String listIdentifier, @Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListItemAffiliate>> addInventoryToCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addInventoryToCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull AddStaticListItemRequestAffiliate addStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.addInventoryToCuratedListRequestCreation(listIdentifier, addStaticListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec addSupplierToCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        AddStaticListSupplierRequestAffiliate postBody = addStaticListSupplierRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (addStaticListSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'addStaticListSupplierRequestAffiliate' when calling addSupplierToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListItemAffiliate> addSupplierToCuratedList(@Nonnull String listIdentifier, @Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListItemAffiliate>> addSupplierToCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addSupplierToCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull AddStaticListSupplierRequestAffiliate addStaticListSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.addSupplierToCuratedListRequestCreation(listIdentifier, addStaticListSupplierRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec copyInventoryToCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CopyMoveStaticListItemRequestAffiliate postBody = copyMoveStaticListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticListItemRequestAffiliate' when calling copyInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListItemAffiliate> copyInventoryToCuratedList(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListItemAffiliate>> copyInventoryToCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec copyInventoryToCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.copyInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createCuratedListRequestCreation(@Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateStaticListAndAddItemRequestAffiliate postBody = createStaticListAndAddItemRequestAffiliate;
        if (createStaticListAndAddItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticListAndAddItemRequestAffiliate' when calling createCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListWrapperAffiliate> createCuratedList(@Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListWrapperAffiliate>> createCuratedListWithHttpInfo(@Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCuratedListWithResponseSpec(@Nonnull CreateStaticListAndAddItemRequestAffiliate createStaticListAndAddItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createCuratedListRequestCreation(createStaticListAndAddItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createCuratedSupplierListRequestCreation(@Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateStaticListAndAddSupplierRequestAffiliate postBody = createStaticListAndAddSupplierRequestAffiliate;
        if (createStaticListAndAddSupplierRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticListAndAddSupplierRequestAffiliate' when calling createCuratedSupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListWrapperAffiliate> createCuratedSupplierList(@Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListWrapperAffiliate>> createCuratedSupplierListWithHttpInfo(@Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCuratedSupplierListWithResponseSpec(@Nonnull CreateStaticListAndAddSupplierRequestAffiliate createStaticListAndAddSupplierRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createCuratedSupplierListRequestCreation(createStaticListAndAddSupplierRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec moveInventoryToCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CopyMoveStaticListItemRequestAffiliate postBody = copyMoveStaticListItemRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (copyMoveStaticListItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'copyMoveStaticListItemRequestAffiliate' when calling moveInventoryToCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListItemAffiliate> moveInventoryToCuratedList(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListItemAffiliate>> moveInventoryToCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec moveInventoryToCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nonnull CopyMoveStaticListItemRequestAffiliate copyMoveStaticListItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.moveInventoryToCuratedListRequestCreation(listIdentifier, itemIdentifier, copyMoveStaticListItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCuratedListRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListAffiliate> removeCuratedList(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>(this){};
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListAffiliate>> removeCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListAffiliate>(this){};
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeCuratedListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeInventoryFromCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (itemIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'itemIdentifier' when calling removeInventoryFromCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("itemIdentifier", itemIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/item/{itemIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListItemAffiliate> removeInventoryFromCuratedList(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListItemAffiliate>> removeInventoryFromCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeInventoryFromCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull String itemIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeInventoryFromCuratedListRequestCreation(listIdentifier, itemIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showCuratedListsRequestCreation(@Nullable Boolean withItems, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "withItems", withItems));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticListWrapperAffiliate> showCuratedLists(@Nullable Boolean withItems, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticListWrapperAffiliate>>> showCuratedListsWithHttpInfo(@Nullable Boolean withItems, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCuratedListsWithResponseSpec(@Nullable Boolean withItems, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showCuratedListsRequestCreation(withItems, winkVersion, accept);
    }

    private WebClient.ResponseSpec sortCuratedListItemsRequestCreation(@Nonnull String listIdentifier, @Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        SortStaticListItemsRequestAffiliate postBody = sortStaticListItemsRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sortStaticListItemsRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortStaticListItemsRequestAffiliate' when calling sortCuratedListItems", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}/sort", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StaticListItemAffiliate> sortCuratedListItems(@Nonnull String listIdentifier, @Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StaticListItemAffiliate>>> sortCuratedListItemsWithHttpInfo(@Nonnull String listIdentifier, @Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListItemAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListItemAffiliate>(this){};
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec sortCuratedListItemsWithResponseSpec(@Nonnull String listIdentifier, @Nonnull SortStaticListItemsRequestAffiliate sortStaticListItemsRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.sortCuratedListItemsRequestCreation(listIdentifier, sortStaticListItemsRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCuratedListRequestCreation(@Nonnull String listIdentifier, @Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertStaticListRequestAffiliate postBody = upsertStaticListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertStaticListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertStaticListRequestAffiliate' when calling updateCuratedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/static-list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<StaticListWrapperAffiliate> updateCuratedList(@Nonnull String listIdentifier, @Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<StaticListWrapperAffiliate>> updateCuratedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<StaticListWrapperAffiliate> localVarReturnType = new ParameterizedTypeReference<StaticListWrapperAffiliate>(this){};
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCuratedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull UpsertStaticListRequestAffiliate upsertStaticListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCuratedListRequestCreation(listIdentifier, upsertStaticListRequestAffiliate, winkVersion);
    }
}

