/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.browse.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.browse.invoker.ApiClient;
import travel.wink.sdk.affiliate.browse.model.DynamicListAffiliate;
import travel.wink.sdk.affiliate.browse.model.UpsertDynamicListRequestAffiliate;

public class DynamicListApi {
    private ApiClient apiClient;

    public DynamicListApi() {
        this(new ApiClient());
    }

    @Autowired
    public DynamicListApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSavedSearchRequestCreation(@Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertDynamicListRequestAffiliate postBody = upsertDynamicListRequestAffiliate;
        if (upsertDynamicListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicListRequestAffiliate' when calling createSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/dynamic-list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DynamicListAffiliate> createSavedSearch(@Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DynamicListAffiliate>> createSavedSearchWithHttpInfo(@Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSavedSearchWithResponseSpec(@Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSavedSearchRequestCreation(upsertDynamicListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSavedSearchRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/dynamic-list/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DynamicListAffiliate> removeSavedSearch(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DynamicListAffiliate>> removeSavedSearchWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSavedSearchWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSavedSearchRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSavedSearchesRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/dynamic-list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DynamicListAffiliate> showSavedSearches(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.showSavedSearchesRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DynamicListAffiliate>>> showSavedSearchesWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.showSavedSearchesRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSavedSearchesWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSavedSearchesRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSavedSearchRequestCreation(@Nonnull String listIdentifier, @Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertDynamicListRequestAffiliate postBody = upsertDynamicListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertDynamicListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertDynamicListRequestAffiliate' when calling updateSavedSearch", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/dynamic-list/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DynamicListAffiliate> updateSavedSearch(@Nonnull String listIdentifier, @Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DynamicListAffiliate>> updateSavedSearchWithHttpInfo(@Nonnull String listIdentifier, @Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<DynamicListAffiliate> localVarReturnType = new ParameterizedTypeReference<DynamicListAffiliate>(this){};
        return this.updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSavedSearchWithResponseSpec(@Nonnull String listIdentifier, @Nonnull UpsertDynamicListRequestAffiliate upsertDynamicListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSavedSearchRequestCreation(listIdentifier, upsertDynamicListRequestAffiliate, winkVersion);
    }
}

