/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.EngineConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertEngineConfigurationRequestAffiliate;

public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCustomizationRequestCreation(UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertEngineConfigurationRequestAffiliate postBody = upsertEngineConfigurationRequestAffiliate;
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> createCustomization(UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.createCustomizationRequestCreation(upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> createCustomizationWithHttpInfo(UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.createCustomizationRequestCreation(upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCustomizationWithResponseSpec(UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCustomizationRequestCreation(upsertEngineConfigurationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCustomizationRequestCreation(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling removeCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration/{engineConfigurationIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> removeCustomization(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.removeCustomizationRequestCreation(engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> removeCustomizationWithHttpInfo(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.removeCustomizationRequestCreation(engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCustomizationWithResponseSpec(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeCustomizationRequestCreation(engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationConfigurationRequestCreation(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration/{engineConfigurationIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> showApplicationConfiguration(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(engineConfigurationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showApplicationConfigurationWithHttpInfo(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(engineConfigurationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationWithResponseSpec(String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showApplicationConfigurationRequestCreation(engineConfigurationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<EngineConfigurationViewAffiliate> showApplicationConfigurationsByOwner(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineConfigurationViewAffiliate>>> showApplicationConfigurationsByOwnerWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationsByOwnerWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showPrimaryApplicationConfigurationRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> showPrimaryApplicationConfiguration(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showPrimaryApplicationConfigurationWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPrimaryApplicationConfigurationWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCustomizationRequestCreation(String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertEngineConfigurationRequestAffiliate postBody = upsertEngineConfigurationRequestAffiliate;
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/configuration/{engineConfigurationIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> updateCustomization(String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.updateCustomizationRequestCreation(engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> updateCustomizationWithHttpInfo(String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.updateCustomizationRequestCreation(engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCustomizationWithResponseSpec(String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCustomizationRequestCreation(engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion);
    }
}

