/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.CreateStaticSellerListSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellerInventoryListViewAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellerInventoryListRequestAffiliate;

public class GridsApi {
    private ApiClient apiClient;

    public GridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public GridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryListRequestCreation(UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryListRequestAffiliate postBody = upsertSellerInventoryListRequestAffiliate;
        if (upsertSellerInventoryListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryListRequestAffiliate' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> createSellerInventoryList(UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.createSellerInventoryListRequestCreation(upsertSellerInventoryListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> createSellerInventoryListWithHttpInfo(UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.createSellerInventoryListRequestCreation(upsertSellerInventoryListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryListWithResponseSpec(UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryListRequestCreation(upsertSellerInventoryListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryListSyndicationEntryRequestCreation(CreateStaticSellerListSyndicationEntryRequestAffiliate createStaticSellerListSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateStaticSellerListSyndicationEntryRequestAffiliate postBody = createStaticSellerListSyndicationEntryRequestAffiliate;
        if (createStaticSellerListSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticSellerListSyndicationEntryRequestAffiliate' when calling createSellerInventoryListSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> createSellerInventoryListSyndicationEntry(CreateStaticSellerListSyndicationEntryRequestAffiliate createStaticSellerListSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticSellerListSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> createSellerInventoryListSyndicationEntryWithHttpInfo(CreateStaticSellerListSyndicationEntryRequestAffiliate createStaticSellerListSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticSellerListSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryListSyndicationEntryWithResponseSpec(CreateStaticSellerListSyndicationEntryRequestAffiliate createStaticSellerListSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticSellerListSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryListRequestCreation(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> removeSellerInventoryList(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> removeSellerInventoryListWithHttpInfo(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryListWithResponseSpec(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryListRequestCreation(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> showSellerInventoryList(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> showSellerInventoryListWithHttpInfo(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListWithResponseSpec(String listIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryListsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryListViewAffiliate> showSellerInventoryLists(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryListViewAffiliate>>> showSellerInventoryListsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerInventoryListRequestCreation(String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryListRequestAffiliate postBody = upsertSellerInventoryListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryListRequestAffiliate' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryListViewAffiliate> updateSellerInventoryList(String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryListViewAffiliate>> updateSellerInventoryListWithHttpInfo(String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListViewAffiliate>(this){};
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryListWithResponseSpec(String listIdentifier, UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellerInventoryListRequestAffiliate, winkVersion);
    }
}

