/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateSellerInventoryItemSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellerInventoryItemViewAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellerInventoryItemRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSupplierSellerInventoryItemRequestAffiliate;

public class ItemsApi {
    private ApiClient apiClient;

    public ItemsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ItemsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryItemRequestCreation(UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryItemRequestAffiliate postBody = upsertSellerInventoryItemRequestAffiliate;
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> createSellerInventoryItem(UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSellerInventoryItemWithHttpInfo(UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryItemWithResponseSpec(UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryItemRequestCreation(upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryItemSyndicationEntryRequestCreation(CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateSellerInventoryItemSyndicationEntryRequestAffiliate postBody = createSellerInventoryItemSyndicationEntryRequestAffiliate;
        if (createSellerInventoryItemSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellerInventoryItemSyndicationEntryRequestAffiliate' when calling createSellerInventoryItemSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSellerInventoryItemSyndicationEntry(CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSellerInventoryItemSyndicationEntryWithHttpInfo(CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryItemSyndicationEntryWithResponseSpec(CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierSellerInventoryItemRequestCreation(UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierSellerInventoryItemRequestAffiliate postBody = upsertSupplierSellerInventoryItemRequestAffiliate;
        if (upsertSupplierSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierSellerInventoryItemRequestAffiliate' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> createSupplierSellerInventoryItem(UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSupplierSellerInventoryItemWithHttpInfo(UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierSellerInventoryItemWithResponseSpec(UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryItemRequestCreation(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> removeSellerInventoryItem(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> removeSellerInventoryItemWithHttpInfo(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryItemWithResponseSpec(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMedia1RequestCreation(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaAffiliate> showInventoryMedia1(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMedia1WithHttpInfo(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMedia1WithResponseSpec(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryItemRequestCreation(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> showSellerInventoryItem(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> showSellerInventoryItemWithHttpInfo(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemWithResponseSpec(String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryItemsForCompanyRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryItemViewAffiliate> showSellerInventoryItemsForCompany(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryItemViewAffiliate>>> showSellerInventoryItemsForCompanyWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemsForCompanyWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerInventoryItemRequestCreation(String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryItemRequestAffiliate postBody = upsertSellerInventoryItemRequestAffiliate;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> updateSellerInventoryItem(String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> updateSellerInventoryItemWithHttpInfo(String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryItemWithResponseSpec(String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }
}

