/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.AdvancedMapConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.InventoryMapMarkerAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertAdvancedMapConfigurationRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSupplierAdvancedMapConfigurationRequestAffiliate;

public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAdvancedMapConfigurationRequestCreation(UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertAdvancedMapConfigurationRequestAffiliate postBody = upsertAdvancedMapConfigurationRequestAffiliate;
        if (upsertAdvancedMapConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAdvancedMapConfigurationRequestAffiliate' when calling createAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> createAdvancedMapConfiguration(UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.createAdvancedMapConfigurationRequestCreation(upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> createAdvancedMapConfigurationWithHttpInfo(UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.createAdvancedMapConfigurationRequestCreation(upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAdvancedMapConfigurationWithResponseSpec(UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createAdvancedMapConfigurationRequestCreation(upsertAdvancedMapConfigurationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createAdvancedMapConfigurationForSupplierRequestCreation(UpsertSupplierAdvancedMapConfigurationRequestAffiliate upsertSupplierAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierAdvancedMapConfigurationRequestAffiliate postBody = upsertSupplierAdvancedMapConfigurationRequestAffiliate;
        if (upsertSupplierAdvancedMapConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierAdvancedMapConfigurationRequestAffiliate' when calling createAdvancedMapConfigurationForSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> createAdvancedMapConfigurationForSupplier(UpsertSupplierAdvancedMapConfigurationRequestAffiliate upsertSupplierAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.createAdvancedMapConfigurationForSupplierRequestCreation(upsertSupplierAdvancedMapConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> createAdvancedMapConfigurationForSupplierWithHttpInfo(UpsertSupplierAdvancedMapConfigurationRequestAffiliate upsertSupplierAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.createAdvancedMapConfigurationForSupplierRequestCreation(upsertSupplierAdvancedMapConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAdvancedMapConfigurationForSupplierWithResponseSpec(UpsertSupplierAdvancedMapConfigurationRequestAffiliate upsertSupplierAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createAdvancedMapConfigurationForSupplierRequestCreation(upsertSupplierAdvancedMapConfigurationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createAdvancedMapSyndicationEntryRequestCreation(CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate postBody = createAdvancedMapConfigurationSyndicationEntryRequestAffiliate;
        if (createAdvancedMapConfigurationSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createAdvancedMapConfigurationSyndicationEntryRequestAffiliate' when calling createAdvancedMapSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createAdvancedMapSyndicationEntry(CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createAdvancedMapSyndicationEntryRequestCreation(createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createAdvancedMapSyndicationEntryWithHttpInfo(CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createAdvancedMapSyndicationEntryRequestCreation(createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAdvancedMapSyndicationEntryWithResponseSpec(CreateAdvancedMapConfigurationSyndicationEntryRequestAffiliate createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createAdvancedMapSyndicationEntryRequestCreation(createAdvancedMapConfigurationSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeAdvancedMapConfigurationRequestCreation(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> removeAdvancedMapConfiguration(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.removeAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> removeAdvancedMapConfigurationWithHttpInfo(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.removeAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeAdvancedMapConfigurationWithResponseSpec(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationRequestCreation(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfiguration(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.showAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> showAdvancedMapConfigurationWithHttpInfo(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.showAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationWithResponseSpec(String mapIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationRequestCreation(mapIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkerRequestCreation(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showAdvancedMapConfigurationMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarker(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarkerAffiliate>> showAdvancedMapConfigurationMapMarkerWithHttpInfo(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkerWithResponseSpec(String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkersRequestCreation(String listIdentifier, String listType, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showAdvancedMapConfigurationMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryMapMarkerAffiliate> showAdvancedMapConfigurationMapMarkers(String listIdentifier, String listType, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarkerAffiliate>>> showAdvancedMapConfigurationMapMarkersWithHttpInfo(String listIdentifier, String listType, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationMapMarkersWithResponseSpec(String listIdentifier, String listType, String displayCurrency, String winkVersion, String accept) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showAdvancedMapConfigurationsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<AdvancedMapConfigurationViewAffiliate> showAdvancedMapConfigurations(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.showAdvancedMapConfigurationsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<AdvancedMapConfigurationViewAffiliate>>> showAdvancedMapConfigurationsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.showAdvancedMapConfigurationsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showAdvancedMapConfigurationsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showAdvancedMapConfigurationsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateAdvancedMapConfigurationRequestCreation(String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertAdvancedMapConfigurationRequestAffiliate postBody = upsertAdvancedMapConfigurationRequestAffiliate;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertAdvancedMapConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAdvancedMapConfigurationRequestAffiliate' when calling updateAdvancedMapConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<AdvancedMapConfigurationViewAffiliate> updateAdvancedMapConfiguration(String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.updateAdvancedMapConfigurationRequestCreation(mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<AdvancedMapConfigurationViewAffiliate>> updateAdvancedMapConfigurationWithHttpInfo(String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<AdvancedMapConfigurationViewAffiliate>(this){};
        return this.updateAdvancedMapConfigurationRequestCreation(mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAdvancedMapConfigurationWithResponseSpec(String mapIdentifier, UpsertAdvancedMapConfigurationRequestAffiliate upsertAdvancedMapConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateAdvancedMapConfigurationRequestCreation(mapIdentifier, upsertAdvancedMapConfigurationRequestAffiliate, winkVersion);
    }
}

