/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.CreateSupplierUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SupplierUrlViewAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSupplierUrlRequestAffiliate;

public class SupplierLinksApi {
    private ApiClient apiClient;

    public SupplierLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSupplierUrlRequestCreation(UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierUrlRequestAffiliate postBody = upsertSupplierUrlRequestAffiliate;
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> createSupplierUrl(UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> createSupplierUrlWithHttpInfo(UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(upsertSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlWithResponseSpec(UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlRequestCreation(upsertSupplierUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierUrlSyndicationEntryRequestCreation(CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateSupplierUrlSyndicationEntryRequestAffiliate postBody = createSupplierUrlSyndicationEntryRequestAffiliate;
        if (createSupplierUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSupplierUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicationEntryAffiliate> createSupplierUrlSyndicationEntry(CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicationEntryAffiliate>> createSupplierUrlSyndicationEntryWithHttpInfo(CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlSyndicationEntryWithResponseSpec(CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSupplierUrlRequestCreation(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> removeSupplierUrl(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> removeSupplierUrlWithHttpInfo(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSupplierUrlWithResponseSpec(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierUrlRequestCreation(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> showSupplierUrl(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> showSupplierUrlWithHttpInfo(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlWithResponseSpec(String supplierUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierUrlsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SupplierUrlViewAffiliate> showSupplierUrls(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SupplierUrlViewAffiliate>>> showSupplierUrlsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSupplierUrlsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSupplierUrlRequestCreation(String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierUrlRequestAffiliate postBody = upsertSupplierUrlRequestAffiliate;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> updateSupplierUrl(String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> updateSupplierUrlWithHttpInfo(String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSupplierUrlWithResponseSpec(String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion);
    }
}

