/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.CustomizationAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertCustomizationRequestAffiliate;

public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCustomizationRequestCreation(@Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCustomizationRequestAffiliate postBody = upsertCustomizationRequestAffiliate;
        if (upsertCustomizationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCustomizationRequestAffiliate' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomizationAffiliate> createCustomization(@Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.createCustomizationRequestCreation(upsertCustomizationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomizationAffiliate>> createCustomizationWithHttpInfo(@Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.createCustomizationRequestCreation(upsertCustomizationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCustomizationWithResponseSpec(@Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createCustomizationRequestCreation(upsertCustomizationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCustomizationRequestCreation(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (customizationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customizationIdentifier' when calling removeCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("customizationIdentifier", customizationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization/{customizationIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomizationAffiliate> removeCustomization(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.removeCustomizationRequestCreation(customizationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomizationAffiliate>> removeCustomizationWithHttpInfo(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.removeCustomizationRequestCreation(customizationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCustomizationWithResponseSpec(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeCustomizationRequestCreation(customizationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationConfigurationRequestCreation(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (customizationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customizationIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("customizationIdentifier", customizationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization/{customizationIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomizationAffiliate> showApplicationConfiguration(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(customizationIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomizationAffiliate>> showApplicationConfigurationWithHttpInfo(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(customizationIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationWithResponseSpec(@Nonnull String customizationIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showApplicationConfigurationRequestCreation(customizationIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CustomizationAffiliate> showApplicationConfigurationsByOwner(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CustomizationAffiliate>>> showApplicationConfigurationsByOwnerWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationsByOwnerWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showApplicationConfigurationsByOwnerRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showPrimaryApplicationConfigurationRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomizationAffiliate> showPrimaryApplicationConfiguration(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomizationAffiliate>> showPrimaryApplicationConfigurationWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPrimaryApplicationConfigurationWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showPrimaryApplicationConfigurationRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateCustomizationRequestCreation(@Nonnull String customizationIdentifier, @Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertCustomizationRequestAffiliate postBody = upsertCustomizationRequestAffiliate;
        if (customizationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'customizationIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCustomizationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCustomizationRequestAffiliate' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("customizationIdentifier", customizationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/customization/{customizationIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CustomizationAffiliate> updateCustomization(@Nonnull String customizationIdentifier, @Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.updateCustomizationRequestCreation(customizationIdentifier, upsertCustomizationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CustomizationAffiliate>> updateCustomizationWithHttpInfo(@Nonnull String customizationIdentifier, @Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CustomizationAffiliate> localVarReturnType = new ParameterizedTypeReference<CustomizationAffiliate>(this){};
        return this.updateCustomizationRequestCreation(customizationIdentifier, upsertCustomizationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCustomizationWithResponseSpec(@Nonnull String customizationIdentifier, @Nonnull UpsertCustomizationRequestAffiliate upsertCustomizationRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateCustomizationRequestCreation(customizationIdentifier, upsertCustomizationRequestAffiliate, winkVersion);
    }
}

