/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.CreateStaticListSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellableListAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SyndicatedItemAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellableListRequestAffiliate;

public class GridsApi {
    private ApiClient apiClient;

    public GridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public GridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryListRequestCreation(@Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableListRequestAffiliate postBody = upsertSellableListRequestAffiliate;
        if (upsertSellableListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableListRequestAffiliate' when calling createSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableListAffiliate> createSellerInventoryList(@Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.createSellerInventoryListRequestCreation(upsertSellableListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableListAffiliate>> createSellerInventoryListWithHttpInfo(@Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.createSellerInventoryListRequestCreation(upsertSellableListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryListWithResponseSpec(@Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryListRequestCreation(upsertSellableListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryListSyndicationEntryRequestCreation(@Nonnull CreateStaticListSyndicationEntryRequestAffiliate createStaticListSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateStaticListSyndicationEntryRequestAffiliate postBody = createStaticListSyndicationEntryRequestAffiliate;
        if (createStaticListSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createStaticListSyndicationEntryRequestAffiliate' when calling createSellerInventoryListSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicatedItemAffiliate> createSellerInventoryListSyndicationEntry(@Nonnull CreateStaticListSyndicationEntryRequestAffiliate createStaticListSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticListSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicatedItemAffiliate>> createSellerInventoryListSyndicationEntryWithHttpInfo(@Nonnull CreateStaticListSyndicationEntryRequestAffiliate createStaticListSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticListSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryListSyndicationEntryWithResponseSpec(@Nonnull CreateStaticListSyndicationEntryRequestAffiliate createStaticListSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryListSyndicationEntryRequestCreation(createStaticListSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryListRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableListAffiliate> removeSellerInventoryList(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableListAffiliate>> removeSellerInventoryListWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryListWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryListRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableListAffiliate> showSellerInventoryList(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableListAffiliate>> showSellerInventoryListWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryListsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellableListAffiliate> showSellerInventoryLists(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellableListAffiliate>>> showSellerInventoryListsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryListsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryListsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerInventoryListRequestCreation(@Nonnull String listIdentifier, @Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableListRequestAffiliate postBody = upsertSellableListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellableListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableListRequestAffiliate' when calling updateSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/grids/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableListAffiliate> updateSellerInventoryList(@Nonnull String listIdentifier, @Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellableListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableListAffiliate>> updateSellerInventoryListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableListAffiliate>(this){};
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellableListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull UpsertSellableListRequestAffiliate upsertSellableListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryListRequestCreation(listIdentifier, upsertSellableListRequestAffiliate, winkVersion);
    }
}

