/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateSellerUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellableInventoryUrlAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellableInventoryUrlRequestAffiliate;

public class InventoryLinksApi {
    private ApiClient apiClient;

    public InventoryLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerUrlRequestCreation(@Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableInventoryUrlRequestAffiliate postBody = upsertSellableInventoryUrlRequestAffiliate;
        if (upsertSellableInventoryUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableInventoryUrlRequestAffiliate' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableInventoryUrlAffiliate> createSellerUrl(@Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.createSellerUrlRequestCreation(upsertSellableInventoryUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableInventoryUrlAffiliate>> createSellerUrlWithHttpInfo(@Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.createSellerUrlRequestCreation(upsertSellableInventoryUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerUrlWithResponseSpec(@Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerUrlRequestCreation(upsertSellableInventoryUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierUrlSyndicationEntry1RequestCreation(@Nonnull CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateSellerUrlSyndicationEntryRequestAffiliate postBody = createSellerUrlSyndicationEntryRequestAffiliate;
        if (createSellerUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellerUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSupplierUrlSyndicationEntry1(@Nonnull CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntry1RequestCreation(createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSupplierUrlSyndicationEntry1WithHttpInfo(@Nonnull CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntry1RequestCreation(createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlSyndicationEntry1WithResponseSpec(@Nonnull CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlSyndicationEntry1RequestCreation(createSellerUrlSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerUrlRequestCreation(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/{sellerUrlIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableInventoryUrlAffiliate> removeSellerUrl(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.removeSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableInventoryUrlAffiliate>> removeSellerUrlWithHttpInfo(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.removeSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerUrlWithResponseSpec(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMediaRequestCreation(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaAffiliate> showInventoryMedia(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMediaRequestCreation(channelInventoryIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMediaWithHttpInfo(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMediaRequestCreation(channelInventoryIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMediaWithResponseSpec(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMediaRequestCreation(channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerUrlRequestCreation(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/{sellerUrlIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableInventoryUrlAffiliate> showSellerUrl(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.showSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableInventoryUrlAffiliate>> showSellerUrlWithHttpInfo(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.showSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerUrlWithResponseSpec(@Nonnull String sellerUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerUrlRequestCreation(sellerUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerUrlsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellableInventoryUrlAffiliate> showSellerUrls(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.showSellerUrlsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellableInventoryUrlAffiliate>>> showSellerUrlsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.showSellerUrlsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerUrlsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerUrlsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerUrlRequestCreation(@Nonnull String sellerUrlIdentifier, @Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableInventoryUrlRequestAffiliate postBody = upsertSellableInventoryUrlRequestAffiliate;
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellableInventoryUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableInventoryUrlRequestAffiliate' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/inventory/{sellerUrlIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableInventoryUrlAffiliate> updateSellerUrl(@Nonnull String sellerUrlIdentifier, @Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.updateSellerUrlRequestCreation(sellerUrlIdentifier, upsertSellableInventoryUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableInventoryUrlAffiliate>> updateSellerUrlWithHttpInfo(@Nonnull String sellerUrlIdentifier, @Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableInventoryUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableInventoryUrlAffiliate>(this){};
        return this.updateSellerUrlRequestCreation(sellerUrlIdentifier, upsertSellableInventoryUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerUrlWithResponseSpec(@Nonnull String sellerUrlIdentifier, @Nonnull UpsertSellableInventoryUrlRequestAffiliate upsertSellableInventoryUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSellerUrlRequestCreation(sellerUrlIdentifier, upsertSellableInventoryUrlRequestAffiliate, winkVersion);
    }
}

