/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateSellableItemSyndicatedItemRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellableItemAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellableItemRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSupplierSellableItemRequestAffiliate;

public class ItemsApi {
    private ApiClient apiClient;

    public ItemsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ItemsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryItemRequestCreation(@Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableItemRequestAffiliate postBody = upsertSellableItemRequestAffiliate;
        if (upsertSellableItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableItemRequestAffiliate' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableItemAffiliate> createSellerInventoryItem(@Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(upsertSellableItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableItemAffiliate>> createSellerInventoryItemWithHttpInfo(@Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(upsertSellableItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryItemWithResponseSpec(@Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryItemRequestCreation(upsertSellableItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryItemSyndicationEntryRequestCreation(@Nonnull CreateSellableItemSyndicatedItemRequestAffiliate createSellableItemSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateSellableItemSyndicatedItemRequestAffiliate postBody = createSellableItemSyndicatedItemRequestAffiliate;
        if (createSellableItemSyndicatedItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellableItemSyndicatedItemRequestAffiliate' when calling createSellerInventoryItemSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSellerInventoryItemSyndicationEntry(@Nonnull CreateSellableItemSyndicatedItemRequestAffiliate createSellableItemSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellableItemSyndicatedItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSellerInventoryItemSyndicationEntryWithHttpInfo(@Nonnull CreateSellableItemSyndicatedItemRequestAffiliate createSellableItemSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellableItemSyndicatedItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryItemSyndicationEntryWithResponseSpec(@Nonnull CreateSellableItemSyndicatedItemRequestAffiliate createSellableItemSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryItemSyndicationEntryRequestCreation(createSellableItemSyndicatedItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierSellerInventoryItemRequestCreation(@Nonnull UpsertSupplierSellableItemRequestAffiliate upsertSupplierSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSupplierSellableItemRequestAffiliate postBody = upsertSupplierSellableItemRequestAffiliate;
        if (upsertSupplierSellableItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierSellableItemRequestAffiliate' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableItemAffiliate> createSupplierSellerInventoryItem(@Nonnull UpsertSupplierSellableItemRequestAffiliate upsertSupplierSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellableItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableItemAffiliate>> createSupplierSellerInventoryItemWithHttpInfo(@Nonnull UpsertSupplierSellableItemRequestAffiliate upsertSupplierSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellableItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierSellerInventoryItemWithResponseSpec(@Nonnull UpsertSupplierSellableItemRequestAffiliate upsertSupplierSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSupplierSellerInventoryItemRequestCreation(upsertSupplierSellableItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryItemRequestCreation(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableItemAffiliate> removeSellerInventoryItem(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableItemAffiliate>> removeSellerInventoryItemWithHttpInfo(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryItemWithResponseSpec(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMedia1RequestCreation(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaAffiliate> showInventoryMedia1(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMedia1WithHttpInfo(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMedia1WithResponseSpec(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMedia1RequestCreation(channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryItemRequestCreation(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableItemAffiliate> showSellerInventoryItem(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableItemAffiliate>> showSellerInventoryItemWithHttpInfo(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemWithResponseSpec(@Nonnull String inventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryItemRequestCreation(inventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryItemsForCompanyRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellableItemAffiliate> showSellerInventoryItemsForCompany(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellableItemAffiliate>>> showSellerInventoryItemsForCompanyWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemsForCompanyWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryItemsForCompanyRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerInventoryItemRequestCreation(@Nonnull String inventoryIdentifier, @Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableItemRequestAffiliate postBody = upsertSellableItemRequestAffiliate;
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellableItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableItemRequestAffiliate' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/items/{inventoryIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableItemAffiliate> updateSellerInventoryItem(@Nonnull String inventoryIdentifier, @Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellableItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableItemAffiliate>> updateSellerInventoryItemWithHttpInfo(@Nonnull String inventoryIdentifier, @Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableItemAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellableItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryItemWithResponseSpec(@Nonnull String inventoryIdentifier, @Nonnull UpsertSellableItemRequestAffiliate upsertSellableItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryItemRequestCreation(inventoryIdentifier, upsertSellableItemRequestAffiliate, winkVersion);
    }
}

