/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateInventoryMapSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.InventoryMapAffiliate;
import travel.wink.sdk.affiliate.inventory.model.InventoryMapMarkerAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertInventoryMapRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSupplierInventoryMapRequestAffiliate;

public class MapsApi {
    private ApiClient apiClient;

    public MapsApi() {
        this(new ApiClient());
    }

    @Autowired
    public MapsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAdvancedMapSyndicationEntryRequestCreation(@Nonnull CreateInventoryMapSyndicationEntryRequestAffiliate createInventoryMapSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateInventoryMapSyndicationEntryRequestAffiliate postBody = createInventoryMapSyndicationEntryRequestAffiliate;
        if (createInventoryMapSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createInventoryMapSyndicationEntryRequestAffiliate' when calling createAdvancedMapSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createAdvancedMapSyndicationEntry(@Nonnull CreateInventoryMapSyndicationEntryRequestAffiliate createInventoryMapSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createAdvancedMapSyndicationEntryRequestCreation(createInventoryMapSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createAdvancedMapSyndicationEntryWithHttpInfo(@Nonnull CreateInventoryMapSyndicationEntryRequestAffiliate createInventoryMapSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createAdvancedMapSyndicationEntryRequestCreation(createInventoryMapSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createAdvancedMapSyndicationEntryWithResponseSpec(@Nonnull CreateInventoryMapSyndicationEntryRequestAffiliate createInventoryMapSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createAdvancedMapSyndicationEntryRequestCreation(createInventoryMapSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createInventoryMapRequestCreation(@Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertInventoryMapRequestAffiliate postBody = upsertInventoryMapRequestAffiliate;
        if (upsertInventoryMapRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertInventoryMapRequestAffiliate' when calling createInventoryMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapAffiliate> createInventoryMap(@Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.createInventoryMapRequestCreation(upsertInventoryMapRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapAffiliate>> createInventoryMapWithHttpInfo(@Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.createInventoryMapRequestCreation(upsertInventoryMapRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createInventoryMapWithResponseSpec(@Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createInventoryMapRequestCreation(upsertInventoryMapRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createInventoryMapForSupplierRequestCreation(@Nonnull UpsertSupplierInventoryMapRequestAffiliate upsertSupplierInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSupplierInventoryMapRequestAffiliate postBody = upsertSupplierInventoryMapRequestAffiliate;
        if (upsertSupplierInventoryMapRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierInventoryMapRequestAffiliate' when calling createInventoryMapForSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapAffiliate> createInventoryMapForSupplier(@Nonnull UpsertSupplierInventoryMapRequestAffiliate upsertSupplierInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.createInventoryMapForSupplierRequestCreation(upsertSupplierInventoryMapRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapAffiliate>> createInventoryMapForSupplierWithHttpInfo(@Nonnull UpsertSupplierInventoryMapRequestAffiliate upsertSupplierInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.createInventoryMapForSupplierRequestCreation(upsertSupplierInventoryMapRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createInventoryMapForSupplierWithResponseSpec(@Nonnull UpsertSupplierInventoryMapRequestAffiliate upsertSupplierInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createInventoryMapForSupplierRequestCreation(upsertSupplierInventoryMapRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeInventoryMapRequestCreation(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling removeInventoryMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapAffiliate> removeInventoryMap(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.removeInventoryMapRequestCreation(mapIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapAffiliate>> removeInventoryMapWithHttpInfo(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.removeInventoryMapRequestCreation(mapIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeInventoryMapWithResponseSpec(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeInventoryMapRequestCreation(mapIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMapRequestCreation(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling showInventoryMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapAffiliate> showInventoryMap(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.showInventoryMapRequestCreation(mapIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapAffiliate>> showInventoryMapWithHttpInfo(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.showInventoryMapRequestCreation(mapIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMapWithResponseSpec(@Nonnull String mapIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMapRequestCreation(mapIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMapMapMarkerRequestCreation(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMapMapMarker", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/marker/{channelInventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapMarkerAffiliate> showInventoryMapMapMarker(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showInventoryMapMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapMarkerAffiliate>> showInventoryMapMapMarkerWithHttpInfo(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showInventoryMapMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMapMapMarkerWithResponseSpec(@Nonnull String channelInventoryIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMapMapMarkerRequestCreation(channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMapMapMarkersRequestCreation(@Nonnull String listIdentifier, @Nonnull String listType, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showInventoryMapMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (listType == null) {
            throw new WebClientResponseException("Missing the required parameter 'listType' when calling showInventoryMapMapMarkers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        pathParams.put("listType", listType);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "displayCurrency", displayCurrency));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/markers/{listType}/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryMapMarkerAffiliate> showInventoryMapMapMarkers(@Nonnull String listIdentifier, @Nonnull String listType, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showInventoryMapMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapMarkerAffiliate>>> showInventoryMapMapMarkersWithHttpInfo(@Nonnull String listIdentifier, @Nonnull String listType, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapMarkerAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapMarkerAffiliate>(this){};
        return this.showInventoryMapMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMapMapMarkersWithResponseSpec(@Nonnull String listIdentifier, @Nonnull String listType, @Nullable String displayCurrency, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMapMapMarkersRequestCreation(listIdentifier, listType, displayCurrency, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMapsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryMapAffiliate> showInventoryMaps(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.showInventoryMapsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryMapAffiliate>>> showInventoryMapsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.showInventoryMapsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMapsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showInventoryMapsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateInventoryMapRequestCreation(@Nonnull String mapIdentifier, @Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertInventoryMapRequestAffiliate postBody = upsertInventoryMapRequestAffiliate;
        if (mapIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'mapIdentifier' when calling updateInventoryMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertInventoryMapRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertInventoryMapRequestAffiliate' when calling updateInventoryMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("mapIdentifier", mapIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/map/{mapIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventoryMapAffiliate> updateInventoryMap(@Nonnull String mapIdentifier, @Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.updateInventoryMapRequestCreation(mapIdentifier, upsertInventoryMapRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventoryMapAffiliate>> updateInventoryMapWithHttpInfo(@Nonnull String mapIdentifier, @Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryMapAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryMapAffiliate>(this){};
        return this.updateInventoryMapRequestCreation(mapIdentifier, upsertInventoryMapRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateInventoryMapWithResponseSpec(@Nonnull String mapIdentifier, @Nonnull UpsertInventoryMapRequestAffiliate upsertInventoryMapRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateInventoryMapRequestCreation(mapIdentifier, upsertInventoryMapRequestAffiliate, winkVersion);
    }
}

