/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.inventory.model.CreateSellableRankedListSyndicatedItemRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellableRankedListAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellableRankedListRequestAffiliate;

public class RankedGridsApi {
    private ApiClient apiClient;

    public RankedGridsApi() {
        this(new ApiClient());
    }

    @Autowired
    public RankedGridsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryRankedListRequestCreation(@Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableRankedListRequestAffiliate postBody = upsertSellableRankedListRequestAffiliate;
        if (upsertSellableRankedListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableRankedListRequestAffiliate' when calling createSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableRankedListAffiliate> createSellerInventoryRankedList(@Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.createSellerInventoryRankedListRequestCreation(upsertSellableRankedListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableRankedListAffiliate>> createSellerInventoryRankedListWithHttpInfo(@Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.createSellerInventoryRankedListRequestCreation(upsertSellableRankedListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryRankedListWithResponseSpec(@Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryRankedListRequestCreation(upsertSellableRankedListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSellerInventoryRankedListSyndicationEntryRequestCreation(@Nonnull CreateSellableRankedListSyndicatedItemRequestAffiliate createSellableRankedListSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateSellableRankedListSyndicatedItemRequestAffiliate postBody = createSellableRankedListSyndicatedItemRequestAffiliate;
        if (createSellableRankedListSyndicatedItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellableRankedListSyndicatedItemRequestAffiliate' when calling createSellerInventoryRankedListSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSellerInventoryRankedListSyndicationEntry(@Nonnull CreateSellableRankedListSyndicatedItemRequestAffiliate createSellableRankedListSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryRankedListSyndicationEntryRequestCreation(createSellableRankedListSyndicatedItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSellerInventoryRankedListSyndicationEntryWithHttpInfo(@Nonnull CreateSellableRankedListSyndicatedItemRequestAffiliate createSellableRankedListSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSellerInventoryRankedListSyndicationEntryRequestCreation(createSellableRankedListSyndicatedItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryRankedListSyndicationEntryWithResponseSpec(@Nonnull CreateSellableRankedListSyndicatedItemRequestAffiliate createSellableRankedListSyndicatedItemRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryRankedListSyndicationEntryRequestCreation(createSellableRankedListSyndicatedItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryRankedListRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling removeSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids/{listIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableRankedListAffiliate> removeSellerInventoryRankedList(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.removeSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableRankedListAffiliate>> removeSellerInventoryRankedListWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.removeSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryRankedListWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListRequestCreation(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids/{listIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableRankedListAffiliate> showSellerInventoryRankedList(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.showSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableRankedListAffiliate>> showSellerInventoryRankedListWithHttpInfo(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.showSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryRankedListWithResponseSpec(@Nonnull String listIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryRankedListRequestCreation(listIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerInventoryRankedListsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellableRankedListAffiliate> showSellerInventoryRankedLists(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.showSellerInventoryRankedListsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellableRankedListAffiliate>>> showSellerInventoryRankedListsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.showSellerInventoryRankedListsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryRankedListsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSellerInventoryRankedListsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerInventoryRankedListRequestCreation(@Nonnull String listIdentifier, @Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableRankedListRequestAffiliate postBody = upsertSellableRankedListRequestAffiliate;
        if (listIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'listIdentifier' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellableRankedListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableRankedListRequestAffiliate' when calling updateSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("listIdentifier", listIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/ranked-grids/{listIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableRankedListAffiliate> updateSellerInventoryRankedList(@Nonnull String listIdentifier, @Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.updateSellerInventoryRankedListRequestCreation(listIdentifier, upsertSellableRankedListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableRankedListAffiliate>> updateSellerInventoryRankedListWithHttpInfo(@Nonnull String listIdentifier, @Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableRankedListAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableRankedListAffiliate>(this){};
        return this.updateSellerInventoryRankedListRequestCreation(listIdentifier, upsertSellableRankedListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryRankedListWithResponseSpec(@Nonnull String listIdentifier, @Nonnull UpsertSellableRankedListRequestAffiliate upsertSellableRankedListRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryRankedListRequestCreation(listIdentifier, upsertSellableRankedListRequestAffiliate, winkVersion);
    }
}

