/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.inventory.invoker.ApiClient;
import travel.wink.sdk.affiliate.inventory.model.CreateSupplierUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SellableSupplierUrlAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SyndicatedItemAffiliate;
import travel.wink.sdk.affiliate.inventory.model.UpsertSellableSupplierUrlRequestAffiliate;

public class SupplierLinksApi {
    private ApiClient apiClient;

    public SupplierLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSupplierUrlRequestCreation(@Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableSupplierUrlRequestAffiliate postBody = upsertSellableSupplierUrlRequestAffiliate;
        if (upsertSellableSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableSupplierUrlRequestAffiliate' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableSupplierUrlAffiliate> createSupplierUrl(@Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(upsertSellableSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableSupplierUrlAffiliate>> createSupplierUrlWithHttpInfo(@Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(upsertSellableSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlWithResponseSpec(@Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlRequestCreation(upsertSellableSupplierUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierUrlSyndicationEntryRequestCreation(@Nonnull CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        CreateSupplierUrlSyndicationEntryRequestAffiliate postBody = createSupplierUrlSyndicationEntryRequestAffiliate;
        if (createSupplierUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSupplierUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SyndicatedItemAffiliate> createSupplierUrlSyndicationEntry(@Nonnull CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SyndicatedItemAffiliate>> createSupplierUrlSyndicationEntryWithHttpInfo(@Nonnull CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicatedItemAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicatedItemAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlSyndicationEntryWithResponseSpec(@Nonnull CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlSyndicationEntryRequestCreation(createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSupplierUrlRequestCreation(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableSupplierUrlAffiliate> removeSupplierUrl(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableSupplierUrlAffiliate>> removeSupplierUrlWithHttpInfo(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSupplierUrlWithResponseSpec(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierUrlRequestCreation(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableSupplierUrlAffiliate> showSupplierUrl(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableSupplierUrlAffiliate>> showSupplierUrlWithHttpInfo(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlWithResponseSpec(@Nonnull String supplierUrlIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSupplierUrlRequestCreation(supplierUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierUrlsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellableSupplierUrlAffiliate> showSupplierUrls(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellableSupplierUrlAffiliate>>> showSupplierUrlsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSupplierUrlsRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSupplierUrlRequestCreation(@Nonnull String supplierUrlIdentifier, @Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSellableSupplierUrlRequestAffiliate postBody = upsertSellableSupplierUrlRequestAffiliate;
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellableSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellableSupplierUrlRequestAffiliate' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/supplier/{supplierUrlIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellableSupplierUrlAffiliate> updateSupplierUrl(@Nonnull String supplierUrlIdentifier, @Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSellableSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellableSupplierUrlAffiliate>> updateSupplierUrlWithHttpInfo(@Nonnull String supplierUrlIdentifier, @Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellableSupplierUrlAffiliate> localVarReturnType = new ParameterizedTypeReference<SellableSupplierUrlAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSellableSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSupplierUrlWithResponseSpec(@Nonnull String supplierUrlIdentifier, @Nonnull UpsertSellableSupplierUrlRequestAffiliate upsertSellableSupplierUrlRequestAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.updateSupplierUrlRequestCreation(supplierUrlIdentifier, upsertSellableSupplierUrlRequestAffiliate, winkVersion);
    }
}

