/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.affiliate.inventory.model.ImageAttributionAffiliate;
import travel.wink.sdk.affiliate.inventory.model.SimpleDescriptionAffiliate;

@JsonPropertyOrder(value={"multimediaIdentifier", "identifier", "type", "source", "sort", "angle", "width", "height", "published", "category", "descriptions", "lifestyleType", "attribution", "isLandscape"})
@JsonTypeName(value="SimpleMultimedia_Affiliate")
public class SimpleMultimediaAffiliate {
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    @Nonnull
    private UUID multimediaIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nonnull
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nonnull
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nonnull
    private Integer sort = 999;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    @Nullable
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    @Nonnull
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    @Nonnull
    private Integer height;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    @Nullable
    private Boolean published = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    @Nullable
    private String category;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nullable
    private List<@Valid SimpleDescriptionAffiliate> descriptions = new ArrayList<SimpleDescriptionAffiliate>();
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    @Nullable
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_ATTRIBUTION = "attribution";
    @Nullable
    private List<@Valid ImageAttributionAffiliate> attribution = new ArrayList<ImageAttributionAffiliate>();
    public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
    @Nullable
    private Boolean isLandscape;

    public SimpleMultimediaAffiliate multimediaIdentifier(@Nonnull UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifier(@Nonnull UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public SimpleMultimediaAffiliate identifier(@Nonnull String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull String identifier) {
        this.identifier = identifier;
    }

    public SimpleMultimediaAffiliate type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    public SimpleMultimediaAffiliate source(@Nonnull SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSource(@Nonnull SourceEnum source) {
        this.source = source;
    }

    public SimpleMultimediaAffiliate sort(@Nonnull Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(@Nonnull Integer sort) {
        this.sort = sort;
    }

    public SimpleMultimediaAffiliate angle(@Nullable String angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAngle(@Nullable String angle) {
        this.angle = angle;
    }

    public SimpleMultimediaAffiliate width(@Nonnull Integer width) {
        this.width = width;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWidth(@Nonnull Integer width) {
        this.width = width;
    }

    public SimpleMultimediaAffiliate height(@Nonnull Integer height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHeight(@Nonnull Integer height) {
        this.height = height;
    }

    public SimpleMultimediaAffiliate published(@Nullable Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublished(@Nullable Boolean published) {
        this.published = published;
    }

    public SimpleMultimediaAffiliate category(@Nullable String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    public SimpleMultimediaAffiliate descriptions(@Nullable List<@Valid SimpleDescriptionAffiliate> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SimpleMultimediaAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionAffiliate>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SimpleDescriptionAffiliate> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescriptions(@Nullable List<@Valid SimpleDescriptionAffiliate> descriptions) {
        this.descriptions = descriptions;
    }

    public SimpleMultimediaAffiliate lifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public SimpleMultimediaAffiliate attribution(@Nullable List<@Valid ImageAttributionAffiliate> attribution) {
        this.attribution = attribution;
        return this;
    }

    public SimpleMultimediaAffiliate addAttributionItem(ImageAttributionAffiliate attributionItem) {
        if (this.attribution == null) {
            this.attribution = new ArrayList<ImageAttributionAffiliate>();
        }
        this.attribution.add(attributionItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="attribution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid ImageAttributionAffiliate> getAttribution() {
        return this.attribution;
    }

    @JsonProperty(value="attribution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttribution(@Nullable List<@Valid ImageAttributionAffiliate> attribution) {
        this.attribution = attribution;
    }

    public SimpleMultimediaAffiliate isLandscape(@Nullable Boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    @Nullable
    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLandscape() {
        return this.isLandscape;
    }

    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLandscape(@Nullable Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMultimediaAffiliate simpleMultimediaAffiliate = (SimpleMultimediaAffiliate)o;
        return Objects.equals(this.multimediaIdentifier, simpleMultimediaAffiliate.multimediaIdentifier) && Objects.equals(this.identifier, simpleMultimediaAffiliate.identifier) && Objects.equals((Object)this.type, (Object)simpleMultimediaAffiliate.type) && Objects.equals((Object)this.source, (Object)simpleMultimediaAffiliate.source) && Objects.equals(this.sort, simpleMultimediaAffiliate.sort) && Objects.equals(this.angle, simpleMultimediaAffiliate.angle) && Objects.equals(this.width, simpleMultimediaAffiliate.width) && Objects.equals(this.height, simpleMultimediaAffiliate.height) && Objects.equals(this.published, simpleMultimediaAffiliate.published) && Objects.equals(this.category, simpleMultimediaAffiliate.category) && Objects.equals(this.descriptions, simpleMultimediaAffiliate.descriptions) && Objects.equals((Object)this.lifestyleType, (Object)simpleMultimediaAffiliate.lifestyleType) && Objects.equals(this.attribution, simpleMultimediaAffiliate.attribution) && Objects.equals(this.isLandscape, simpleMultimediaAffiliate.isLandscape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multimediaIdentifier, this.identifier, this.type, this.source, this.sort, this.angle, this.width, this.height, this.published, this.category, this.descriptions, this.lifestyleType, this.attribution, this.isLandscape});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleMultimediaAffiliate {\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    isLandscape: ").append(this.toIndentedString(this.isLandscape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE(String.valueOf("YOUTUBE")),
        CLOUDINARY(String.valueOf("CLOUDINARY"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE(String.valueOf("IMAGE")),
        VIDEO(String.valueOf("VIDEO")),
        AUDIO(String.valueOf("AUDIO")),
        RAW(String.valueOf("RAW"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

