/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.sales.channel.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.sales.channel.invoker.ApiClient;
import travel.wink.sdk.affiliate.sales.channel.model.PageSalesChannelViewAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.SalesChannelViewAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.StateAffiliate;

public class SalesChannelApi {
    private ApiClient apiClient;

    public SalesChannelApi() {
        this(new ApiClient());
    }

    @Autowired
    public SalesChannelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseSalesChannelsRequestCreation(StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        StateAffiliate postBody = stateAffiliate;
        if (stateAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAffiliate' when calling browseSalesChannels", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageSalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageSalesChannelViewAffiliate> browseSalesChannels(StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageSalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelViewAffiliate>(this){};
        return this.browseSalesChannelsRequestCreation(stateAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageSalesChannelViewAffiliate>> browseSalesChannelsWithHttpInfo(StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageSalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageSalesChannelViewAffiliate>(this){};
        return this.browseSalesChannelsRequestCreation(stateAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec browseSalesChannelsWithResponseSpec(StateAffiliate stateAffiliate, String winkVersion) throws WebClientResponseException {
        return this.browseSalesChannelsRequestCreation(stateAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showSalesChannelRequestCreation(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSalesChannel", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelViewAffiliate> showSalesChannel(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelViewAffiliate>(this){};
        return this.showSalesChannelRequestCreation(supplierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelViewAffiliate>> showSalesChannelWithHttpInfo(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelViewAffiliate>(this){};
        return this.showSalesChannelRequestCreation(supplierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSalesChannelWithResponseSpec(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSalesChannelRequestCreation(supplierIdentifier, winkVersion, accept);
    }
}

