/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.sales.channel.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.sales.channel.invoker.ApiClient;
import travel.wink.sdk.affiliate.sales.channel.model.RemoveEntryResponse;
import travel.wink.sdk.affiliate.sales.channel.model.SalesChannelRelationshipRequestView;
import travel.wink.sdk.affiliate.sales.channel.model.SalesChannelRelationshipRequestViewAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.UpsertSalesChannelRelationshipRequestRequest;

public class RelationshipRequestApi {
    private ApiClient apiClient;

    public RelationshipRequestApi() {
        this(new ApiClient());
    }

    @Autowired
    public RelationshipRequestApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSupplierRequestRequestCreation(UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        UpsertSalesChannelRelationshipRequestRequest postBody = upsertSalesChannelRelationshipRequestRequest;
        if (upsertSalesChannelRelationshipRequestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRelationshipRequestRequest' when calling createSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestView> createSupplierRequest(UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRelationshipRequestRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> createSupplierRequestWithHttpInfo(UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRelationshipRequestRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierRequestWithResponseSpec(UpsertSalesChannelRelationshipRequestRequest upsertSalesChannelRelationshipRequestRequest, String winkVersion) throws WebClientResponseException {
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRelationshipRequestRequest, winkVersion);
    }

    private WebClient.ResponseSpec reApplySupplierRequestRequestCreation(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling reApplySupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/{salesChannelRequestIdentifier}/re-apply", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestView> reApplySupplierRequest(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> reApplySupplierRequestWithHttpInfo(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec reApplySupplierRequestWithResponseSpec(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeSupplierRequestRequestCreation(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponse> removeSupplierRequest(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponse>> removeSupplierRequestWithHttpInfo(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponse> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponse>(this){};
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSupplierRequestWithResponseSpec(String salesChannelRequestIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierRequestRequestCreation(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRelationshipRequestView> showSupplierRequest(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRelationshipRequestView>> showSupplierRequestWithHttpInfo(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestView> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestView>(this){};
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierRequestWithResponseSpec(String supplierIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierRequestsRequestCreation(String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelRelationshipRequestViewAffiliate> showSupplierRequests(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>(this){};
        return this.showSupplierRequestsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelRelationshipRequestViewAffiliate>>> showSupplierRequestsWithHttpInfo(String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRelationshipRequestViewAffiliate>(this){};
        return this.showSupplierRequestsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierRequestsWithResponseSpec(String winkVersion, String accept) throws WebClientResponseException {
        return this.showSupplierRequestsRequestCreation(winkVersion, accept);
    }
}

