/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.sales.channel.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.sales.channel.invoker.ApiClient;
import travel.wink.sdk.affiliate.sales.channel.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.PagePropertyAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.PropertyAggregateLightweightAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.StateAffiliate;

public class AvailableSupplierApi {
    private ApiClient apiClient;

    public AvailableSupplierApi() {
        this(new ApiClient());
    }

    @Autowired
    public AvailableSupplierApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec browseSuppliersRequestCreation(@Nonnull StateAffiliate stateAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        StateAffiliate postBody = stateAffiliate;
        if (stateAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAffiliate' when calling browseSuppliers", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/supplier/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PagePropertyAggregateLightweightAffiliate> browseSuppliers(@Nonnull StateAffiliate stateAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate>(this){};
        return this.browseSuppliersRequestCreation(stateAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PagePropertyAggregateLightweightAffiliate>> browseSuppliersWithHttpInfo(@Nonnull StateAffiliate stateAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PagePropertyAggregateLightweightAffiliate>(this){};
        return this.browseSuppliersRequestCreation(stateAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec browseSuppliersWithResponseSpec(@Nonnull StateAffiliate stateAffiliate, @Nullable String winkVersion) throws WebClientResponseException {
        return this.browseSuppliersRequestCreation(stateAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showLatestSupplierRequestCreation(@Nullable Integer page, @Nullable Integer size, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<PropertyAggregateLightweightAffiliate> showLatestSupplier(@Nullable Integer page, @Nullable Integer size, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.showLatestSupplierRequestCreation(page, size, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<PropertyAggregateLightweightAffiliate>>> showLatestSupplierWithHttpInfo(@Nullable Integer page, @Nullable Integer size, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.showLatestSupplierRequestCreation(page, size, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestSupplierWithResponseSpec(@Nullable Integer page, @Nullable Integer size, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showLatestSupplierRequestCreation(page, size, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierRequestCreation(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PropertyAggregateLightweightAffiliate> showSupplier(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.showSupplierRequestCreation(supplierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PropertyAggregateLightweightAffiliate>> showSupplierWithHttpInfo(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<PropertyAggregateLightweightAffiliate> localVarReturnType = new ParameterizedTypeReference<PropertyAggregateLightweightAffiliate>(this){};
        return this.showSupplierRequestCreation(supplierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierWithResponseSpec(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSupplierRequestCreation(supplierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showUniqueCityListRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/supplier/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showUniqueCityList(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showUniqueCityListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCityListWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showUniqueCityListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCityListWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showUniqueCityListRequestCreation(winkVersion, accept);
    }

    private WebClient.ResponseSpec showUniqueCountryListRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/supplier/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<KeyValuePairAffiliate> showUniqueCountryList(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showUniqueCountryListRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<KeyValuePairAffiliate>>> showUniqueCountryListWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<KeyValuePairAffiliate> localVarReturnType = new ParameterizedTypeReference<KeyValuePairAffiliate>(this){};
        return this.showUniqueCountryListRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUniqueCountryListWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showUniqueCountryListRequestCreation(winkVersion, accept);
    }
}

