/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.sales.channel.api;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.sales.channel.invoker.ApiClient;
import travel.wink.sdk.affiliate.sales.channel.model.SalesChannelRequest;
import travel.wink.sdk.affiliate.sales.channel.model.SalesChannelRequestAffiliate;
import travel.wink.sdk.affiliate.sales.channel.model.UpsertSalesChannelRequestRequest;

public class RelationshipRequestApi {
    private ApiClient apiClient;

    public RelationshipRequestApi() {
        this(new ApiClient());
    }

    @Autowired
    public RelationshipRequestApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSupplierRequestRequestCreation(@Nonnull UpsertSalesChannelRequestRequest upsertSalesChannelRequestRequest, @Nullable String winkVersion) throws WebClientResponseException {
        UpsertSalesChannelRequestRequest postBody = upsertSalesChannelRequestRequest;
        if (upsertSalesChannelRequestRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSalesChannelRequestRequest' when calling createSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequest> createSupplierRequest(@Nonnull UpsertSalesChannelRequestRequest upsertSalesChannelRequestRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRequestRequest, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequest>> createSupplierRequestWithHttpInfo(@Nonnull UpsertSalesChannelRequestRequest upsertSalesChannelRequestRequest, @Nullable String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRequestRequest, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierRequestWithResponseSpec(@Nonnull UpsertSalesChannelRequestRequest upsertSalesChannelRequestRequest, @Nullable String winkVersion) throws WebClientResponseException {
        return this.createSupplierRequestRequestCreation(upsertSalesChannelRequestRequest, winkVersion);
    }

    private WebClient.ResponseSpec reApplySupplierRequestRequestCreation(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling reApplySupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/{salesChannelRequestIdentifier}/re-apply", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequest> reApplySupplierRequest(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequest>> reApplySupplierRequestWithHttpInfo(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec reApplySupplierRequestWithResponseSpec(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.reApplySupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec removeSupplierRequestRequestCreation(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (salesChannelRequestIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelRequestIdentifier' when calling removeSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("salesChannelRequestIdentifier", salesChannelRequestIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/{salesChannelRequestIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequest> removeSupplierRequest(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequest>> removeSupplierRequestWithHttpInfo(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSupplierRequestWithResponseSpec(@Nonnull String salesChannelRequestIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.removeSupplierRequestRequestCreation(salesChannelRequestIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierRequestRequestCreation(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showSupplierRequest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("supplierIdentifier", supplierIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/supplier/{supplierIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SalesChannelRequest> showSupplierRequest(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SalesChannelRequest>> showSupplierRequestWithHttpInfo(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequest> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequest>(this){};
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierRequestWithResponseSpec(@Nonnull String supplierIdentifier, @Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSupplierRequestRequestCreation(supplierIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSupplierRequestsRequestCreation(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SalesChannelRequestAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/sales-channel/request/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SalesChannelRequestAffiliate> showSupplierRequests(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestAffiliate>(this){};
        return this.showSupplierRequestsRequestCreation(winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SalesChannelRequestAffiliate>>> showSupplierRequestsWithHttpInfo(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SalesChannelRequestAffiliate> localVarReturnType = new ParameterizedTypeReference<SalesChannelRequestAffiliate>(this){};
        return this.showSupplierRequestsRequestCreation(winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierRequestsWithResponseSpec(@Nullable String winkVersion, @Nullable String accept) throws WebClientResponseException {
        return this.showSupplierRequestsRequestCreation(winkVersion, accept);
    }
}

