/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.sales.channel.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "createdDate", "lastUpdate", "version", "status", "requestType", "supplierIdentifier", "supplierName", "subType", "ownerIdentifier", "ownerName", "introductoryMessage"})
public class SalesChannelRequest {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    @Nullable
    private LocalDateTime createdDate;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    @Nullable
    private LocalDateTime lastUpdate;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    @Nonnull
    private RequestTypeEnum requestType;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    @Nonnull
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
    @Nonnull
    private String supplierName;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    @Nonnull
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    @Nonnull
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
    @Nonnull
    private String ownerName;
    public static final String JSON_PROPERTY_INTRODUCTORY_MESSAGE = "introductoryMessage";
    @Nonnull
    private String introductoryMessage;

    public SalesChannelRequest id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public SalesChannelRequest createdDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(@Nullable LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public SalesChannelRequest lastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdate(@Nullable LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public SalesChannelRequest version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public SalesChannelRequest status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public SalesChannelRequest requestType(@Nonnull RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="requestType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRequestType(@Nonnull RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    public SalesChannelRequest supplierIdentifier(@Nonnull UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(@Nonnull UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public SalesChannelRequest supplierName(@Nonnull String supplierName) {
        this.supplierName = supplierName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getSupplierName() {
        return this.supplierName;
    }

    @JsonProperty(value="supplierName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierName(@Nonnull String supplierName) {
        this.supplierName = supplierName;
    }

    public SalesChannelRequest subType(@Nonnull SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubType(@Nonnull SubTypeEnum subType) {
        this.subType = subType;
    }

    public SalesChannelRequest ownerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public SalesChannelRequest ownerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getOwnerName() {
        return this.ownerName;
    }

    @JsonProperty(value="ownerName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerName(@Nonnull String ownerName) {
        this.ownerName = ownerName;
    }

    public SalesChannelRequest introductoryMessage(@Nonnull String introductoryMessage) {
        this.introductoryMessage = introductoryMessage;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="introductoryMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getIntroductoryMessage() {
        return this.introductoryMessage;
    }

    @JsonProperty(value="introductoryMessage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIntroductoryMessage(@Nonnull String introductoryMessage) {
        this.introductoryMessage = introductoryMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesChannelRequest salesChannelRequest = (SalesChannelRequest)o;
        return Objects.equals(this.id, salesChannelRequest.id) && Objects.equals(this.createdDate, salesChannelRequest.createdDate) && Objects.equals(this.lastUpdate, salesChannelRequest.lastUpdate) && Objects.equals(this.version, salesChannelRequest.version) && Objects.equals((Object)this.status, (Object)salesChannelRequest.status) && Objects.equals((Object)this.requestType, (Object)salesChannelRequest.requestType) && Objects.equals(this.supplierIdentifier, salesChannelRequest.supplierIdentifier) && Objects.equals(this.supplierName, salesChannelRequest.supplierName) && Objects.equals((Object)this.subType, (Object)salesChannelRequest.subType) && Objects.equals(this.ownerIdentifier, salesChannelRequest.ownerIdentifier) && Objects.equals(this.ownerName, salesChannelRequest.ownerName) && Objects.equals(this.introductoryMessage, salesChannelRequest.introductoryMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdDate, this.lastUpdate, this.version, this.status, this.requestType, this.supplierIdentifier, this.supplierName, this.subType, this.ownerIdentifier, this.ownerName, this.introductoryMessage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesChannelRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    supplierName: ").append(this.toIndentedString(this.supplierName)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    introductoryMessage: ").append(this.toIndentedString(this.introductoryMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        REQUESTING(String.valueOf("REQUESTING")),
        REJECTED(String.valueOf("REJECTED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestTypeEnum {
        DIRECT_CONNECTION(String.valueOf("DIRECT_CONNECTION"));

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestTypeEnum fromValue(String value) {
            for (RequestTypeEnum b : RequestTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SubTypeEnum {
        DIRECT(String.valueOf("DIRECT")),
        APPLICATION(String.valueOf("APPLICATION")),
        HOTEL(String.valueOf("HOTEL")),
        TRAVELIKO(String.valueOf("TRAVELIKO")),
        CORPORATE(String.valueOf("CORPORATE")),
        TRAVEL_AGENT(String.valueOf("TRAVEL_AGENT")),
        INFLUENCER(String.valueOf("INFLUENCER")),
        BLOGGER(String.valueOf("BLOGGER")),
        DESTINATION(String.valueOf("DESTINATION")),
        CHANNEL_MANAGER(String.valueOf("CHANNEL_MANAGER")),
        PROPERTY_MANAGEMENT_SYSTEM(String.valueOf("PROPERTY_MANAGEMENT_SYSTEM")),
        CENTRAL_RESERVATION_SYSTEM(String.valueOf("CENTRAL_RESERVATION_SYSTEM")),
        GOOGLE_HOTEL_API(String.valueOf("GOOGLE_HOTEL_API")),
        MANAGEMENT_COMPANY(String.valueOf("MANAGEMENT_COMPANY")),
        CHAIN(String.valueOf("CHAIN")),
        BRAND(String.valueOf("BRAND")),
        EVENT_ORGANIZER(String.valueOf("EVENT_ORGANIZER"));

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

