/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The selected axis range. If set, the axis selection is enabled. The range is index-based, starting from zero. Categories with indexes in the range (&#x60;select.from&#x60;, &#x60;select.to&#x60;) will be selected. That is, the last category in the range will not be included in the selection. If the categories are dates, the range has to be also specified with date values. Selection is only supported if the axis is horizontal.
 */
@ApiModel(description = "The selected axis range. If set, the axis selection is enabled. The range is index-based, starting from zero. Categories with indexes in the range (`select.from`, `select.to`) will be selected. That is, the last category in the range will not be included in the selection. If the categories are dates, the range has to be also specified with date values. Selection is only supported if the axis is horizontal.")
@JsonPropertyOrder({
  CategoryAxisSelect.JSON_PROPERTY_FROM,
  CategoryAxisSelect.JSON_PROPERTY_MAX,
  CategoryAxisSelect.JSON_PROPERTY_MIN,
  CategoryAxisSelect.JSON_PROPERTY_MOUSEWHEEL,
  CategoryAxisSelect.JSON_PROPERTY_TO
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:58:57.697473+07:00[Asia/Bangkok]")
public class CategoryAxisSelect {
  public static final String JSON_PROPERTY_FROM = "from";
  private Object from;

  public static final String JSON_PROPERTY_MAX = "max";
  private Object max;

  public static final String JSON_PROPERTY_MIN = "min";
  private Object min;

  public static final String JSON_PROPERTY_MOUSEWHEEL = "mousewheel";
  private Object mousewheel;

  public static final String JSON_PROPERTY_TO = "to";
  private Object to;

  public CategoryAxisSelect() { 
  }

  public CategoryAxisSelect from(Object from) {
    
    this.from = from;
    return this;
  }

   /**
   * Get from
   * @return from
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(Object from) {
    this.from = from;
  }


  public CategoryAxisSelect max(Object max) {
    
    this.max = max;
    return this;
  }

   /**
   * Get max
   * @return max
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMax() {
    return max;
  }


  @JsonProperty(JSON_PROPERTY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMax(Object max) {
    this.max = max;
  }


  public CategoryAxisSelect min(Object min) {
    
    this.min = min;
    return this;
  }

   /**
   * Get min
   * @return min
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMin() {
    return min;
  }


  @JsonProperty(JSON_PROPERTY_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMin(Object min) {
    this.min = min;
  }


  public CategoryAxisSelect mousewheel(Object mousewheel) {
    
    this.mousewheel = mousewheel;
    return this;
  }

   /**
   * Get mousewheel
   * @return mousewheel
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_MOUSEWHEEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getMousewheel() {
    return mousewheel;
  }


  @JsonProperty(JSON_PROPERTY_MOUSEWHEEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMousewheel(Object mousewheel) {
    this.mousewheel = mousewheel;
  }


  public CategoryAxisSelect to(Object to) {
    
    this.to = to;
    return this;
  }

   /**
   * Get to
   * @return to
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(Object to) {
    this.to = to;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisSelect categoryAxisSelect = (CategoryAxisSelect) o;
    return Objects.equals(this.from, categoryAxisSelect.from) &&
        Objects.equals(this.max, categoryAxisSelect.max) &&
        Objects.equals(this.min, categoryAxisSelect.min) &&
        Objects.equals(this.mousewheel, categoryAxisSelect.mousewheel) &&
        Objects.equals(this.to, categoryAxisSelect.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, max, min, mousewheel, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisSelect {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    mousewheel: ").append(toIndentedString(mousewheel)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

