/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * LeaderboardRequest
 */
@JsonPropertyOrder({
  LeaderboardRequest.JSON_PROPERTY_PAGE,
  LeaderboardRequest.JSON_PROPERTY_SIZE,
  LeaderboardRequest.JSON_PROPERTY_CURRENCY_CODE,
  LeaderboardRequest.JSON_PROPERTY_TYPE,
  LeaderboardRequest.JSON_PROPERTY_GROUPING_IDENTIFIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:58:57.697473+07:00[Asia/Bangkok]")
public class LeaderboardRequest {
  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public static final String JSON_PROPERTY_SIZE = "size";
  private Integer size = 100;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  private String currencyCode = "USD";

  /**
   * The type of leaderboard to display
   */
  public enum TypeEnum {
    GLOBAL("GLOBAL"),
    
    CONTINENT("CONTINENT"),
    
    COUNTRY("COUNTRY"),
    
    CITY("CITY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type = TypeEnum.GLOBAL;

  public static final String JSON_PROPERTY_GROUPING_IDENTIFIER = "groupingIdentifier";
  private String groupingIdentifier;

  public LeaderboardRequest() { 
  }

  public LeaderboardRequest page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * Which page to access in the record set
   * minimum: 0
   * @return page
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Min(0)  @ApiModelProperty(example = "0", required = true, value = "Which page to access in the record set")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public LeaderboardRequest size(Integer size) {
    
    this.size = size;
    return this;
  }

   /**
   * Number of result set to retrieve
   * maximum: 100
   * @return size
  **/
  @javax.annotation.Nonnull
  @NotNull
 @Max(100)  @ApiModelProperty(example = "20", required = true, value = "Number of result set to retrieve")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSize(Integer size) {
    this.size = size;
  }


  public LeaderboardRequest currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Display leaderboard values in this currency
   * @return currencyCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "USD", required = true, value = "Display leaderboard values in this currency")
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }


  public LeaderboardRequest type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of leaderboard to display
   * @return type
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "GLOBAL", required = true, value = "The type of leaderboard to display")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public LeaderboardRequest groupingIdentifier(String groupingIdentifier) {
    
    this.groupingIdentifier = groupingIdentifier;
    return this;
  }

   /**
   * Can be &#x60;continent&#x60;, &#x60;country.geoNameId&#x60; or &#x60;city.geoNameId&#x60;
   * @return groupingIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "654321", value = "Can be `continent`, `country.geoNameId` or `city.geoNameId`")
  @JsonProperty(JSON_PROPERTY_GROUPING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGroupingIdentifier() {
    return groupingIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_GROUPING_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGroupingIdentifier(String groupingIdentifier) {
    this.groupingIdentifier = groupingIdentifier;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LeaderboardRequest leaderboardRequest = (LeaderboardRequest) o;
    return Objects.equals(this.page, leaderboardRequest.page) &&
        Objects.equals(this.size, leaderboardRequest.size) &&
        Objects.equals(this.currencyCode, leaderboardRequest.currencyCode) &&
        Objects.equals(this.type, leaderboardRequest.type) &&
        Objects.equals(this.groupingIdentifier, leaderboardRequest.groupingIdentifier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(page, size, currencyCode, type, groupingIdentifier);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LeaderboardRequest {\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    groupingIdentifier: ").append(toIndentedString(groupingIdentifier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

