/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import travel.wink.affiliate.model.EngineConfigurationTheme;
import travel.wink.affiliate.model.Multimedia;
import travel.wink.affiliate.model.RoomConfiguration;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SaveEngineConfigurationRequest
 */
@JsonPropertyOrder({
  SaveEngineConfigurationRequest.JSON_PROPERTY_NAME,
  SaveEngineConfigurationRequest.JSON_PROPERTY_APPEND_TO_PAGE_TITLE,
  SaveEngineConfigurationRequest.JSON_PROPERTY_FACEBOOK_API_TOKEN,
  SaveEngineConfigurationRequest.JSON_PROPERTY_GOOGLE_OAUTH_TOKEN,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_FACEBOOK_API_TOKEN,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_GOOGLE_OAUTH_TOKEN,
  SaveEngineConfigurationRequest.JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_TAWK_TO_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_TAWK_TO_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_RECAPTCHA3_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_RECAPTCHA3_SECRET_KEY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_DEFAULT_CURRENCY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_DEFAULT_LANGUAGE,
  SaveEngineConfigurationRequest.JSON_PROPERTY_LOGOS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  SaveEngineConfigurationRequest.JSON_PROPERTY_SELF_HOSTED,
  SaveEngineConfigurationRequest.JSON_PROPERTY_THEME_COLORS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_START_DATE,
  SaveEngineConfigurationRequest.JSON_PROPERTY_END_DATE,
  SaveEngineConfigurationRequest.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_USE_DAYS,
  SaveEngineConfigurationRequest.JSON_PROPERTY_PROMOTIONAL_CODES,
  SaveEngineConfigurationRequest.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  SaveEngineConfigurationRequest.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  SaveEngineConfigurationRequest.JSON_PROPERTY_WC_BOOK_CLICK_ACTION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:58:57.697473+07:00[Asia/Bangkok]")
public class SaveEngineConfigurationRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_APPEND_TO_PAGE_TITLE = "appendToPageTitle";
  private String appendToPageTitle;

  public static final String JSON_PROPERTY_FACEBOOK_API_TOKEN = "facebookApiToken";
  private String facebookApiToken;

  public static final String JSON_PROPERTY_GOOGLE_OAUTH_TOKEN = "googleOauthToken";
  private String googleOauthToken;

  public static final String JSON_PROPERTY_WC_FACEBOOK_API_TOKEN = "wcFacebookApiToken";
  private String wcFacebookApiToken;

  public static final String JSON_PROPERTY_WC_GOOGLE_OAUTH_TOKEN = "wcGoogleOauthToken";
  private String wcGoogleOauthToken;

  public static final String JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY = "googleTagManagerKey";
  private String googleTagManagerKey;

  public static final String JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY = "wcGoogleTagManagerKey";
  private String wcGoogleTagManagerKey;

  public static final String JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY = "googleMapsAPIKey";
  private String googleMapsAPIKey;

  public static final String JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY = "wcGoogleMapsAPIKey";
  private String wcGoogleMapsAPIKey;

  public static final String JSON_PROPERTY_TAWK_TO_KEY = "tawkToKey";
  private String tawkToKey;

  public static final String JSON_PROPERTY_WC_TAWK_TO_KEY = "wcTawkToKey";
  private String wcTawkToKey;

  public static final String JSON_PROPERTY_RECAPTCHA3_KEY = "recaptcha3Key";
  private String recaptcha3Key;

  public static final String JSON_PROPERTY_RECAPTCHA3_SECRET_KEY = "recaptcha3SecretKey";
  private String recaptcha3SecretKey;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  private String defaultLanguage = "en";

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<Multimedia> logos = null;

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  private String hostedBookingEngineUrl = "https://ota.iko.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  private EngineConfigurationTheme themeColors;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfiguration> roomConfigurations = null;

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = null;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  private Boolean sendBookingNotificationEmailsToBooker = true;

  /**
   * Action to complete once a user clicks on the CTA button on inventory.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE("FORWARD_TO_IBE"),
    
    IBE_MODAL("IBE_MODAL");

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  private WcBookClickActionEnum wcBookClickAction;

  public SaveEngineConfigurationRequest() { 
  }

  public SaveEngineConfigurationRequest name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Engine configuration name
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Engine Configuration 1", required = true, value = "Engine configuration name")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SaveEngineConfigurationRequest appendToPageTitle(String appendToPageTitle) {
    
    this.appendToPageTitle = appendToPageTitle;
    return this;
  }

   /**
   * Whether to append text to the existing booking engine page title.
   * @return appendToPageTitle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether to append text to the existing booking engine page title.")
  @JsonProperty(JSON_PROPERTY_APPEND_TO_PAGE_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAppendToPageTitle() {
    return appendToPageTitle;
  }


  @JsonProperty(JSON_PROPERTY_APPEND_TO_PAGE_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppendToPageTitle(String appendToPageTitle) {
    this.appendToPageTitle = appendToPageTitle;
  }


  public SaveEngineConfigurationRequest facebookApiToken(String facebookApiToken) {
    
    this.facebookApiToken = facebookApiToken;
    return this;
  }

   /**
   * Add your Facebook API token here if you want to allow users to be able to log in with their Facebook account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.
   * @return facebookApiToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "fb-app-id-1", value = "Add your Facebook API token here if you want to allow users to be able to log in with their Facebook account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.")
  @JsonProperty(JSON_PROPERTY_FACEBOOK_API_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFacebookApiToken() {
    return facebookApiToken;
  }


  @JsonProperty(JSON_PROPERTY_FACEBOOK_API_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacebookApiToken(String facebookApiToken) {
    this.facebookApiToken = facebookApiToken;
  }


  public SaveEngineConfigurationRequest googleOauthToken(String googleOauthToken) {
    
    this.googleOauthToken = googleOauthToken;
    return this;
  }

   /**
   * Add your Google OAuth token here if you want to allow users to be able to log in with their Google account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.
   * @return googleOauthToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-token-1", value = "Add your Google OAuth token here if you want to allow users to be able to log in with their Google account on your self-hosted booking engine. Only applicable when you host our booking engine on your domain.")
  @JsonProperty(JSON_PROPERTY_GOOGLE_OAUTH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGoogleOauthToken() {
    return googleOauthToken;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_OAUTH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoogleOauthToken(String googleOauthToken) {
    this.googleOauthToken = googleOauthToken;
  }


  public SaveEngineConfigurationRequest wcFacebookApiToken(String wcFacebookApiToken) {
    
    this.wcFacebookApiToken = wcFacebookApiToken;
    return this;
  }

   /**
   * Add a Facebook API token here if you want to allow users to be able to log in with their Facebook account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.
   * @return wcFacebookApiToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "fb-app-id-2", value = "Add a Facebook API token here if you want to allow users to be able to log in with their Facebook account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.")
  @JsonProperty(JSON_PROPERTY_WC_FACEBOOK_API_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWcFacebookApiToken() {
    return wcFacebookApiToken;
  }


  @JsonProperty(JSON_PROPERTY_WC_FACEBOOK_API_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcFacebookApiToken(String wcFacebookApiToken) {
    this.wcFacebookApiToken = wcFacebookApiToken;
  }


  public SaveEngineConfigurationRequest wcGoogleOauthToken(String wcGoogleOauthToken) {
    
    this.wcGoogleOauthToken = wcGoogleOauthToken;
    return this;
  }

   /**
   * Add a Google Oauth token here if you want to allow users to be able to log in with their Google account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.
   * @return wcGoogleOauthToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-token-2", value = "Add a Google Oauth token here if you want to allow users to be able to log in with their Google account directly through one of our embeddable Web Components. Only applicable when you are using our Web Components.")
  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_OAUTH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWcGoogleOauthToken() {
    return wcGoogleOauthToken;
  }


  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_OAUTH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcGoogleOauthToken(String wcGoogleOauthToken) {
    this.wcGoogleOauthToken = wcGoogleOauthToken;
  }


  public SaveEngineConfigurationRequest googleTagManagerKey(String googleTagManagerKey) {
    
    this.googleTagManagerKey = googleTagManagerKey;
    return this;
  }

   /**
   * If you want to track analytics with Google Analytics and GTM for your self-hosted booking engine, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl&#x3D;0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) 
   * @return googleTagManagerKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If you want to track analytics with Google Analytics and GTM for your self-hosted booking engine, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
  @JsonProperty(JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGoogleTagManagerKey() {
    return googleTagManagerKey;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_TAG_MANAGER_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoogleTagManagerKey(String googleTagManagerKey) {
    this.googleTagManagerKey = googleTagManagerKey;
  }


  public SaveEngineConfigurationRequest wcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
    
    this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
    return this;
  }

   /**
   * If you want to track analytics with Google Analytics and GTM for the Web Components you&#39;ve embedded, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl&#x3D;0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) 
   * @return wcGoogleTagManagerKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If you want to track analytics with Google Analytics and GTM for the Web Components you've embedded, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl=0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) ")
  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWcGoogleTagManagerKey() {
    return wcGoogleTagManagerKey;
  }


  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_TAG_MANAGER_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcGoogleTagManagerKey(String wcGoogleTagManagerKey) {
    this.wcGoogleTagManagerKey = wcGoogleTagManagerKey;
  }


  public SaveEngineConfigurationRequest googleMapsAPIKey(String googleMapsAPIKey) {
    
    this.googleMapsAPIKey = googleMapsAPIKey;
    return this;
  }

   /**
   * If you want your users to see Google Maps in your hosted booking engine, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview&#x3D;project) and create an API key for your site.
   * @return googleMapsAPIKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-maps-api-123", value = "If you want your users to see Google Maps in your hosted booking engine, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGoogleMapsAPIKey() {
    return googleMapsAPIKey;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoogleMapsAPIKey(String googleMapsAPIKey) {
    this.googleMapsAPIKey = googleMapsAPIKey;
  }


  public SaveEngineConfigurationRequest wcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
    
    this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
    return this;
  }

   /**
   * If you want your users to see Google Maps in any of our Web Components, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview&#x3D;project) and create an API key for your site.
   * @return wcGoogleMapsAPIKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-maps-api-321", value = "If you want your users to see Google Maps in any of our Web Components, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview=project) and create an API key for your site.")
  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWcGoogleMapsAPIKey() {
    return wcGoogleMapsAPIKey;
  }


  @JsonProperty(JSON_PROPERTY_WC_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcGoogleMapsAPIKey(String wcGoogleMapsAPIKey) {
    this.wcGoogleMapsAPIKey = wcGoogleMapsAPIKey;
  }


  public SaveEngineConfigurationRequest tawkToKey(String tawkToKey) {
    
    this.tawkToKey = tawkToKey;
    return this;
  }

   /**
   * If you want your users to be able to chat with you on your hosted booking engine, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.
   * @return tawkToKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "tawk-to-1", value = "If you want your users to be able to chat with you on your hosted booking engine, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
  @JsonProperty(JSON_PROPERTY_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTawkToKey() {
    return tawkToKey;
  }


  @JsonProperty(JSON_PROPERTY_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTawkToKey(String tawkToKey) {
    this.tawkToKey = tawkToKey;
  }


  public SaveEngineConfigurationRequest wcTawkToKey(String wcTawkToKey) {
    
    this.wcTawkToKey = wcTawkToKey;
    return this;
  }

   /**
   * If you want your users to be able to chat with in any of our Web Components, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.
   * @return wcTawkToKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "tawk-to-2", value = "If you want your users to be able to chat with in any of our Web Components, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.")
  @JsonProperty(JSON_PROPERTY_WC_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWcTawkToKey() {
    return wcTawkToKey;
  }


  @JsonProperty(JSON_PROPERTY_WC_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcTawkToKey(String wcTawkToKey) {
    this.wcTawkToKey = wcTawkToKey;
  }


  public SaveEngineConfigurationRequest recaptcha3Key(String recaptcha3Key) {
    
    this.recaptcha3Key = recaptcha3Key;
    return this;
  }

   /**
   * Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add it here.
   * @return recaptcha3Key
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-recaptcha-key-1", value = "Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add it here.")
  @JsonProperty(JSON_PROPERTY_RECAPTCHA3_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecaptcha3Key() {
    return recaptcha3Key;
  }


  @JsonProperty(JSON_PROPERTY_RECAPTCHA3_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecaptcha3Key(String recaptcha3Key) {
    this.recaptcha3Key = recaptcha3Key;
  }


  public SaveEngineConfigurationRequest recaptcha3SecretKey(String recaptcha3SecretKey) {
    
    this.recaptcha3SecretKey = recaptcha3SecretKey;
    return this;
  }

   /**
   * Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add the secret key here.
   * @return recaptcha3SecretKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "google-recaptcha-key-1", value = "Our platform protects against fraud with [Google ReCaptcha v3](https://developers.google.com/recaptcha/docs/v3). If you are self-hosting our booking engine, you need to create an API key with them and add the secret key here.")
  @JsonProperty(JSON_PROPERTY_RECAPTCHA3_SECRET_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecaptcha3SecretKey() {
    return recaptcha3SecretKey;
  }


  @JsonProperty(JSON_PROPERTY_RECAPTCHA3_SECRET_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecaptcha3SecretKey(String recaptcha3SecretKey) {
    this.recaptcha3SecretKey = recaptcha3SecretKey;
  }


  public SaveEngineConfigurationRequest defaultCurrency(String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

   /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "USD", value = "Control which currency your users see prices in initially.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }


  public SaveEngineConfigurationRequest defaultLanguage(String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

   /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en", value = "Control which language your users see text in initially.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }


  public SaveEngineConfigurationRequest logos(List<Multimedia> logos) {
    
    this.logos = logos;
    return this;
  }

  public SaveEngineConfigurationRequest addLogosItem(Multimedia logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Customize booking confirmation emails by adding a custom logo to your configuration.")
  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Multimedia> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<Multimedia> logos) {
    this.logos = logos;
  }


  public SaveEngineConfigurationRequest hostedBookingEngineUrl(String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

   /**
   * If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://my.customtravelsite.com/book", value = "If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.")
  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }


  public SaveEngineConfigurationRequest selfHosted(Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

   /**
   * Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.
   * @return selfHosted
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.")
  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }


  public SaveEngineConfigurationRequest themeColors(EngineConfigurationTheme themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

   /**
   * Get themeColors
   * @return themeColors
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationTheme getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(EngineConfigurationTheme themeColors) {
    this.themeColors = themeColors;
  }


  public SaveEngineConfigurationRequest numberOfAdvanceDays(Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }


  public SaveEngineConfigurationRequest numberOfStayDays(Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today's date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don't use either of these options, the itinerary will default to today's date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave `startDate` and `endDate` empty.")
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }


  public SaveEngineConfigurationRequest startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 24 07:00:00 ICT 2021", value = "Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public SaveEngineConfigurationRequest endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Fri Dec 31 07:00:00 ICT 2021", value = "Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave `numberOfAdvanceDays` and `numberOfStayDays` empty.")
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public SaveEngineConfigurationRequest roomConfigurations(List<RoomConfiguration> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public SaveEngineConfigurationRequest addRoomConfigurationsItem(RoomConfiguration roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.")
  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomConfiguration> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(List<RoomConfiguration> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public SaveEngineConfigurationRequest useDays(Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

   /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate")
  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(Boolean useDays) {
    this.useDays = useDays;
  }


  public SaveEngineConfigurationRequest promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public SaveEngineConfigurationRequest addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"promo-1\"]", value = "If you've received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.")
  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public SaveEngineConfigurationRequest sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "An integrator can choose to disable outgoing emails to properties because they want to do that themselves.")
  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }


  public SaveEngineConfigurationRequest sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "An integrator can choose to disable outgoing emails to users because they want to do that themselves.")
  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }


  public SaveEngineConfigurationRequest wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

   /**
   * Action to complete once a user clicks on the CTA button on inventory.
   * @return wcBookClickAction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "IBE_MODAL", value = "Action to complete once a user clicks on the CTA button on inventory.")
  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveEngineConfigurationRequest saveEngineConfigurationRequest = (SaveEngineConfigurationRequest) o;
    return Objects.equals(this.name, saveEngineConfigurationRequest.name) &&
        Objects.equals(this.appendToPageTitle, saveEngineConfigurationRequest.appendToPageTitle) &&
        Objects.equals(this.facebookApiToken, saveEngineConfigurationRequest.facebookApiToken) &&
        Objects.equals(this.googleOauthToken, saveEngineConfigurationRequest.googleOauthToken) &&
        Objects.equals(this.wcFacebookApiToken, saveEngineConfigurationRequest.wcFacebookApiToken) &&
        Objects.equals(this.wcGoogleOauthToken, saveEngineConfigurationRequest.wcGoogleOauthToken) &&
        Objects.equals(this.googleTagManagerKey, saveEngineConfigurationRequest.googleTagManagerKey) &&
        Objects.equals(this.wcGoogleTagManagerKey, saveEngineConfigurationRequest.wcGoogleTagManagerKey) &&
        Objects.equals(this.googleMapsAPIKey, saveEngineConfigurationRequest.googleMapsAPIKey) &&
        Objects.equals(this.wcGoogleMapsAPIKey, saveEngineConfigurationRequest.wcGoogleMapsAPIKey) &&
        Objects.equals(this.tawkToKey, saveEngineConfigurationRequest.tawkToKey) &&
        Objects.equals(this.wcTawkToKey, saveEngineConfigurationRequest.wcTawkToKey) &&
        Objects.equals(this.recaptcha3Key, saveEngineConfigurationRequest.recaptcha3Key) &&
        Objects.equals(this.recaptcha3SecretKey, saveEngineConfigurationRequest.recaptcha3SecretKey) &&
        Objects.equals(this.defaultCurrency, saveEngineConfigurationRequest.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, saveEngineConfigurationRequest.defaultLanguage) &&
        Objects.equals(this.logos, saveEngineConfigurationRequest.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, saveEngineConfigurationRequest.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, saveEngineConfigurationRequest.selfHosted) &&
        Objects.equals(this.themeColors, saveEngineConfigurationRequest.themeColors) &&
        Objects.equals(this.numberOfAdvanceDays, saveEngineConfigurationRequest.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, saveEngineConfigurationRequest.numberOfStayDays) &&
        Objects.equals(this.startDate, saveEngineConfigurationRequest.startDate) &&
        Objects.equals(this.endDate, saveEngineConfigurationRequest.endDate) &&
        Objects.equals(this.roomConfigurations, saveEngineConfigurationRequest.roomConfigurations) &&
        Objects.equals(this.useDays, saveEngineConfigurationRequest.useDays) &&
        Objects.equals(this.promotionalCodes, saveEngineConfigurationRequest.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, saveEngineConfigurationRequest.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, saveEngineConfigurationRequest.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.wcBookClickAction, saveEngineConfigurationRequest.wcBookClickAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, appendToPageTitle, facebookApiToken, googleOauthToken, wcFacebookApiToken, wcGoogleOauthToken, googleTagManagerKey, wcGoogleTagManagerKey, googleMapsAPIKey, wcGoogleMapsAPIKey, tawkToKey, wcTawkToKey, recaptcha3Key, recaptcha3SecretKey, defaultCurrency, defaultLanguage, logos, hostedBookingEngineUrl, selfHosted, themeColors, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, wcBookClickAction);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveEngineConfigurationRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    appendToPageTitle: ").append(toIndentedString(appendToPageTitle)).append("\n");
    sb.append("    facebookApiToken: ").append(toIndentedString(facebookApiToken)).append("\n");
    sb.append("    googleOauthToken: ").append(toIndentedString(googleOauthToken)).append("\n");
    sb.append("    wcFacebookApiToken: ").append(toIndentedString(wcFacebookApiToken)).append("\n");
    sb.append("    wcGoogleOauthToken: ").append(toIndentedString(wcGoogleOauthToken)).append("\n");
    sb.append("    googleTagManagerKey: ").append(toIndentedString(googleTagManagerKey)).append("\n");
    sb.append("    wcGoogleTagManagerKey: ").append(toIndentedString(wcGoogleTagManagerKey)).append("\n");
    sb.append("    googleMapsAPIKey: ").append(toIndentedString(googleMapsAPIKey)).append("\n");
    sb.append("    wcGoogleMapsAPIKey: ").append(toIndentedString(wcGoogleMapsAPIKey)).append("\n");
    sb.append("    tawkToKey: ").append(toIndentedString(tawkToKey)).append("\n");
    sb.append("    wcTawkToKey: ").append(toIndentedString(wcTawkToKey)).append("\n");
    sb.append("    recaptcha3Key: ").append(toIndentedString(recaptcha3Key)).append("\n");
    sb.append("    recaptcha3SecretKey: ").append(toIndentedString(recaptcha3SecretKey)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

