/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * How user likes to have results displayed
 */
@ApiModel(description = "How user likes to have results displayed")
@JsonPropertyOrder({
  SearchFilters.JSON_PROPERTY_MAX_DISTANCE,
  SearchFilters.JSON_PROPERTY_LIFESTYLE,
  SearchFilters.JSON_PROPERTY_STAR_RATING
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-24T12:58:57.697473+07:00[Asia/Bangkok]")
public class SearchFilters {
  public static final String JSON_PROPERTY_MAX_DISTANCE = "maxDistance";
  private Double maxDistance;

  /**
   * A user can filter inventory on a lifestyle
   */
  public enum LifestyleEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleEnum fromValue(String value) {
      for (LifestyleEnum b : LifestyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE = "lifestyle";
  private LifestyleEnum lifestyle;

  public static final String JSON_PROPERTY_STAR_RATING = "starRating";
  private Integer starRating;

  public SearchFilters() { 
  }

  public SearchFilters maxDistance(Double maxDistance) {
    
    this.maxDistance = maxDistance;
    return this;
  }

   /**
   * A user can query for hotels that are close to UserSession.location
   * @return maxDistance
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "A user can query for hotels that are close to UserSession.location")
  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Double getMaxDistance() {
    return maxDistance;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDistance(Double maxDistance) {
    this.maxDistance = maxDistance;
  }


  public SearchFilters lifestyle(LifestyleEnum lifestyle) {
    
    this.lifestyle = lifestyle;
    return this;
  }

   /**
   * A user can filter inventory on a lifestyle
   * @return lifestyle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_RELAX", value = "A user can filter inventory on a lifestyle")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleEnum getLifestyle() {
    return lifestyle;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyle(LifestyleEnum lifestyle) {
    this.lifestyle = lifestyle;
  }


  public SearchFilters starRating(Integer starRating) {
    
    this.starRating = starRating;
    return this;
  }

   /**
   * A user can filter on number of hotel stars
   * @return starRating
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4", value = "A user can filter on number of hotel stars")
  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getStarRating() {
    return starRating;
  }


  @JsonProperty(JSON_PROPERTY_STAR_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStarRating(Integer starRating) {
    this.starRating = starRating;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchFilters searchFilters = (SearchFilters) o;
    return Objects.equals(this.maxDistance, searchFilters.maxDistance) &&
        Objects.equals(this.lifestyle, searchFilters.lifestyle) &&
        Objects.equals(this.starRating, searchFilters.starRating);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxDistance, lifestyle, starRating);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchFilters {\n");
    sb.append("    maxDistance: ").append(toIndentedString(maxDistance)).append("\n");
    sb.append("    lifestyle: ").append(toIndentedString(lifestyle)).append("\n");
    sb.append("    starRating: ").append(toIndentedString(starRating)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

