/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.affiliate.model.Moneys;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * BookingLeaderboardEntry
 */
@JsonPropertyOrder({
  BookingLeaderboardEntry.JSON_PROPERTY_OWNER_IDENTIFIER,
  BookingLeaderboardEntry.JSON_PROPERTY_OWNER_NAME,
  BookingLeaderboardEntry.JSON_PROPERTY_CONTINENT,
  BookingLeaderboardEntry.JSON_PROPERTY_COUNTRY,
  BookingLeaderboardEntry.JSON_PROPERTY_CITY,
  BookingLeaderboardEntry.JSON_PROPERTY_BOOKINGS,
  BookingLeaderboardEntry.JSON_PROPERTY_TOTAL_AMOUNT,
  BookingLeaderboardEntry.JSON_PROPERTY_AVERAGE_AMOUNT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:28:27.095811+07:00[Asia/Bangkok]")
public class BookingLeaderboardEntry {
  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private String ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CONTINENT = "continent";
  private String continent;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_BOOKINGS = "bookings";
  private Long bookings;

  public static final String JSON_PROPERTY_TOTAL_AMOUNT = "totalAmount";
  private Moneys totalAmount;

  public static final String JSON_PROPERTY_AVERAGE_AMOUNT = "averageAmount";
  private Moneys averageAmount;

  public BookingLeaderboardEntry() { 
  }

  public BookingLeaderboardEntry ownerIdentifier(String ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Get ownerIdentifier
   * @return ownerIdentifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(String ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public BookingLeaderboardEntry ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Get ownerName
   * @return ownerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public BookingLeaderboardEntry continent(String continent) {
    
    this.continent = continent;
    return this;
  }

   /**
   * Get continent
   * @return continent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinent() {
    return continent;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinent(String continent) {
    this.continent = continent;
  }


  public BookingLeaderboardEntry country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Get country
   * @return country
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public BookingLeaderboardEntry city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public BookingLeaderboardEntry bookings(Long bookings) {
    
    this.bookings = bookings;
    return this;
  }

   /**
   * Get bookings
   * @return bookings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getBookings() {
    return bookings;
  }


  @JsonProperty(JSON_PROPERTY_BOOKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookings(Long bookings) {
    this.bookings = bookings;
  }


  public BookingLeaderboardEntry totalAmount(Moneys totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * Get totalAmount
   * @return totalAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getTotalAmount() {
    return totalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAmount(Moneys totalAmount) {
    this.totalAmount = totalAmount;
  }


  public BookingLeaderboardEntry averageAmount(Moneys averageAmount) {
    
    this.averageAmount = averageAmount;
    return this;
  }

   /**
   * Get averageAmount
   * @return averageAmount
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVERAGE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Moneys getAverageAmount() {
    return averageAmount;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageAmount(Moneys averageAmount) {
    this.averageAmount = averageAmount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingLeaderboardEntry bookingLeaderboardEntry = (BookingLeaderboardEntry) o;
    return Objects.equals(this.ownerIdentifier, bookingLeaderboardEntry.ownerIdentifier) &&
        Objects.equals(this.ownerName, bookingLeaderboardEntry.ownerName) &&
        Objects.equals(this.continent, bookingLeaderboardEntry.continent) &&
        Objects.equals(this.country, bookingLeaderboardEntry.country) &&
        Objects.equals(this.city, bookingLeaderboardEntry.city) &&
        Objects.equals(this.bookings, bookingLeaderboardEntry.bookings) &&
        Objects.equals(this.totalAmount, bookingLeaderboardEntry.totalAmount) &&
        Objects.equals(this.averageAmount, bookingLeaderboardEntry.averageAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerIdentifier, ownerName, continent, country, city, bookings, totalAmount, averageAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingLeaderboardEntry {\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    continent: ").append(toIndentedString(continent)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    bookings: ").append(toIndentedString(bookings)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    averageAmount: ").append(toIndentedString(averageAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

