/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GeoIP
 */
@JsonPropertyOrder({
  GeoIP.JSON_PROPERTY_GEO_NAME_ID,
  GeoIP.JSON_PROPERTY_LOCALE_CODE,
  GeoIP.JSON_PROPERTY_CONTINENT_CODE,
  GeoIP.JSON_PROPERTY_CONTINENT_NAME,
  GeoIP.JSON_PROPERTY_COUNTRY_ISO_CODE,
  GeoIP.JSON_PROPERTY_COUNTRY_NAME,
  GeoIP.JSON_PROPERTY_CITY_NAME,
  GeoIP.JSON_PROPERTY_TIMEZONE,
  GeoIP.JSON_PROPERTY_SUB_DIVISION1_CODE,
  GeoIP.JSON_PROPERTY_SUB_DIVISION1_NAME,
  GeoIP.JSON_PROPERTY_SUB_DIVISION2_CODE,
  GeoIP.JSON_PROPERTY_SUB_DIVISION2_NAME
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:28:27.095811+07:00[Asia/Bangkok]")
public class GeoIP {
  public static final String JSON_PROPERTY_GEO_NAME_ID = "geoNameId";
  private String geoNameId;

  public static final String JSON_PROPERTY_LOCALE_CODE = "localeCode";
  private String localeCode;

  public static final String JSON_PROPERTY_CONTINENT_CODE = "continentCode";
  private String continentCode;

  public static final String JSON_PROPERTY_CONTINENT_NAME = "continentName";
  private String continentName;

  public static final String JSON_PROPERTY_COUNTRY_ISO_CODE = "countryIsoCode";
  private String countryIsoCode;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  private String timezone;

  public static final String JSON_PROPERTY_SUB_DIVISION1_CODE = "subDivision1Code";
  private String subDivision1Code;

  public static final String JSON_PROPERTY_SUB_DIVISION1_NAME = "subDivision1Name";
  private String subDivision1Name;

  public static final String JSON_PROPERTY_SUB_DIVISION2_CODE = "subDivision2Code";
  private String subDivision2Code;

  public static final String JSON_PROPERTY_SUB_DIVISION2_NAME = "subDivision2Name";
  private String subDivision2Name;

  public GeoIP() { 
  }

  public GeoIP geoNameId(String geoNameId) {
    
    this.geoNameId = geoNameId;
    return this;
  }

   /**
   * GeoName identifiers taken from [https://geonames.org](https://geonames.org).
   * @return geoNameId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "8798734", value = "GeoName identifiers taken from [https://geonames.org](https://geonames.org).")
  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGeoNameId() {
    return geoNameId;
  }


  @JsonProperty(JSON_PROPERTY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGeoNameId(String geoNameId) {
    this.geoNameId = geoNameId;
  }


  public GeoIP localeCode(String localeCode) {
    
    this.localeCode = localeCode;
    return this;
  }

   /**
   * Locale code
   * @return localeCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "en", value = "Locale code")
  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocaleCode() {
    return localeCode;
  }


  @JsonProperty(JSON_PROPERTY_LOCALE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocaleCode(String localeCode) {
    this.localeCode = localeCode;
  }


  public GeoIP continentCode(String continentCode) {
    
    this.continentCode = continentCode;
    return this;
  }

   /**
   * Continent code
   * @return continentCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NA", value = "Continent code")
  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentCode() {
    return continentCode;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentCode(String continentCode) {
    this.continentCode = continentCode;
  }


  public GeoIP continentName(String continentName) {
    
    this.continentName = continentName;
    return this;
  }

   /**
   * Continent name
   * @return continentName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "North America", value = "Continent name")
  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContinentName() {
    return continentName;
  }


  @JsonProperty(JSON_PROPERTY_CONTINENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContinentName(String continentName) {
    this.continentName = continentName;
  }


  public GeoIP countryIsoCode(String countryIsoCode) {
    
    this.countryIsoCode = countryIsoCode;
    return this;
  }

   /**
   * Country ISO code
   * @return countryIsoCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "Country ISO code")
  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryIsoCode() {
    return countryIsoCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_ISO_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryIsoCode(String countryIsoCode) {
    this.countryIsoCode = countryIsoCode;
  }


  public GeoIP countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country name
   * @return countryName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "United States", value = "Country name")
  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public GeoIP cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * City name
   * @return cityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "New York", value = "City name")
  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public GeoIP timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "America/New_York", value = "Timezone")
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public GeoIP subDivision1Code(String subDivision1Code) {
    
    this.subDivision1Code = subDivision1Code;
    return this;
  }

   /**
   * Sub-division 1 code
   * @return subDivision1Code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NY", value = "Sub-division 1 code")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Code() {
    return subDivision1Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Code(String subDivision1Code) {
    this.subDivision1Code = subDivision1Code;
  }


  public GeoIP subDivision1Name(String subDivision1Name) {
    
    this.subDivision1Name = subDivision1Name;
    return this;
  }

   /**
   * Sub-division 1 name
   * @return subDivision1Name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "NY", value = "Sub-division 1 name")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision1Name() {
    return subDivision1Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION1_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision1Name(String subDivision1Name) {
    this.subDivision1Name = subDivision1Name;
  }


  public GeoIP subDivision2Code(String subDivision2Code) {
    
    this.subDivision2Code = subDivision2Code;
    return this;
  }

   /**
   * Sub-division 2 code
   * @return subDivision2Code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sub-division 2 code")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Code() {
    return subDivision2Code;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Code(String subDivision2Code) {
    this.subDivision2Code = subDivision2Code;
  }


  public GeoIP subDivision2Name(String subDivision2Name) {
    
    this.subDivision2Name = subDivision2Name;
    return this;
  }

   /**
   * Sub-division 2 name
   * @return subDivision2Name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sub-division 2 name")
  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubDivision2Name() {
    return subDivision2Name;
  }


  @JsonProperty(JSON_PROPERTY_SUB_DIVISION2_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubDivision2Name(String subDivision2Name) {
    this.subDivision2Name = subDivision2Name;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeoIP geoIP = (GeoIP) o;
    return Objects.equals(this.geoNameId, geoIP.geoNameId) &&
        Objects.equals(this.localeCode, geoIP.localeCode) &&
        Objects.equals(this.continentCode, geoIP.continentCode) &&
        Objects.equals(this.continentName, geoIP.continentName) &&
        Objects.equals(this.countryIsoCode, geoIP.countryIsoCode) &&
        Objects.equals(this.countryName, geoIP.countryName) &&
        Objects.equals(this.cityName, geoIP.cityName) &&
        Objects.equals(this.timezone, geoIP.timezone) &&
        Objects.equals(this.subDivision1Code, geoIP.subDivision1Code) &&
        Objects.equals(this.subDivision1Name, geoIP.subDivision1Name) &&
        Objects.equals(this.subDivision2Code, geoIP.subDivision2Code) &&
        Objects.equals(this.subDivision2Name, geoIP.subDivision2Name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(geoNameId, localeCode, continentCode, continentName, countryIsoCode, countryName, cityName, timezone, subDivision1Code, subDivision1Name, subDivision2Code, subDivision2Name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeoIP {\n");
    sb.append("    geoNameId: ").append(toIndentedString(geoNameId)).append("\n");
    sb.append("    localeCode: ").append(toIndentedString(localeCode)).append("\n");
    sb.append("    continentCode: ").append(toIndentedString(continentCode)).append("\n");
    sb.append("    continentName: ").append(toIndentedString(continentName)).append("\n");
    sb.append("    countryIsoCode: ").append(toIndentedString(countryIsoCode)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    subDivision1Code: ").append(toIndentedString(subDivision1Code)).append("\n");
    sb.append("    subDivision1Name: ").append(toIndentedString(subDivision1Name)).append("\n");
    sb.append("    subDivision2Code: ").append(toIndentedString(subDivision2Code)).append("\n");
    sb.append("    subDivision2Name: ").append(toIndentedString(subDivision2Name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

