/*
 * Iko.travel
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/docs?api=affiliate): All APIs related to selling travel inventory as an affiliate. - [Extranet](/docs?api=extranet): All APIs related to managing travel inventory and suppliers. - [Booking Engine](/docs?api=booking-engine): All APIs related to searching for travel inventory and creating bookings. - [Channel Manager](/docs?api=channel-manager): All APIs related to channel managers who want to integrate with our platform.  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic. We will link to SDKs for the most popular programming languages on this page as they become available.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Accept` header and by using our custom JSON mime type. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints. You can also choose to always work with the latest major version release by accepting application/json. We recommend the former. Example: application/vnd.platform-v`1`+json.  ## Release history - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale. - If you are a supplier and looking to manage your own inventory on our platform, head over to our [Extranet API](/docs?api=extranet). - If you want to start selling travel inventory, check out our [Booking Engine API](/docs?api=booking-engine).  # Intended Audience Programmers are a requirement to start integrating with iko.travel. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: v1.0.0
 * Contact: bjorn@iko.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import travel.wink.sdk.affiliate.model.HotelOnMap;
import travel.wink.sdk.affiliate.model.Inventory;
import travel.wink.sdk.affiliate.model.StaticSellerList;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * StaticSellerListItem
 */
@JsonPropertyOrder({
  StaticSellerListItem.JSON_PROPERTY_IDENTIFIER,
  StaticSellerListItem.JSON_PROPERTY_PARENT,
  StaticSellerListItem.JSON_PROPERTY_INVENTORY,
  StaticSellerListItem.JSON_PROPERTY_HOTEL,
  StaticSellerListItem.JSON_PROPERTY_SORT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-27T09:28:27.095811+07:00[Asia/Bangkok]")
public class StaticSellerListItem {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private String identifier;

  public static final String JSON_PROPERTY_PARENT = "parent";
  private StaticSellerList parent;

  public static final String JSON_PROPERTY_INVENTORY = "inventory";
  private Inventory inventory;

  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMap hotel;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public StaticSellerListItem() { 
  }

  public StaticSellerListItem identifier(String identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Identifier
   * @return identifier
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }


  public StaticSellerListItem parent(StaticSellerList parent) {
    
    this.parent = parent;
    return this;
  }

   /**
   * Get parent
   * @return parent
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_PARENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StaticSellerList getParent() {
    return parent;
  }


  @JsonProperty(JSON_PROPERTY_PARENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParent(StaticSellerList parent) {
    this.parent = parent;
  }


  public StaticSellerListItem inventory(Inventory inventory) {
    
    this.inventory = inventory;
    return this;
  }

   /**
   * Get inventory
   * @return inventory
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Inventory getInventory() {
    return inventory;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventory(Inventory inventory) {
    this.inventory = inventory;
  }


  public StaticSellerListItem hotel(HotelOnMap hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelOnMap getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotel(HotelOnMap hotel) {
    this.hotel = hotel;
  }


  public StaticSellerListItem sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort key
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sort key")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StaticSellerListItem staticSellerListItem = (StaticSellerListItem) o;
    return Objects.equals(this.identifier, staticSellerListItem.identifier) &&
        Objects.equals(this.parent, staticSellerListItem.parent) &&
        Objects.equals(this.inventory, staticSellerListItem.inventory) &&
        Objects.equals(this.hotel, staticSellerListItem.hotel) &&
        Objects.equals(this.sort, staticSellerListItem.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, parent, inventory, hotel, sort);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StaticSellerListItem {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    parent: ").append(toIndentedString(parent)).append("\n");
    sb.append("    inventory: ").append(toIndentedString(inventory)).append("\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

